/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.genextras.common.tile.naquadah;

import com.jerry.genextras.common.content.naquadah.NaquadahReactorMultiblockData;
import com.jerry.genextras.common.registries.GenExtraBlocks;
import com.jerry.genextras.common.registries.GenExtraDataComponents;
import com.jerry.genextras.common.tile.naquadah.TileEntityNaquadahReactorCasing;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import java.util.Locale;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTranslationKey;
import mekanism.api.text.ILangEntry;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.tile.interfaces.IHasMode;
import mekanism.common.util.NBTUtils;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.base.IReactorLogic;
import mekanism.generators.common.base.IReactorLogicMode;
import mekanism.generators.common.registries.GeneratorsDataComponents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;

public class TileEntityNaquadahReactorLogicAdapter
extends TileEntityNaquadahReactorCasing
implements IReactorLogic<NaquadahReactorLogic>,
IHasMode {
    public NaquadahReactorLogic logicType = NaquadahReactorLogic.DISABLED;
    private boolean activeCooled;
    private boolean prevOutputting;

    public TileEntityNaquadahReactorLogicAdapter(BlockPos pos, BlockState state) {
        super((Holder<Block>)GenExtraBlocks.NAQUADAH_REACTOR_LOGIC_ADAPTER, pos, state);
    }

    protected boolean onUpdateServer(NaquadahReactorMultiblockData multiblock) {
        boolean needsPacket = super.onUpdateServer((MultiblockData)multiblock);
        boolean outputting = this.checkMode();
        if (outputting != this.prevOutputting) {
            Level world = this.getLevel();
            if (world != null) {
                Direction side = multiblock.getOutsideSide(this.worldPosition);
                BlockState state = this.getBlockState();
                if (side == null) {
                    world.updateNeighborsAt(this.getBlockPos(), state.getBlock());
                } else if (!EventHooks.onNeighborNotify((Level)world, (BlockPos)this.worldPosition, (BlockState)state, EnumSet.of(side), (boolean)false).isCanceled()) {
                    world.neighborChanged(this.worldPosition.relative(side), state.getBlock(), this.worldPosition);
                }
            }
            this.prevOutputting = outputting;
        }
        return needsPacket;
    }

    public int getRedstoneLevel(Direction side) {
        return !this.isRemote() && ((NaquadahReactorMultiblockData)this.getMultiblock()).isPositionOutsideBounds(this.worldPosition.relative(side)) && this.checkMode() ? 15 : 0;
    }

    public boolean checkMode() {
        if (this.isRemote()) {
            return this.prevOutputting;
        }
        NaquadahReactorMultiblockData multiblock = (NaquadahReactorMultiblockData)this.getMultiblock();
        if (multiblock.isFormed()) {
            return switch (this.logicType.ordinal()) {
                default -> throw new MatchException(null, null);
                case 1 -> {
                    if (multiblock.getLastPlasmaTemp() >= multiblock.getIgnitionTemperature(this.activeCooled)) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> {
                    if (multiblock.getLastPlasmaTemp() >= multiblock.getMaxPlasmaTemperature(this.activeCooled)) {
                        yield true;
                    }
                    yield false;
                }
                case 3 -> {
                    if (multiblock.fuelTank.isEmpty()) {
                        int injectionPortion = multiblock.getInjectionRate() / 2;
                        if (injectionPortion == 0 || multiblock.naquadahTank.getStored() < (long)injectionPortion || multiblock.uraniumTank.getStored() < (long)injectionPortion) {
                            yield true;
                        }
                        yield false;
                    }
                    yield false;
                }
                case 0 -> false;
            };
        }
        return false;
    }

    public void readSustainedData(HolderLookup.Provider provider, @NotNull CompoundTag nbt) {
        super.readSustainedData(provider, nbt);
        NBTUtils.setEnumIfPresent((CompoundTag)nbt, (String)"logic_type", NaquadahReactorLogic.BY_ID, logicType -> {
            this.logicType = logicType;
        });
        this.activeCooled = nbt.getBoolean("active_cooled");
    }

    public void writeSustainedData(HolderLookup.Provider provider, CompoundTag nbtTags) {
        super.writeSustainedData(provider, nbtTags);
        NBTUtils.writeEnum((CompoundTag)nbtTags, (String)"logic_type", (Enum)this.logicType);
        nbtTags.putBoolean("active_cooled", this.activeCooled);
    }

    protected void collectImplicitComponents(@NotNull DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(GenExtraDataComponents.NAQUADAH_LOGIC_TYPE, (Object)this.logicType);
        builder.set((Supplier)GeneratorsDataComponents.ACTIVE_COOLED, (Object)this.activeCooled);
    }

    protected void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.logicType = (NaquadahReactorLogic)((Object)input.getOrDefault(GenExtraDataComponents.NAQUADAH_LOGIC_TYPE, (Object)this.logicType));
        this.activeCooled = (Boolean)input.getOrDefault((Supplier)GeneratorsDataComponents.ACTIVE_COOLED, (Object)this.activeCooled);
    }

    public void nextMode() {
        this.activeCooled = !this.activeCooled;
        this.markForSave();
    }

    public void previousMode() {
        this.nextMode();
    }

    @ComputerMethod(nameOverride="isActiveCooledLogic")
    public boolean isActiveCooled() {
        return this.activeCooled;
    }

    @ComputerMethod(nameOverride="getLogicMode")
    public NaquadahReactorLogic getMode() {
        return this.logicType;
    }

    public NaquadahReactorLogic[] getModes() {
        return NaquadahReactorLogic.values();
    }

    @ComputerMethod(nameOverride="setLogicMode")
    public void setLogicTypeFromPacket(NaquadahReactorLogic logicType) {
        if (this.logicType != logicType) {
            this.logicType = logicType;
            this.markForSave();
        }
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track((ISyncableData)SyncableEnum.create(NaquadahReactorLogic.BY_ID, (Enum)NaquadahReactorLogic.DISABLED, this::getMode, value -> {
            this.logicType = value;
        }));
        container.track((ISyncableData)SyncableBoolean.create(this::isActiveCooled, value -> {
            this.activeCooled = value;
        }));
        container.track((ISyncableData)SyncableBoolean.create(() -> this.prevOutputting, value -> {
            this.prevOutputting = value;
        }));
    }

    @ComputerMethod
    void setActiveCooledLogic(boolean active) {
        if (this.activeCooled != active) {
            this.nextMode();
        }
    }

    @NothingNullByDefault
    public static enum NaquadahReactorLogic implements IReactorLogicMode<NaquadahReactorLogic>,
    IHasTranslationKey.IHasEnumNameTranslationKey,
    StringRepresentable
    {
        DISABLED((ILangEntry)GeneratorsLang.REACTOR_LOGIC_DISABLED, (ILangEntry)GeneratorsLang.DESCRIPTION_REACTOR_DISABLED, new ItemStack((ItemLike)Items.GUNPOWDER)),
        READY((ILangEntry)GeneratorsLang.REACTOR_LOGIC_READY, (ILangEntry)GeneratorsLang.DESCRIPTION_REACTOR_READY, new ItemStack((ItemLike)Items.REDSTONE)),
        CAPACITY((ILangEntry)GeneratorsLang.REACTOR_LOGIC_CAPACITY, (ILangEntry)GeneratorsLang.DESCRIPTION_REACTOR_CAPACITY, new ItemStack((ItemLike)Items.REDSTONE)),
        DEPLETED((ILangEntry)GeneratorsLang.REACTOR_LOGIC_DEPLETED, (ILangEntry)GeneratorsLang.DESCRIPTION_REACTOR_DEPLETED, new ItemStack((ItemLike)Items.REDSTONE));

        public static final Codec<NaquadahReactorLogic> CODEC;
        public static final IntFunction<NaquadahReactorLogic> BY_ID;
        public static final StreamCodec<ByteBuf, NaquadahReactorLogic> STREAM_CODEC;
        private final ILangEntry name;
        private final ILangEntry description;
        private final ItemStack renderStack;
        private final String serializedName;

        private NaquadahReactorLogic(ILangEntry name, ILangEntry description, ItemStack stack) {
            this.name = name;
            this.description = description;
            this.renderStack = stack;
            this.serializedName = this.name().toLowerCase(Locale.ROOT);
        }

        public ItemStack getRenderStack() {
            return this.renderStack;
        }

        public String getTranslationKey() {
            return this.name.getTranslationKey();
        }

        public Component getDescription() {
            return this.description.translate();
        }

        public EnumColor getColor() {
            return EnumColor.RED;
        }

        public String getSerializedName() {
            return this.serializedName;
        }

        static {
            CODEC = StringRepresentable.fromEnum(NaquadahReactorLogic::values);
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])NaquadahReactorLogic.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

