/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.genextras.common.config;

import com.jerry.genextras.common.config.GenExtraConfigTranslations;
import mekanism.common.config.BaseMekanismConfig;
import mekanism.common.config.IConfigTranslation;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedDoubleValue;
import mekanism.common.config.value.CachedIntValue;
import mekanism.common.config.value.CachedLongValue;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ExtraGeneratorsConfig
extends BaseMekanismConfig {
    private static final String NAQUADAH_CATEGORY = "naquadah_reactor";
    private static final String HOHLRAUM_CATEGORY = "naquadah_hohlraum";
    private final ModConfigSpec configSpec;
    public final CachedLongValue energyPerReactorFuel;
    public final CachedDoubleValue reactorThermocoupleEfficiency;
    public final CachedDoubleValue reactorCasingThermalConductivity;
    public final CachedDoubleValue reactorWaterHeatingRatio;
    public final CachedLongValue reactorFuelCapacity;
    public final CachedLongValue reactorEnergyCapacity;
    public final CachedIntValue reactorWaterPerInjection;
    public final CachedLongValue reactorSteamPerInjection;
    public final CachedLongValue hohlraumMaxGas;
    public final CachedLongValue hohlraumFillRate;

    public ExtraGeneratorsConfig() {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        GenExtraConfigTranslations.SERVER_HOHLRAUM.applyToBuilder(builder).push(HOHLRAUM_CATEGORY);
        this.hohlraumMaxGas = CachedLongValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)GenExtraConfigTranslations.SERVER_HOHLRAUM_CAPACITY.applyToBuilder(builder).defineInRange("maxGas", 100L, 1L, Long.MAX_VALUE));
        this.hohlraumFillRate = CachedLongValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)GenExtraConfigTranslations.SERVER_HOHLRAUM_FILL_RATE.applyToBuilder(builder).defineInRange("fillRate", 1L, 1L, Long.MAX_VALUE));
        builder.pop();
        GenExtraConfigTranslations.SERVER_REACTOR.applyToBuilder(builder).push(NAQUADAH_CATEGORY);
        this.energyPerReactorFuel = CachedLongValue.definePositive((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)GenExtraConfigTranslations.SERVER_REACTOR_FUEL_ENERGY, (String)"energyPerFusionFuel", (long)10000000L);
        this.reactorThermocoupleEfficiency = CachedDoubleValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)GenExtraConfigTranslations.SERVER_REACTOR_THERMOCOUPLE_EFFICIENCY.applyToBuilder(builder).defineInRange("thermocoupleEfficiency", 0.1, 0.0, 1.0));
        this.reactorCasingThermalConductivity = CachedDoubleValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)GenExtraConfigTranslations.SERVER_REACTOR_THERMAL_CONDUCTIVITY.applyToBuilder(builder).defineInRange("casingThermalConductivity", 0.1, 0.001, 1.0));
        this.reactorWaterHeatingRatio = CachedDoubleValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)GenExtraConfigTranslations.SERVER_REACTOR_HEATING_RATE.applyToBuilder(builder).defineInRange("waterHeatingRatio", 0.3, 0.0, 1.0));
        this.reactorFuelCapacity = CachedLongValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)GenExtraConfigTranslations.SERVER_REACTOR_FUEL_CAPACITY.applyToBuilder(builder).defineInRange("fuelCapacity", 1000L, 2L, 1000000L));
        this.reactorEnergyCapacity = CachedLongValue.define((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)GenExtraConfigTranslations.SERVER_REACTOR_ENERGY_CAPACITY, (String)"energyCapacity", (long)10000000000L, (long)1L, (long)Long.MAX_VALUE);
        int baseMaxFissile = 1000000;
        this.reactorWaterPerInjection = CachedIntValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)GenExtraConfigTranslations.SERVER_REACTOR_WATER_INJECTION.applyToBuilder(builder).defineInRange("waterPerInjection", 1000000, 1, 21913098));
        this.reactorSteamPerInjection = CachedLongValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)GenExtraConfigTranslations.SERVER_REACTOR_STEAM_INJECTION.applyToBuilder(builder).defineInRange("poloniumPerInjection", 100L * (long)baseMaxFissile, 1L, 94116041192395671L));
        builder.pop();
        this.configSpec = builder.build();
    }

    public String getFileName() {
        return "generators";
    }

    public String getTranslation() {
        return "General Config";
    }

    public ModConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    public ModConfig.Type getConfigType() {
        return ModConfig.Type.SERVER;
    }
}

