/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.tileentities;

import appeng.api.behaviors.ContainerItemContext;
import appeng.api.behaviors.ContainerItemStrategies;
import appeng.api.behaviors.StackExportStrategy;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnit;
import appeng.api.crafting.IPatternDetails;
import appeng.api.implementations.blockentities.ICraftingMachine;
import appeng.api.implementations.blockentities.PatternContainerGroup;
import appeng.api.inventories.InternalInventory;
import appeng.api.inventories.ItemTransfer;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.orientation.BlockOrientation;
import appeng.api.orientation.RelativeSide;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.blockentity.grid.AENetworkedPoweredBlockEntity;
import appeng.crafting.pattern.AEProcessingPattern;
import appeng.helpers.externalstorage.GenericStackInv;
import appeng.parts.automation.StackWorldBehaviors;
import appeng.util.Platform;
import appeng.util.SettingsFrom;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import com.glodblock.github.extendedae.api.CanerMode;
import com.glodblock.github.extendedae.api.caps.IGenericInvHost;
import com.glodblock.github.extendedae.common.EAESingletons;
import com.glodblock.github.glodium.util.GlodUtil;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class TileCaner
extends AENetworkedPoweredBlockEntity
implements IGridTickable,
ICraftingMachine,
IGenericInvHost {
    public static final int POWER_MAXIMUM_AMOUNT = 3200;
    public static final int POWER_USAGE = 80;
    private final AppEngInternalInventory container = new AppEngInternalInventory((InternalInventoryHost)this, 1, 1);
    private final GenericStackInv stuff = new GenericStackInv(this::wake, 1);
    private ItemStack target = ItemStack.EMPTY;
    private Direction ejectSide = null;
    private CanerMode mode = CanerMode.FILL;
    private AEKey emptyKey = null;

    public TileCaner(BlockPos pos, BlockState blockState) {
        super(GlodUtil.getTileType(TileCaner.class, TileCaner::new, (Block)EAESingletons.CANER), pos, blockState);
        this.stuff.useRegisteredCapacities();
        this.stuff.setCapacity(AEKeyType.items(), 0L);
        this.getMainNode().setFlags(new GridFlags[0]).setIdlePowerUsage(0.0).addService(IGridTickable.class, (IGridNodeService)this);
        this.setInternalMaxPower(3200.0);
        this.setPowerSides(this.getGridConnectableSides(this.getOrientation()));
    }

    public AppEngInternalInventory getContainer() {
        return this.container;
    }

    @Override
    public GenericStackInv getGenericInv() {
        return this.stuff;
    }

    public CanerMode getMode() {
        return this.mode;
    }

    public void setMode(CanerMode mode) {
        this.mode = mode;
    }

    @Nullable
    private ContainerItemContext getStrategy(AEKey type, Player player, ItemStack target) {
        if (ContainerItemStrategies.isKeySupported((AEKey)type)) {
            return ContainerItemStrategies.findOwnedItemContext((AEKeyType)type.getType(), (Player)player, (ItemStack)target);
        }
        return null;
    }

    public boolean isDone() {
        if (!this.target.isEmpty()) {
            return ItemStack.isSameItemSameComponents((ItemStack)this.target, (ItemStack)this.container.getStackInSlot(0));
        }
        return false;
    }

    private void eject() {
        ItemTransfer target;
        if (this.level instanceof ServerLevel && !this.container.getStackInSlot(0).isEmpty() && this.ejectSide != null && (target = InternalInventory.wrapExternal((Level)this.level, (BlockPos)this.getBlockPos().relative(this.ejectSide), (Direction)this.ejectSide.getOpposite())) != null) {
            int startItems = this.container.getStackInSlot(0).getCount();
            this.container.insertItem(0, target.addItems(this.container.extractItem(0, 64, false)), false);
            int endItems = this.container.getStackInSlot(0).getCount();
            long pushed = 0L;
            long origin = 0L;
            GenericStack obj = this.stuff.getStack(0);
            if (obj != null) {
                StackExportStrategy genTarget = StackWorldBehaviors.createExportFacade((ServerLevel)((ServerLevel)this.level), (BlockPos)this.getBlockPos().relative(this.ejectSide), (Direction)this.ejectSide.getOpposite());
                origin = obj.amount();
                pushed = genTarget.push(obj.what(), origin, Actionable.MODULATE);
                this.stuff.extract(0, obj.what(), pushed, Actionable.MODULATE);
            }
            if (startItems != endItems && pushed == origin) {
                this.target = ItemStack.EMPTY;
                this.emptyKey = null;
            }
        }
    }

    public Set<Direction> getGridConnectableSides(BlockOrientation orientation) {
        return EnumSet.of(orientation.getSide(RelativeSide.TOP), orientation.getSide(RelativeSide.BOTTOM));
    }

    protected void onOrientationChanged(BlockOrientation orientation) {
        super.onOrientationChanged(orientation);
        this.setPowerSides(this.getGridConnectableSides(orientation));
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(1, 1, !this.hasJob());
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        this.markForUpdate();
        if (this.getInternalCurrentPower() < 3200.0) {
            this.getMainNode().ifPresent(grid -> {
                double toExtract = Math.min(80.0, this.getInternalMaxPower() - this.getInternalCurrentPower());
                double extracted = grid.getEnergyService().extractAEPower(toExtract, Actionable.MODULATE, PowerMultiplier.ONE);
                this.injectExternalPower(PowerUnit.AE, extracted, Actionable.MODULATE);
            });
        }
        if (this.mode == CanerMode.FILL) {
            this.fill();
        } else if (this.mode == CanerMode.EMPTY) {
            this.empty();
        }
        if (this.isDone()) {
            this.eject();
        }
        return TickRateModulation.FASTER;
    }

    public InternalInventory getInternalInventory() {
        return this.container;
    }

    public void onChangeInventory(AppEngInternalInventory inv, int slot) {
        if (inv == this.container) {
            this.wake();
        }
    }

    private void wake() {
        this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().alertDevice(node));
    }

    public void saveAdditional(CompoundTag data, HolderLookup.Provider registries) {
        super.saveAdditional(data, registries);
        this.stuff.writeToChildTag(data, "stuff", registries);
        data.put("target", this.target.saveOptional(registries));
        if (this.ejectSide != null) {
            data.putString("ejectSide", this.ejectSide.name());
        }
        data.putByte("mode", (byte)this.mode.ordinal());
        if (this.emptyKey != null) {
            data.put("emptyKey", (Tag)this.emptyKey.toTag(registries));
        }
    }

    public void loadTag(CompoundTag data, HolderLookup.Provider registries) {
        super.loadTag(data, registries);
        this.stuff.readFromChildTag(data, "stuff", registries);
        if (data.contains("target")) {
            this.target = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)data.getCompound("target"));
        }
        if (data.contains("ejectSide")) {
            this.ejectSide = Direction.valueOf((String)data.getString("ejectSide"));
        }
        if (data.contains("mode")) {
            this.mode = CanerMode.values()[data.getByte("mode")];
        }
        if (data.contains("emptyKey")) {
            this.emptyKey = AEKey.fromTagGeneric((HolderLookup.Provider)registries, (CompoundTag)data.getCompound("emptyKey"));
        }
    }

    public void importSettings(SettingsFrom mode, DataComponentMap input, @Nullable Player player) {
        super.importSettings(mode, input, player);
        CompoundTag tag = (CompoundTag)input.get(EAESingletons.EXTRA_SETTING);
        if (tag != null && tag.contains("caner_mode")) {
            this.mode = CanerMode.values()[tag.getByte("caner_mode")];
        }
    }

    public void exportSettings(SettingsFrom mode, DataComponentMap.Builder output, @Nullable Player player) {
        super.exportSettings(mode, output, player);
        if (mode == SettingsFrom.MEMORY_CARD) {
            CompoundTag tag = new CompoundTag();
            tag.putByte("caner_mode", (byte)this.mode.ordinal());
            output.set(EAESingletons.EXTRA_SETTING, (Object)tag);
        }
    }

    public void addAdditionalDrops(Level level, BlockPos pos, List<ItemStack> drops) {
        super.addAdditionalDrops(level, pos, drops);
        GenericStack stack = this.stuff.getStack(0);
        if (stack != null) {
            stack.what().addDrops(stack.amount(), drops, level, pos);
        }
    }

    public void clearContent() {
        super.clearContent();
        this.stuff.clear();
    }

    protected boolean readFromStream(RegistryFriendlyByteBuf data) {
        boolean changed = super.readFromStream(data);
        this.container.setItemDirect(0, (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)data));
        return changed;
    }

    protected void writeToStream(RegistryFriendlyByteBuf data) {
        super.writeToStream(data);
        ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)data, (Object)this.container.getStackInSlot(0));
    }

    private void fill() {
        long added;
        ItemStack stack = this.container.getStackInSlot(0);
        GenericStack obj = this.stuff.getStack(0);
        if (stack.isEmpty() || obj == null) {
            return;
        }
        if (!(this.level instanceof ServerLevel)) {
            return;
        }
        Player player = Platform.getFakePlayer((ServerLevel)((ServerLevel)this.level), null);
        player.getInventory().setItem(0, stack);
        player.getInventory().setItem(1, ItemStack.EMPTY);
        ContainerItemContext handler = this.getStrategy(obj.what(), player, stack);
        if (handler == null) {
            return;
        }
        if (this.getInternalCurrentPower() >= 80.0 && (added = handler.insert(obj.what(), obj.amount(), Actionable.SIMULATE)) > 0L) {
            this.stuff.extract(0, obj.what(), added, Actionable.MODULATE);
            handler.insert(obj.what(), added, Actionable.MODULATE);
            if (!player.getInventory().getItem(0).isEmpty()) {
                this.container.setItemDirect(0, player.getInventory().getItem(0).copy());
            } else {
                this.container.setItemDirect(0, player.getInventory().getItem(1).copy());
            }
            this.extractAEPower(80.0, Actionable.MODULATE, PowerMultiplier.CONFIG);
        }
    }

    private void empty() {
        long canAdd;
        long toAdd;
        ItemStack stack = this.container.getStackInSlot(0);
        GenericStack obj = this.stuff.getStack(0);
        if (stack.isEmpty()) {
            return;
        }
        if (!(this.level instanceof ServerLevel)) {
            return;
        }
        GenericStack contents = this.emptyKey != null ? ContainerItemStrategies.getContainedStack((ItemStack)stack, (AEKeyType)this.emptyKey.getType()) : ContainerItemStrategies.getContainedStack((ItemStack)stack);
        if (contents == null) {
            return;
        }
        if (obj != null && !obj.what().equals(contents.what())) {
            return;
        }
        Player player = Platform.getFakePlayer((ServerLevel)((ServerLevel)this.level), null);
        player.getInventory().setItem(0, stack);
        player.getInventory().setItem(1, ItemStack.EMPTY);
        ContainerItemContext handler = this.getStrategy(contents.what(), player, stack);
        if (handler == null) {
            return;
        }
        if (this.getInternalCurrentPower() >= 80.0 && (toAdd = handler.extract(contents.what(), contents.amount(), Actionable.SIMULATE)) > 0L && (canAdd = this.stuff.insert(0, contents.what(), toAdd, Actionable.SIMULATE)) == toAdd) {
            handler.extract(contents.what(), canAdd, Actionable.MODULATE);
            this.stuff.insert(0, contents.what(), canAdd, Actionable.MODULATE);
            if (!player.getInventory().getItem(0).isEmpty()) {
                this.container.setItemDirect(0, player.getInventory().getItem(0).copy());
            } else {
                this.container.setItemDirect(0, player.getInventory().getItem(1).copy());
            }
            this.extractAEPower(80.0, Actionable.MODULATE, PowerMultiplier.CONFIG);
        }
    }

    private boolean hasJob() {
        if (this.mode == CanerMode.FILL) {
            return this.stuff.getStack(0) != null && !this.container.getStackInSlot(0).isEmpty();
        }
        if (this.mode == CanerMode.EMPTY) {
            return !this.container.getStackInSlot(0).isEmpty();
        }
        return false;
    }

    public PatternContainerGroup getCraftingMachineInfo() {
        Component name = this.hasCustomName() ? this.getCustomName() : EAESingletons.CANER.asItem().getDescription();
        return new PatternContainerGroup(AEItemKey.of((ItemLike)EAESingletons.CANER), name, List.of());
    }

    public boolean pushPattern(IPatternDetails patternDetails, KeyCounter[] inputs, Direction ejectionDirection) {
        if (patternDetails instanceof AEProcessingPattern && this.stuff.getStack(0) == null && this.container.getStackInSlot(0).isEmpty()) {
            if (this.mode == CanerMode.FILL) {
                if (inputs.length == 2 && inputs[0].getFirstEntry() != null && inputs[1].getFirstEntry() != null) {
                    boolean fail;
                    Object2LongMap.Entry obj = inputs[0].getFirstEntry();
                    Object2LongMap.Entry cnt = inputs[1].getFirstEntry();
                    GenericStack rst = patternDetails.getPrimaryOutput();
                    if (obj.getKey() instanceof AEItemKey) {
                        obj = inputs[1].getFirstEntry();
                        cnt = inputs[0].getFirstEntry();
                    }
                    if (!(cnt.getKey() instanceof AEItemKey) || cnt.getLongValue() != 1L) {
                        return false;
                    }
                    if (!(rst.what() instanceof AEItemKey) || rst.amount() != 1L) {
                        return false;
                    }
                    this.stuff.setStack(0, new GenericStack((AEKey)obj.getKey(), obj.getLongValue()));
                    this.container.setItemDirect(0, ((AEItemKey)cnt.getKey()).toStack());
                    boolean bl = fail = this.stuff.getStack(0) == null || this.stuff.getStack(0).amount() != obj.getLongValue();
                    if (this.container.getStackInSlot(0).isEmpty()) {
                        fail = true;
                    }
                    if (fail) {
                        this.stuff.setStack(0, null);
                        this.container.setItemDirect(0, ItemStack.EMPTY);
                        return false;
                    }
                    this.target = ((AEItemKey)rst.what()).toStack();
                    this.ejectSide = ejectionDirection;
                    return true;
                }
            } else if (this.mode == CanerMode.EMPTY && inputs.length == 1 && patternDetails.getOutputs().size() == 2 && inputs[0].getFirstEntry() != null) {
                boolean fail;
                Object2LongMap.Entry cnt = inputs[0].getFirstEntry();
                GenericStack obj = (GenericStack)patternDetails.getOutputs().get(0);
                GenericStack rst = (GenericStack)patternDetails.getOutputs().get(1);
                if (obj.what() instanceof AEItemKey) {
                    obj = (GenericStack)patternDetails.getOutputs().get(1);
                    rst = (GenericStack)patternDetails.getOutputs().get(0);
                }
                if (!(cnt.getKey() instanceof AEItemKey) || cnt.getLongValue() != 1L) {
                    return false;
                }
                if (!(rst.what() instanceof AEItemKey) || rst.amount() != 1L) {
                    return false;
                }
                this.container.setItemDirect(0, ((AEItemKey)cnt.getKey()).toStack());
                boolean bl = fail = this.container.getStackInSlot(0).isEmpty() || obj == null;
                if (!fail) {
                    this.target = ((AEItemKey)rst.what()).toStack();
                    this.emptyKey = obj.what();
                    this.ejectSide = ejectionDirection;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean acceptsPlans() {
        return true;
    }
}

