/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.me;

import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.blockentity.AEBaseBlockEntity;
import com.glodblock.github.extendedae.common.me.CraftingThread;
import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class CraftingMatrixThread
extends CraftingThread {
    private static final int COOL_TIME = 100;
    private int blockCoolDown = 0;
    private final Supplier<IActionSource> sourceGetter;

    public CraftingMatrixThread(@NotNull AEBaseBlockEntity host, @NotNull Supplier<IActionSource> sourceGetter) {
        super(host);
        this.sourceGetter = sourceGetter;
    }

    @Override
    public TickRateModulation tick(int cards, int ticksSinceLastCall) {
        if (this.blockCoolDown > 0) {
            this.blockCoolDown -= ticksSinceLastCall;
            return TickRateModulation.SLOWER;
        }
        return super.tick(cards, ticksSinceLastCall);
    }

    @Override
    protected void pushOut(ItemStack output) {
        if (!(output = this.pushTo(output)).isEmpty()) {
            this.blockCoolDown = 100;
        }
        if (output.isEmpty() && this.forcePlan) {
            this.forcePlan = false;
            this.recalculatePlan();
        }
        this.gridInv.setItemDirect(9, output);
    }

    private ItemStack pushTo(ItemStack stack) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        IGrid grid = this.girdHost.getMainNode().getGrid();
        if (grid != null) {
            IStorageService storage = (IStorageService)grid.getService(IStorageService.class);
            long added = storage.getInventory().insert((AEKey)AEItemKey.of((ItemStack)stack), (long)stack.getCount(), Actionable.MODULATE, this.sourceGetter.get());
            if (added == 0L) {
                return stack;
            }
            this.saveChanges();
            if (added != (long)stack.getCount()) {
                return stack.copyWithCount((int)((long)stack.getCount() - added));
            }
            return ItemStack.EMPTY;
        }
        return stack;
    }
}

