/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.energising.recipe;

import com.mojang.serialization.MapCodec;
import com.simibubi.create.compat.jei.category.sequencedAssembly.SequencedAssemblySubCategory;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeParams;
import com.simibubi.create.content.processing.sequenced.IAssemblyRecipe;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;
import org.antarcticgardens.cna.CNABlocks;
import org.antarcticgardens.cna.CNARecipeTypes;
import org.antarcticgardens.cna.CreateNewAge;
import org.antarcticgardens.cna.content.energising.recipe.EnergisingRecipeParams;

public class EnergisingRecipe
extends ProcessingRecipe<RecipeWrapper, EnergisingRecipeParams>
implements IAssemblyRecipe {
    private int energyNeeded;

    public EnergisingRecipe(EnergisingRecipeParams params) {
        super((IRecipeTypeInfo)CNARecipeTypes.ENERGISING, (ProcessingRecipeParams)params);
        this.energyNeeded = params.energyNeeded;
    }

    public EnergisingRecipe(IRecipeTypeInfo typeInfo, EnergisingRecipeParams params) {
        super(typeInfo, (ProcessingRecipeParams)params);
        this.energyNeeded = params.energyNeeded;
    }

    public boolean matches(RecipeWrapper input, Level level) {
        if (input.isEmpty()) {
            return false;
        }
        return ((Ingredient)this.ingredients.get(0)).test(input.getItem(0));
    }

    public int getEnergyNeeded() {
        return this.energyNeeded;
    }

    protected int getMaxInputCount() {
        return 1;
    }

    protected int getMaxOutputCount() {
        return 4;
    }

    public Component getDescriptionForAssembly() {
        return Component.translatable((String)"recipe.assembly.energising");
    }

    public void addRequiredMachines(Set<ItemLike> list) {
        list.add((ItemLike)CNABlocks.BASIC_ENERGISER.get());
    }

    public void addAssemblyIngredients(List<Ingredient> list) {
    }

    public Supplier<Supplier<SequencedAssemblySubCategory>> getJEISubCategory() {
        return (Supplier)CreateNewAge.getInstance().getPlatform().getEnergisingRecipeSubCategory();
    }

    public boolean test(ItemStack stack) {
        return ((Ingredient)this.ingredients.get(0)).test(stack);
    }

    public static void load() {
    }

    public static class Serializer<R extends EnergisingRecipe>
    implements RecipeSerializer<R> {
        private final MapCodec<R> codec;
        private final StreamCodec<RegistryFriendlyByteBuf, R> streamCodec;
        private final ProcessingRecipe.Factory<EnergisingRecipeParams, R> factory;

        public Serializer(ProcessingRecipe.Factory<EnergisingRecipeParams, R> factory) {
            this.codec = ProcessingRecipe.codec(factory, EnergisingRecipeParams.CODEC);
            this.streamCodec = ProcessingRecipe.streamCodec(factory, EnergisingRecipeParams.STREAM_CODEC);
            this.factory = factory;
        }

        public MapCodec<R> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, R> streamCodec() {
            return this.streamCodec;
        }

        public ProcessingRecipe.Factory<EnergisingRecipeParams, R> factory() {
            return this.factory;
        }
    }

    public static class Builder<R extends EnergisingRecipe>
    extends ProcessingRecipeBuilder<EnergisingRecipeParams, R, Builder<R>> {
        public Builder(ProcessingRecipe.Factory<EnergisingRecipeParams, R> factory, ResourceLocation recipeId) {
            super(factory, recipeId);
        }

        protected EnergisingRecipeParams createParams() {
            return new EnergisingRecipeParams();
        }

        public Builder<R> self() {
            return this;
        }

        public Builder<R> energyNeeded(int energyNeeded) {
            ((EnergisingRecipeParams)this.params).energyNeeded = energyNeeded;
            return this;
        }
    }
}

