/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui.lib;

import com.google.common.collect.Lists;
import java.util.List;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;

public interface ElementEvents {
    public List<GuiElement<?>> getChildren();

    default public void mouseMoved(double mouseX, double mouseY) {
        for (GuiElement child : Lists.reverse(this.getChildren())) {
            if (!child.isEnabled()) continue;
            child.mouseMoved(mouseX, mouseY);
        }
    }

    default public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return false;
    }

    default public boolean mouseClicked(double mouseX, double mouseY, int button, boolean consumed) {
        for (GuiElement child : Lists.reverse(this.getChildren())) {
            if (!child.isEnabled()) continue;
            consumed |= child.mouseClicked(mouseX, mouseY, button, consumed);
        }
        return consumed || this.mouseClicked(mouseX, mouseY, button) || this.blockMouseEvents();
    }

    default public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return false;
    }

    default public boolean mouseReleased(double mouseX, double mouseY, int button, boolean consumed) {
        for (GuiElement child : Lists.reverse(this.getChildren())) {
            if (!child.isEnabled()) continue;
            consumed |= child.mouseReleased(mouseX, mouseY, button, consumed);
        }
        return consumed || this.mouseReleased(mouseX, mouseY, button) || this.blockMouseEvents();
    }

    default public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        return false;
    }

    default public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY, boolean consumed) {
        for (GuiElement child : Lists.reverse(this.getChildren())) {
            if (!child.isEnabled()) continue;
            consumed |= child.mouseScrolled(mouseX, mouseY, scrollX, scrollY, consumed);
        }
        return consumed || this.mouseScrolled(mouseX, mouseY, scrollX, scrollY) || this.blockMouseEvents();
    }

    default public boolean blockMouseEvents() {
        return false;
    }

    default public boolean keyPressed(int key, int scancode, int modifiers) {
        return false;
    }

    default public boolean keyPressed(int key, int scancode, int modifiers, boolean consumed) {
        for (GuiElement child : Lists.reverse(this.getChildren())) {
            if (!child.isEnabled()) continue;
            consumed |= child.keyPressed(key, scancode, modifiers, consumed);
        }
        return consumed || this.keyPressed(key, scancode, modifiers);
    }

    default public boolean keyReleased(int key, int scancode, int modifiers) {
        return false;
    }

    default public boolean keyReleased(int key, int scancode, int modifiers, boolean consumed) {
        for (GuiElement child : Lists.reverse(this.getChildren())) {
            if (!child.isEnabled()) continue;
            consumed |= child.keyReleased(key, scancode, modifiers, consumed);
        }
        return consumed || this.keyReleased(key, scancode, modifiers);
    }

    default public boolean charTyped(char character, int modifiers) {
        return false;
    }

    default public boolean charTyped(char character, int modifiers, boolean consumed) {
        for (GuiElement child : Lists.reverse(this.getChildren())) {
            if (!child.isEnabled()) continue;
            consumed |= child.charTyped(character, modifiers, consumed);
        }
        return consumed || this.charTyped(character, modifiers);
    }
}

