/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.server;

import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.plugin.common.tooltip.BranchTooltipNode;
import com.yanny.ali.plugin.common.tooltip.ErrorTooltipNode;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

public class IngredientTooltipUtils {
    @NotNull
    public static ITooltipNode getIngredientTooltip(IServerUtils utils, Ingredient ingredient) {
        BranchTooltipNode.Builder tooltip = BranchTooltipNode.branch();
        for (Ingredient.Value value : ingredient.values) {
            if (value instanceof Ingredient.ItemValue) {
                Ingredient.ItemValue itemValue = (Ingredient.ItemValue)value;
                tooltip.add(utils.getValueTooltip(utils, itemValue.item()).build("ali.property.branch.item"));
                continue;
            }
            if (value instanceof Ingredient.TagValue) {
                Ingredient.TagValue tagValue = (Ingredient.TagValue)value;
                tooltip.add(utils.getValueTooltip(utils, tagValue.tag()).build("ali.property.value.tag"));
                continue;
            }
            tooltip.add(ErrorTooltipNode.error(value.getClass().getSimpleName()).build());
        }
        return tooltip.build("ali.property.branch.items");
    }
}

