/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.server;

import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.plugin.common.tooltip.ArrayTooltipNode;
import com.yanny.ali.plugin.common.tooltip.EmptyTooltipNode;
import com.yanny.ali.plugin.common.tooltip.LiteralTooltipNode;
import com.yanny.ali.plugin.common.tooltip.ValueTooltipNode;
import com.yanny.ali.plugin.server.GenericTooltipUtils;
import com.yanny.ali.plugin.server.TooltipUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.storage.loot.entries.DynamicLoot;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;

public class EntryTooltipUtils {
    @NotNull
    public static ITooltipNode getLootTableTooltip() {
        return LiteralTooltipNode.translatable("ali.enum.group_type.all");
    }

    @NotNull
    public static ITooltipNode getReferenceTooltip(NestedLootTable entry, float chance, int sumWeight) {
        return ArrayTooltipNode.array().add(LiteralTooltipNode.translatable("ali.enum.group_type.all")).add(EntryTooltipUtils.getQualityTooltip(entry.quality)).add(EntryTooltipUtils.getChanceTooltip(EntryTooltipUtils.getBaseMap(chance * (float)entry.weight / (float)sumWeight * 100.0f))).build();
    }

    @NotNull
    public static ITooltipNode getLootPoolTooltip(RangeValue rolls, RangeValue bonusRolls) {
        return ArrayTooltipNode.array().add(LiteralTooltipNode.translatable("ali.enum.group_type.random")).add(EntryTooltipUtils.getRolls(rolls, bonusRolls)).build();
    }

    @NotNull
    public static ITooltipNode getAlternativesTooltip() {
        return LiteralTooltipNode.translatable("ali.enum.group_type.alternatives");
    }

    @NotNull
    public static ITooltipNode getDynamicTooltip(IServerUtils utils, DynamicLoot entry, float chance, int sumWeight, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        return ArrayTooltipNode.array().add(LiteralTooltipNode.translatable("ali.enum.group_type.dynamic")).add(EntryTooltipUtils.getQualityTooltip(entry.quality)).add(EntryTooltipUtils.getChanceTooltip(EntryTooltipUtils.getBaseMap(chance * (float)entry.weight / (float)sumWeight * 100.0f))).add(GenericTooltipUtils.getConditionsTooltip(utils, conditions)).add(GenericTooltipUtils.getFunctionsTooltip(utils, functions)).build();
    }

    @NotNull
    public static ITooltipNode getGroupTooltip() {
        return LiteralTooltipNode.translatable("ali.enum.group_type.all");
    }

    @NotNull
    public static ITooltipNode getSequentialTooltip() {
        return LiteralTooltipNode.translatable("ali.enum.group_type.sequence");
    }

    @NotNull
    public static ITooltipNode getEmptyTooltip(IServerUtils utils, LootPoolSingletonContainer entry, float chance, int sumWeight, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        ArrayList<LootItemFunction> allFunctions = new ArrayList<LootItemFunction>(functions);
        ArrayList<LootItemCondition> allConditions = new ArrayList<LootItemCondition>(conditions);
        allFunctions.addAll(entry.functions);
        allConditions.addAll(entry.conditions);
        float rawChance = chance * (float)entry.weight / (float)sumWeight;
        Map<Holder<Enchantment>, Map<Integer, RangeValue>> chanceMap = TooltipUtils.getChance(utils, allConditions, rawChance);
        return ArrayTooltipNode.array().add(LiteralTooltipNode.translatable("ali.enum.group_type.empty")).add(EntryTooltipUtils.getQualityTooltip(entry.quality)).add(EntryTooltipUtils.getChanceTooltip(chanceMap)).add(GenericTooltipUtils.getConditionsTooltip(utils, allConditions)).add(GenericTooltipUtils.getFunctionsTooltip(utils, allFunctions)).build();
    }

    @NotNull
    public static ITooltipNode getSingletonTooltip(IServerUtils utils, LootPoolSingletonContainer entry, float chance, int sumWeight, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        ArrayList<LootItemFunction> allFunctions = new ArrayList<LootItemFunction>(functions);
        ArrayList<LootItemCondition> allConditions = new ArrayList<LootItemCondition>(conditions);
        allFunctions.addAll(entry.functions);
        allConditions.addAll(entry.conditions);
        float rawChance = chance * (float)entry.weight / (float)sumWeight;
        Map<Holder<Enchantment>, Map<Integer, RangeValue>> chanceMap = TooltipUtils.getChance(utils, allConditions, rawChance);
        Map<Holder<Enchantment>, Map<Integer, RangeValue>> countMap = TooltipUtils.getCount(utils, allFunctions);
        return EntryTooltipUtils.getTooltip(utils, entry.quality, chanceMap, countMap, allFunctions, allConditions);
    }

    @NotNull
    public static ITooltipNode getTooltip(IServerUtils utils, int quality, Map<Holder<Enchantment>, Map<Integer, RangeValue>> chance, Map<Holder<Enchantment>, Map<Integer, RangeValue>> count, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        return ArrayTooltipNode.array().add(EntryTooltipUtils.getQualityTooltip(quality)).add(EntryTooltipUtils.getChanceTooltip(chance)).add(EntryTooltipUtils.getCountTooltip(count)).add(GenericTooltipUtils.getConditionsTooltip(utils, conditions)).add(GenericTooltipUtils.getFunctionsTooltip(utils, functions)).build();
    }

    @NotNull
    public static ITooltipNode getQualityTooltip(int quality) {
        if (quality != 0) {
            return ValueTooltipNode.value(quality).build("ali.description.quality");
        }
        return EmptyTooltipNode.EMPTY;
    }

    @NotNull
    public static ITooltipNode getChanceTooltip(Map<Holder<Enchantment>, Map<Integer, RangeValue>> chance) {
        RangeValue defaultChance = chance.get(null).get(0);
        if (!defaultChance.isRange() && (double)defaultChance.max() > 99.99999) {
            return EmptyTooltipNode.EMPTY;
        }
        ValueTooltipNode.Builder tooltip = ValueTooltipNode.value(chance.get(null).get(0), "%");
        for (Map.Entry<Holder<Enchantment>, Map<Integer, RangeValue>> chanceEntry : chance.entrySet()) {
            Holder<Enchantment> enchantment = chanceEntry.getKey();
            Map<Integer, RangeValue> levelMap = chanceEntry.getValue();
            if (enchantment == null) continue;
            for (Map.Entry<Integer, RangeValue> levelEntry : levelMap.entrySet()) {
                int level = levelEntry.getKey();
                String key = ((TranslatableContents)((Enchantment)enchantment.value()).description().getContents()).getKey();
                RangeValue value = levelEntry.getValue();
                tooltip.add(ValueTooltipNode.value(value.toString() + "%", ValueTooltipNode.translate(key), ValueTooltipNode.translate("enchantment.level." + level)).build("ali.description.chance_bonus"));
            }
        }
        return tooltip.build("ali.description.chance");
    }

    @NotNull
    public static ITooltipNode getCountTooltip(Map<Holder<Enchantment>, Map<Integer, RangeValue>> count) {
        ValueTooltipNode.Builder tooltip = ValueTooltipNode.value(count.get(null).get(0));
        for (Map.Entry<Holder<Enchantment>, Map<Integer, RangeValue>> chanceEntry : count.entrySet()) {
            Holder<Enchantment> enchantment = chanceEntry.getKey();
            Map<Integer, RangeValue> levelMap = chanceEntry.getValue();
            if (enchantment == null) continue;
            for (Map.Entry<Integer, RangeValue> levelEntry : levelMap.entrySet()) {
                int level = levelEntry.getKey();
                String key = ((TranslatableContents)((Enchantment)enchantment.value()).description().getContents()).getKey();
                RangeValue value = levelEntry.getValue();
                tooltip.add(ValueTooltipNode.value(value, ValueTooltipNode.translate(key), ValueTooltipNode.translate("enchantment.level." + level)).build("ali.description.count_bonus"));
            }
        }
        return tooltip.build("ali.description.count");
    }

    @NotNull
    public static Map<Holder<Enchantment>, Map<Integer, RangeValue>> getBaseMap(float value) {
        LinkedHashMap<Holder<Enchantment>, Map<Integer, RangeValue>> map = new LinkedHashMap<Holder<Enchantment>, Map<Integer, RangeValue>>();
        map.put(null, Map.of(0, new RangeValue(value)));
        return map;
    }

    @NotNull
    public static Map<Holder<Enchantment>, Map<Integer, RangeValue>> getBaseMap(float min, float max) {
        LinkedHashMap<Holder<Enchantment>, Map<Integer, RangeValue>> map = new LinkedHashMap<Holder<Enchantment>, Map<Integer, RangeValue>>();
        map.put(null, Map.of(0, new RangeValue(min, max)));
        return map;
    }

    @NotNull
    public static ITooltipNode getRolls(RangeValue rolls, RangeValue bonusRolls) {
        return ValueTooltipNode.value(EntryTooltipUtils.getTotalRolls(rolls, bonusRolls).toIntString(), "x").build("ali.description.rolls");
    }

    private static RangeValue getTotalRolls(RangeValue rolls, RangeValue bonusRolls) {
        if (bonusRolls.min() > 0.0f || bonusRolls.max() > 0.0f) {
            return new RangeValue(bonusRolls).add(rolls);
        }
        return rolls;
    }
}

