/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.common.trades;

import com.mojang.datafixers.util.Either;
import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.ListNode;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.plugin.common.nodes.ItemStackNode;
import com.yanny.ali.plugin.common.nodes.TagNode;
import com.yanny.ali.plugin.common.tooltip.ArrayTooltipNode;
import com.yanny.ali.plugin.common.tooltip.EmptyTooltipNode;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ItemsToItemsNode
extends ListNode {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"ali", (String)"items_to_items");
    private final ITooltipNode tooltip;

    public ItemsToItemsNode(IServerUtils utils, Either<ItemStack, TagKey<? extends ItemLike>> input1, RangeValue input1Count, Either<ItemStack, TagKey<? extends ItemLike>> output, RangeValue outputCount, int maxUses, int xp, float priceMultiplier, ITooltipNode condition) {
        this(utils, input1, input1Count, (Either<ItemStack, TagKey<? extends ItemLike>>)Either.left((Object)ItemStack.EMPTY), new RangeValue(), output, outputCount, maxUses, xp, priceMultiplier, condition);
    }

    public ItemsToItemsNode(IServerUtils utils, Either<ItemStack, TagKey<? extends ItemLike>> input1, RangeValue input1Count, Either<ItemStack, TagKey<? extends ItemLike>> input2, RangeValue input2Count, Either<ItemStack, TagKey<? extends ItemLike>> output, RangeValue outputCount, int maxUses, int xp, float priceMultiplier, ITooltipNode condition) {
        this(utils, input1, input1Count, EmptyTooltipNode.EMPTY, input2, input2Count, EmptyTooltipNode.EMPTY, output, outputCount, EmptyTooltipNode.EMPTY, maxUses, xp, priceMultiplier, condition);
    }

    public ItemsToItemsNode(IServerUtils utils, Either<ItemStack, TagKey<? extends ItemLike>> input1, RangeValue input1Count, ITooltipNode input1Condition, Either<ItemStack, TagKey<? extends ItemLike>> input2, RangeValue input2Count, ITooltipNode input2Condition, Either<ItemStack, TagKey<? extends ItemLike>> output, RangeValue outputCount, ITooltipNode outputCondition, int maxUses, int xp, float priceMultiplier, ITooltipNode condition) {
        this.addChildren(ItemsToItemsNode.getChildren(utils, input1, input1Count, input1Condition));
        this.addChildren(ItemsToItemsNode.getChildren(utils, input2, input2Count, input2Condition));
        this.addChildren(ItemsToItemsNode.getChildren(utils, output, outputCount, outputCondition));
        this.tooltip = ArrayTooltipNode.array().add(condition).add(utils.getValueTooltip(utils, maxUses).build("ali.property.value.uses")).add(utils.getValueTooltip(utils, xp).build("ali.property.value.villager_xp")).add(utils.getValueTooltip(utils, Float.valueOf(priceMultiplier)).build("ali.property.value.price_multiplier")).build();
    }

    public ItemsToItemsNode(IClientUtils utils, RegistryFriendlyByteBuf buf) {
        super(utils, buf);
        this.tooltip = ITooltipNode.decodeNode(utils, buf);
    }

    @Override
    public ITooltipNode getTooltip() {
        return this.tooltip;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public void encodeNode(IServerUtils utils, RegistryFriendlyByteBuf buf) {
        ITooltipNode.encodeNode(utils, this.tooltip, buf);
    }

    private static IDataNode getChildren(IServerUtils utils, Either<ItemStack, TagKey<? extends ItemLike>> item, RangeValue count, ITooltipNode condition) {
        return (IDataNode)item.map(i -> new ItemStackNode(utils, (ItemStack)i, count, condition), t -> new TagNode(utils, (TagKey<? extends ItemLike>)t, count, condition));
    }
}

