/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.base;

import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.visual.AbstractBlockEntityVisual;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public abstract class KineticBlockEntityVisual<T extends KineticBlockEntity>
extends AbstractBlockEntityVisual<T> {
    public KineticBlockEntityVisual(VisualizationContext context, T blockEntity, float partialTick) {
        super(context, blockEntity, partialTick);
    }

    protected Direction.Axis rotationAxis() {
        return KineticBlockEntityVisual.rotationAxis(this.blockState);
    }

    public static float rotationOffset(BlockState state, Direction.Axis axis, Vec3i pos) {
        if (KineticBlockEntityVisual.shouldOffset(axis, pos)) {
            return 22.5f;
        }
        return ICogWheel.isLargeCog(state) ? 11.25f : 0.0f;
    }

    public static boolean shouldOffset(Direction.Axis axis, Vec3i pos) {
        int x = axis == Direction.Axis.X ? 0 : pos.getX();
        int y = axis == Direction.Axis.Y ? 0 : pos.getY();
        int z = axis == Direction.Axis.Z ? 0 : pos.getZ();
        return (x + y + z) % 2 == 0;
    }

    public static Direction.Axis rotationAxis(BlockState blockState) {
        Direction.Axis axis;
        Block block = blockState.getBlock();
        if (block instanceof IRotate) {
            IRotate irotate = (IRotate)block;
            axis = irotate.getRotationAxis(blockState);
        } else {
            axis = Direction.Axis.Y;
        }
        return axis;
    }
}

