/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.filesystem;

import dan200.computercraft.api.filesystem.Mount;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;

public class SubMount
implements Mount {
    private final Mount parent;
    private final String subPath;

    public SubMount(Mount parent, String subPath) {
        this.parent = parent;
        this.subPath = subPath;
    }

    @Override
    public boolean exists(String path) throws IOException {
        return this.parent.exists(this.getFullPath(path));
    }

    @Override
    public boolean isDirectory(String path) throws IOException {
        return this.parent.isDirectory(this.getFullPath(path));
    }

    @Override
    public void list(String path, List<String> contents) throws IOException {
        this.parent.list(this.getFullPath(path), contents);
    }

    @Override
    public long getSize(String path) throws IOException {
        return this.parent.getSize(this.getFullPath(path));
    }

    @Override
    public SeekableByteChannel openForRead(String path) throws IOException {
        return this.parent.openForRead(this.getFullPath(path));
    }

    @Override
    public BasicFileAttributes getAttributes(String path) throws IOException {
        return this.parent.getAttributes(this.getFullPath(path));
    }

    private String getFullPath(String path) {
        return path.isEmpty() ? this.subPath : this.subPath + "/" + path;
    }
}

