/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dan200.computercraft.client.gui.GuiSprites;
import dan200.computercraft.client.pocket.ClientPocketComputers;
import dan200.computercraft.client.pocket.PocketComputerData;
import dan200.computercraft.client.render.ItemMapLikeRenderer;
import dan200.computercraft.client.render.RenderTypes;
import dan200.computercraft.client.render.SpriteRenderer;
import dan200.computercraft.client.render.text.FixedWidthFontRenderer;
import dan200.computercraft.core.util.Colour;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.terminal.NetworkedTerminal;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiSpriteManager;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.gui.GuiSpriteScaling;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import org.joml.Matrix4f;

public final class PocketItemRenderer
extends ItemMapLikeRenderer {
    public static final PocketItemRenderer INSTANCE = new PocketItemRenderer();
    private static final int LIGHT_HEIGHT = 8;
    private static final GuiSpriteScaling.NineSlice DEFAULT_BORDER = new GuiSpriteScaling.NineSlice(36, 36, new GuiSpriteScaling.NineSlice.Border(12, 12, 12, 12));
    private static final GuiSpriteScaling.NineSlice DEFAULT_BOTTOM = new GuiSpriteScaling.NineSlice(36, 20, new GuiSpriteScaling.NineSlice.Border(12, 0, 12, 0));

    private PocketItemRenderer() {
    }

    @Override
    protected void renderItem(PoseStack transform, MultiBufferSource bufferSource, ItemStack stack, int light) {
        int termHeight;
        int termWidth;
        NetworkedTerminal terminal;
        PocketComputerData computer = ClientPocketComputers.get(stack);
        NetworkedTerminal networkedTerminal = terminal = computer == null ? null : computer.getTerminal();
        if (terminal == null) {
            termWidth = 26;
            termHeight = 20;
        } else {
            termWidth = terminal.getWidth();
            termHeight = terminal.getHeight();
        }
        int width = termWidth * 6 + 4;
        int height = termHeight * 9 + 4;
        transform.pushPose();
        transform.mulPose(Axis.YP.rotationDegrees(180.0f));
        transform.mulPose(Axis.ZP.rotationDegrees(180.0f));
        transform.scale(0.5f, 0.5f, 0.5f);
        float scale = 0.75f / (float)Math.max(width + 24, height + 24 + 8);
        transform.scale(scale, scale, -1.0f);
        transform.translate(-0.5 * (double)width, -0.5 * (double)height, 0.0);
        PocketComputerItem item = (PocketComputerItem)stack.getItem();
        ComputerFamily family = item.getFamily();
        int frameColour = DyedItemColor.getOrDefault((ItemStack)stack, (int)-1);
        Matrix4f matrix = transform.last().pose();
        PocketItemRenderer.renderFrame(matrix, bufferSource, family, frameColour, light, width, height);
        int lightColour = computer == null || computer.getLightState() == -1 ? Colour.BLACK.getHex() : computer.getLightState();
        PocketItemRenderer.renderLight(transform, bufferSource, lightColour, width, height);
        FixedWidthFontRenderer.QuadEmitter quadEmitter = FixedWidthFontRenderer.toVertexConsumer(transform, bufferSource.getBuffer(RenderTypes.TERMINAL));
        if (terminal == null) {
            FixedWidthFontRenderer.drawEmptyTerminal(quadEmitter, 0.0f, 0.0f, width, height);
        } else {
            FixedWidthFontRenderer.drawTerminal(quadEmitter, 2.0f, 2.0f, terminal, 2.0f, 2.0f, 2.0f, 2.0f);
        }
        transform.popPose();
    }

    private static void renderFrame(Matrix4f transform, MultiBufferSource render, ComputerFamily family, int colour, int light, int width, int height) {
        GuiSprites.ComputerTextures textures = colour != -1 ? GuiSprites.COMPUTER_COLOUR : GuiSprites.getComputerTextures(family);
        SpriteRenderer spriteRenderer = new SpriteRenderer(transform, render, 0, light, colour);
        PocketItemRenderer.renderBorder(spriteRenderer, textures, width, height);
    }

    private static void renderBorder(SpriteRenderer renderer, GuiSprites.ComputerTextures textures, int width, int height) {
        GuiSpriteManager sprites = Minecraft.getInstance().getGuiSprites();
        TextureAtlasSprite borderSprite = sprites.getSprite(textures.border());
        GuiSpriteScaling.NineSlice borderSlice = PocketItemRenderer.getSlice(sprites.getSpriteScaling(borderSprite), DEFAULT_BORDER);
        GuiSpriteScaling.NineSlice.Border borderBounds = borderSlice.border();
        ResourceLocation bottomTexture = textures.pocketBottom();
        if (bottomTexture == null) {
            throw new NullPointerException(String.valueOf(textures) + " has no pocket texture");
        }
        TextureAtlasSprite bottomSprite = sprites.getSprite(bottomTexture);
        GuiSpriteScaling.NineSlice bottomSlice = PocketItemRenderer.getSlice(sprites.getSpriteScaling(bottomSprite), DEFAULT_BOTTOM);
        GuiSpriteScaling.NineSlice.Border bottomBounds = bottomSlice.border();
        renderer.blit(borderSprite, -borderBounds.left(), -borderBounds.top(), borderBounds.left(), borderBounds.top(), 0, 0, borderSlice.width(), borderSlice.height());
        renderer.blitTiled(borderSprite, 0, -borderBounds.top(), width, borderBounds.top(), borderBounds.left(), 0, borderSlice.width() - borderBounds.left() - borderBounds.right(), borderBounds.top(), borderSlice.width(), borderSlice.height());
        renderer.blit(borderSprite, width, -borderBounds.top(), borderBounds.right(), borderBounds.top(), borderSlice.width() - borderBounds.right(), 0, borderSlice.width(), borderSlice.height());
        renderer.blitTiled(borderSprite, -borderBounds.left(), 0, borderBounds.left(), height, 0, borderBounds.top(), borderBounds.left(), borderSlice.height() - borderBounds.top() - borderBounds.bottom(), borderSlice.width(), borderSlice.height());
        renderer.blitTiled(borderSprite, width, 0, borderBounds.right(), height, borderSlice.width() - borderBounds.right(), borderBounds.top(), borderBounds.right(), borderSlice.height() - borderBounds.top() - borderBounds.bottom(), borderSlice.width(), borderSlice.height());
        renderer.blit(bottomSprite, -bottomBounds.left(), height, bottomBounds.left(), bottomSlice.height(), 0, 0, bottomSlice.width(), bottomSlice.height());
        renderer.blitTiled(bottomSprite, 0, height, width, bottomSlice.height(), bottomBounds.left(), 0, bottomSlice.width() - bottomBounds.left() - bottomBounds.right(), bottomSlice.height(), bottomSlice.width(), bottomSlice.height());
        renderer.blit(bottomSprite, width, height, bottomBounds.right(), bottomSlice.height(), bottomSlice.width() - bottomBounds.right(), 0, bottomSlice.width(), bottomSlice.height());
    }

    private static void renderLight(PoseStack transform, MultiBufferSource render, int colour, int width, int height) {
        VertexConsumer buffer = render.getBuffer(RenderTypes.TERMINAL);
        FixedWidthFontRenderer.drawQuad(FixedWidthFontRenderer.toVertexConsumer(transform, buffer), (float)(width - 16), (float)height + 6.0f, 0.001f, 16.0f, 8.0f, FastColor.ARGB32.opaque((int)colour), 0xF000F0);
    }

    private static GuiSpriteScaling.NineSlice getSlice(GuiSpriteScaling scaling, GuiSpriteScaling.NineSlice fallback) {
        GuiSpriteScaling.NineSlice slice;
        return scaling instanceof GuiSpriteScaling.NineSlice ? (slice = (GuiSpriteScaling.NineSlice)scaling) : fallback;
    }
}

