/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.mob_container;

import com.google.common.base.Preconditions;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.misc.SidedInstance;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.api.ICatchableMob;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.BucketHelper;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.DataDefinedCatchableMob;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSendCapturedMobsPacket;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_4309;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CapturedMobHandler
extends class_4309 {
    private static final SidedInstance<CapturedMobHandler> INSTANCES = SidedInstance.of(CapturedMobHandler::new);
    private final Set<String> commandMobs = new HashSet<String>();
    private final Map<class_1299<?>, DataDefinedCatchableMob> customMobProperties = new IdentityHashMap();
    private final class_7225.class_7874 registryAccess;
    private DataDefinedCatchableMob moddedFishProperty;

    public static CapturedMobHandler getInstance(class_7225.class_7874 ra) {
        return (CapturedMobHandler)((Object)INSTANCES.get(ra));
    }

    public static CapturedMobHandler getInstance(@NotNull class_1937 level) {
        Preconditions.checkNotNull((Object)level);
        return CapturedMobHandler.getInstance((class_7225.class_7874)level.method_30349());
    }

    public CapturedMobHandler(class_7225.class_7874 ra) {
        super(new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create(), "catchable_mobs_properties");
        this.registryAccess = ra;
        INSTANCES.set(ra, (Object)this);
    }

    protected void apply(Map<class_2960, JsonElement> jsons, class_3300 resourceManager, class_3695 profiler) {
        this.customMobProperties.clear();
        class_6903 ops = ForgeHelper.conditionalOps((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)this.registryAccess, (class_4080)this);
        Codec codec = ForgeHelper.conditionalCodec(DataDefinedCatchableMob.CODEC);
        ArrayList list = new ArrayList();
        jsons.forEach((key, json) -> {
            Optional data = (Optional)codec.parse((DynamicOps)ops, json).getOrThrow();
            if (data.isPresent()) {
                if (key.method_12832().equals("generic_fish")) {
                    this.moddedFishProperty = (DataDefinedCatchableMob)data.get();
                } else {
                    list.add((DataDefinedCatchableMob)data.get());
                }
            }
        });
        for (DataDefinedCatchableMob c : list) {
            for (class_2960 o : c.getOwners()) {
                class_7923.field_41177.method_17966(o).ifPresent(e -> this.customMobProperties.put((class_1299<?>)e, c));
            }
        }
        if (this.moddedFishProperty == null) {
            Supplementaries.LOGGER.error("Failed to find json for 'generic_fish'. How? Found jsons were : {}", jsons.keySet());
        }
    }

    public static void sendDataToClient(class_3222 player) {
        CapturedMobHandler serverInstance = CapturedMobHandler.getInstance(player.method_37908());
        HashSet<DataDefinedCatchableMob> set = new HashSet<DataDefinedCatchableMob>(serverInstance.customMobProperties.values());
        NetworkHelper.sendToClientPlayer((class_3222)player, (class_8710)new ClientBoundSendCapturedMobsPacket(set, serverInstance.moddedFishProperty));
    }

    public void acceptData(Set<DataDefinedCatchableMob> list, @Nullable DataDefinedCatchableMob defaultFish) {
        if (defaultFish != null) {
            this.moddedFishProperty = defaultFish;
        }
        this.customMobProperties.clear();
        for (DataDefinedCatchableMob c : list) {
            for (class_2960 o : c.getOwners()) {
                class_7923.field_41177.method_17966(o).ifPresent(e -> this.customMobProperties.put((class_1299<?>)e, c));
            }
        }
    }

    public ICatchableMob getDataCap(class_1299<?> type, boolean isFish) {
        DataDefinedCatchableMob c = this.customMobProperties.get(type);
        if (c == null && isFish) {
            return this.moddedFishProperty;
        }
        return c;
    }

    public ICatchableMob getCatchableMobCapOrDefault(class_1297 entity) {
        if (entity instanceof ICatchableMob) {
            ICatchableMob cap = (ICatchableMob)entity;
            return cap;
        }
        ICatchableMob forgeCap = SuppPlatformStuff.getForgeCap(entity, ICatchableMob.class);
        if (forgeCap != null) {
            return forgeCap;
        }
        ICatchableMob prop = this.getDataCap(entity.method_5864(), BucketHelper.isModdedFish(entity));
        if (prop != null) {
            return prop;
        }
        return ICatchableMob.DEFAULT;
    }

    public boolean isCommandMob(String entity) {
        return this.commandMobs.contains(entity);
    }

    public void addCommandMob(String name) {
        this.commandMobs.add(name);
    }
}

