/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.inventories;

import net.mehvahdjukaar.moonlight.api.misc.IContainerProvider;
import net.mehvahdjukaar.moonlight.api.misc.TileOrEntityTarget;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.supplementaries.common.inventories.DelegatingSlot;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import org.jetbrains.annotations.NotNull;

public class VariableSizeContainerMenu
extends class_1703
implements IContainerProvider {
    public final class_1263 inventory;
    public final int unlockedSlots;
    private static final int[][] TARGET_RATIOS = new int[][]{{1, 1}, {2, 2}, {3, 2}, {3, 3}, {4, 2}, {5, 2}, {6, 2}, {7, 2}, {5, 3}, {8, 2}, {6, 3}, {7, 3}, {8, 3}, {9, 3}};

    public static <C extends class_2586 & class_3908> void openTileMenu(class_3222 player, C tile) {
        TileOrEntityTarget target = TileOrEntityTarget.of(tile);
        PlatHelper.openCustomMenu((class_3222)player, (class_3908)tile, p -> {
            target.write((class_2540)p);
            p.method_53002(((class_1263)tile).method_5439());
        });
    }

    public static <C extends class_1297 & class_3908> void openEntityMenu(class_3222 player, C entity) {
        TileOrEntityTarget target = TileOrEntityTarget.of(entity);
        PlatHelper.openCustomMenu((class_3222)player, (class_3908)entity, p -> {
            target.write((class_2540)p);
            p.method_53002(((class_1263)entity).method_5439());
        });
    }

    public class_1263 getContainer() {
        return this.inventory;
    }

    public VariableSizeContainerMenu(class_3917<?> type, int id, class_1661 playerInventory, class_2540 packetBuffer) {
        this(type, id, playerInventory, VariableSizeContainerMenu.getContainerFromPacket(playerInventory, packetBuffer), packetBuffer.readInt());
    }

    @NotNull
    private static class_1263 getContainerFromPacket(class_1661 playerInventory, class_2540 packetBuffer) {
        class_1937 level;
        TileOrEntityTarget target = TileOrEntityTarget.read((class_2540)packetBuffer);
        Object obj = target.getTarget(level = playerInventory.field_7546.method_37908());
        if (obj instanceof class_1263) {
            class_1263 c = (class_1263)obj;
            return c;
        }
        if (obj instanceof IContainerProvider) {
            IContainerProvider cp = (IContainerProvider)obj;
            return cp.getContainer();
        }
        throw new UnsupportedOperationException("Cannot find container associated with entity ");
    }

    public VariableSizeContainerMenu(class_3917<?> type, int id, class_1661 playerInventory, class_1263 container, int unlockedSlots) {
        super(type, id);
        int si;
        this.inventory = container;
        this.unlockedSlots = unlockedSlots;
        VariableSizeContainerMenu.method_17359((class_1263)container, (int)unlockedSlots);
        container.method_5435(playerInventory.field_7546);
        int[] dims = VariableSizeContainerMenu.getRatio(unlockedSlots);
        if (dims[0] > 9) {
            dims[0] = 9;
            dims[1] = (int)Math.ceil((float)unlockedSlots / 9.0f);
        }
        int yp = 44 - 9 * dims[1];
        int dimx = 0;
        for (int h = 0; h < dims[1]; ++h) {
            int dimXPrev = dimx;
            dimx = Math.min(dims[0], unlockedSlots);
            int xp = 89 - dimx * 18 / 2;
            for (int j = 0; j < dimx; ++j) {
                this.method_7621(new DelegatingSlot(container, j + h * dimXPrev, xp + j * 18, yp + 18 * h, this));
            }
            unlockedSlots -= dims[0];
        }
        for (si = 0; si < 3; ++si) {
            for (int sj = 0; sj < 9; ++sj) {
                this.method_7621(new class_1735((class_1263)playerInventory, sj + (si + 1) * 9, 8 + sj * 18, 84 + si * 18));
            }
        }
        for (si = 0; si < 9; ++si) {
            this.method_7621(new class_1735((class_1263)playerInventory, si, 8 + si * 18, 142));
        }
    }

    public boolean method_7597(class_1657 playerIn) {
        return this.inventory.method_5443(playerIn);
    }

    public class_1799 method_7601(class_1657 playerIn, int index) {
        class_1799 itemstack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot.method_7681()) {
            class_1799 item = slot.method_7677();
            itemstack = item.method_7972();
            int activeSlots = CommonConfigs.Functional.SACK_SLOTS.get();
            if (index < activeSlots ? !this.method_7616(item, activeSlots, this.field_7761.size(), true) : !this.method_7616(item, 0, activeSlots, false)) {
                return class_1799.field_8037;
            }
            if (item.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return itemstack;
    }

    public void method_7595(class_1657 playerIn) {
        super.method_7595(playerIn);
        this.inventory.method_5432(playerIn);
    }

    public static int[] getRatio(int maxSize) {
        int[] dims = new int[]{Math.min(maxSize, 23), Math.max(maxSize / 23, 1)};
        for (int[] testAgainst : TARGET_RATIOS) {
            if (testAgainst[0] * testAgainst[1] != maxSize) continue;
            dims = testAgainst;
            break;
        }
        return dims;
    }
}

