/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.color;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import net.mehvahdjukaar.moonlight.api.util.math.colors.HSLColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.mehvahdjukaar.supplementaries.client.renderers.color.ColorHelper;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BambooSpikesBlockTile;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.QuarkCompat;
import net.minecraft.class_1799;
import net.minecraft.class_1844;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_322;
import net.minecraft.class_326;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class TippedSpikesColor
implements class_322,
class_326 {
    private static final ThreadLocal<Int2IntMap> CACHED_COLORS_0 = ThreadLocal.withInitial(Int2IntOpenHashMap::new);
    private static final ThreadLocal<Int2IntMap> CACHED_COLORS_1 = ThreadLocal.withInitial(Int2IntOpenHashMap::new);

    private static int getCachedColor(int base, int tint) {
        return switch (tint) {
            case 1 -> CACHED_COLORS_0.get().computeIfAbsent(base, b -> TippedSpikesColor.getProcessedColor(base, 0));
            case 2 -> CACHED_COLORS_1.get().computeIfAbsent(base, b -> TippedSpikesColor.getProcessedColor(base, 1));
            default -> -1;
        };
    }

    public int getColor(class_2680 state, @Nullable class_1920 world, @Nullable class_2338 pos, int tint) {
        if (world != null && pos != null) {
            class_1937 level;
            class_2586 class_25862;
            class_2586 class_25863 = world.method_8321(pos);
            if (class_25863 instanceof BambooSpikesBlockTile) {
                BambooSpikesBlockTile tile = (BambooSpikesBlockTile)class_25863;
                int color = tile.getColor();
                return TippedSpikesColor.getCachedColor(color, tint);
            }
            if (CompatHandler.QUARK && world instanceof class_1937 && (class_25862 = QuarkCompat.getMovingBlockEntity(pos, state, level = (class_1937)world)) instanceof BambooSpikesBlockTile) {
                BambooSpikesBlockTile tile = (BambooSpikesBlockTile)class_25862;
                int color = tile.getColor();
                return TippedSpikesColor.getCachedColor(color, tint);
            }
        }
        return 0xFFFFFF;
    }

    public int getColor(class_1799 stack, int tint) {
        if (tint == 0) {
            return 0xFFFFFF;
        }
        return TippedSpikesColor.getCachedColor(((class_1844)stack.method_57825(class_9334.field_49651, (Object)class_1844.field_49274)).method_8064(), tint);
    }

    private static int getProcessedColor(int rgb, int tint) {
        HSLColor hsl = new RGBColor(rgb).asHSL();
        float h = hsl.hue();
        if (tint == 1) {
            boolean b = h > 0.16667f && h < 0.6667f;
            float i = b ? -0.04f : 0.04f;
            h = (h + i) % 1.0f;
        }
        hsl = ColorHelper.prettyfyColor(hsl.withHue(h));
        float s = hsl.saturation();
        s = tint == 0 ? s * 0.81f : s * 0.74f;
        return hsl.withSaturation(s).asRGB().toInt();
    }
}

