/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.block_models;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.mehvahdjukaar.moonlight.api.client.model.BakedQuadBuilder;
import net.mehvahdjukaar.moonlight.api.client.model.CustomBakedModel;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.client.BlackboardTextureManager;
import net.mehvahdjukaar.supplementaries.client.ModMaterials;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BlackboardBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BlackboardBlockTile;
import net.mehvahdjukaar.supplementaries.common.items.components.BlackboardData;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3665;
import net.minecraft.class_4590;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_806;
import net.minecraft.class_809;
import org.joml.Vector3f;

public class BlackboardBakedModel
implements CustomBakedModel {
    private final class_3665 modelTransform;
    private final class_1087 back;

    public BlackboardBakedModel(class_1087 back, class_3665 modelTransform) {
        this.back = back;
        this.modelTransform = modelTransform;
    }

    public boolean method_4708() {
        return true;
    }

    public boolean method_4712() {
        return false;
    }

    public boolean method_24304() {
        return false;
    }

    public boolean method_4713() {
        return false;
    }

    public class_1058 getBlockParticle(ExtraModelData data) {
        return this.back.method_4711();
    }

    public class_806 method_4710() {
        return class_806.field_4292;
    }

    public class_809 method_4709() {
        return class_809.field_4301;
    }

    public List<class_777> getBlockQuads(class_2680 state, class_2350 side, class_5819 rand, class_1921 renderType, ExtraModelData data) {
        ArrayList<class_777> quads = new ArrayList<class_777>(this.back.method_4707(state, side, rand));
        if (data != ExtraModelData.EMPTY && state != null && side == null) {
            class_2350 dir = (class_2350)state.method_11654((class_2769)BlackboardBlock.FACING);
            BlackboardData key = (BlackboardData)data.get(BlackboardBlockTile.BLACKBOARD_KEY);
            if (key != null) {
                BlackboardTextureManager.BlackboardVisuals blackboard = BlackboardTextureManager.getInstance(key);
                quads.addAll(blackboard.getOrCreateModel(dir, this::generateQuads));
            }
        }
        return quads;
    }

    private List<class_777> generateQuads(BlackboardTextureManager.BlackboardVisuals blackboard, class_2350 dir) {
        byte[][] pixels = blackboard.getPixels();
        boolean emissive = blackboard.isGlow();
        class_1058 black = ModMaterials.BLACKBOARD_BLACK.method_24148();
        class_1058 white = ModMaterials.BLACKBOARD_WHITE.method_24148();
        ArrayList<class_777> quads = new ArrayList<class_777>();
        class_4590 rotation = this.modelTransform.method_3509();
        for (int x = 0; x < pixels.length; ++x) {
            int length = 0;
            int startY = 0;
            byte prevColor = pixels[0][x];
            for (int y = 0; y <= pixels[x].length; ++y) {
                Byte current = null;
                if (y < pixels[x].length) {
                    byte b = pixels[x][y];
                    if (prevColor == b) {
                        ++length;
                        continue;
                    }
                    current = b;
                }
                int tint = 0xFF000000 | BlackboardBlock.colorFromByte(prevColor);
                class_1058 sprite = prevColor == 0 ? black : white;
                quads.add(BlackboardBakedModel.createPixelQuad((float)(15 - x) / 16.0f, (float)(16 - length - startY) / 16.0f, 0.0625f, (float)length / 16.0f, sprite, tint, rotation, prevColor != 0 && emissive));
                startY = y;
                if (current != null) {
                    prevColor = current;
                }
                length = 1;
            }
        }
        return quads;
    }

    public static class_777 createPixelQuad(float x, float y, float width, float height, class_1058 sprite, int color, class_4590 transform, boolean emissive) {
        float u0 = 1.0f - x;
        float v0 = 1.0f - y;
        float u1 = 1.0f - (x + width);
        float v1 = 1.0f - (y + height);
        AtomicReference quad = new AtomicReference();
        try (BakedQuadBuilder builder = BakedQuadBuilder.create((class_1058)sprite, (class_4590)transform, quad::set);){
            builder.setAutoDirection();
            BlackboardBakedModel.putVertex(builder, x + width, y + height, u1, v1, color);
            BlackboardBakedModel.putVertex(builder, x + width, y, u1, v0, color);
            BlackboardBakedModel.putVertex(builder, x, y, u0, v0, color);
            BlackboardBakedModel.putVertex(builder, x, y + height, u0, v1, color);
            if (emissive) {
                builder.lightEmission(15);
            }
        }
        catch (Exception e) {
            Supplementaries.error();
        }
        return (class_777)quad.get();
    }

    private static void putVertex(BakedQuadBuilder builder, float x, float y, float u, float v, int color) {
        Vector3f posV = new Vector3f(x, y, 0.6875f);
        posV.set((float)Math.round(posV.x() * 16.0f) / 16.0f, (float)Math.round(posV.y() * 16.0f) / 16.0f, (float)Math.round(posV.z() * 16.0f) / 16.0f);
        builder.method_22912(posV.x, posV.y, posV.z);
        builder.method_39415(color);
        builder.method_22913(u / 16.0f, v / 16.0f);
        builder.method_22914(0.0f, 0.0f, -1.0f);
    }
}

