/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.wiretap.wiretap;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import de.maxhenkel.voicechat.api.VoicechatConnection;
import de.maxhenkel.voicechat.api.events.MicrophonePacketEvent;
import de.maxhenkel.voicechat.api.packets.MicrophonePacket;
import de.maxhenkel.wiretap.Wiretap;
import de.maxhenkel.wiretap.item.SpeakerDevice;
import de.maxhenkel.wiretap.item.WiretapDevice;
import de.maxhenkel.wiretap.wiretap.DeviceType;
import de.maxhenkel.wiretap.wiretap.DimensionLocation;
import de.maxhenkel.wiretap.wiretap.IWiretapDeviceHolder;
import de.maxhenkel.wiretap.wiretap.SpeakerChannel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2631;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class WiretapManager {
    private final Map<UUID, DimensionLocation> microphones = new HashMap<UUID, DimensionLocation>();
    private final Map<UUID, SpeakerChannel> speakers = new HashMap<UUID, SpeakerChannel>();
    private final Cache<UUID, Long> lastCheckCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.SECONDS).build();
    private static WiretapManager instance;

    public void onLoadHead(class_2631 skullBlockEntity) {
        class_1937 class_19372 = skullBlockEntity.method_10997();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        IWiretapDeviceHolder wiretapDevice = (IWiretapDeviceHolder)skullBlockEntity;
        Optional<WiretapDevice> optDeviceData = wiretapDevice.wiretap$getDeviceData();
        if (optDeviceData.isEmpty()) {
            Wiretap.LOGGER.trace("Attempted to load wiretap on non-wiretap skull @ %s".formatted(skullBlockEntity.method_11016()));
            return;
        }
        WiretapDevice deviceData = optDeviceData.get();
        if (deviceData.getDeviceType() == DeviceType.NON_WIRETAP) {
            Wiretap.LOGGER.trace("Attempted to load wiretap on malformed wiretap skull @ %s".formatted(skullBlockEntity.method_11016()));
            return;
        }
        DeviceType deviceType = wiretapDevice.wiretap$getDeviceType();
        UUID pairId = wiretapDevice.wiretap$getPairId();
        switch (deviceType) {
            case MICROPHONE: {
                this.microphones.put(pairId, new DimensionLocation(serverLevel, skullBlockEntity.method_11016()));
                break;
            }
            case SPEAKER: {
                if (!(deviceData instanceof SpeakerDevice)) {
                    throw new IllegalStateException("Device with type DeviceType.SPEAKER is not actually a SpeakerDevice");
                }
                SpeakerDevice speakerDevice = (SpeakerDevice)deviceData;
                float range = speakerDevice.getActiveRange();
                DimensionLocation loc = new DimensionLocation(serverLevel, skullBlockEntity.method_11016());
                SpeakerChannel channel = new SpeakerChannel(this, pairId, loc, range);
                this.speakers.put(pairId, channel);
            }
        }
        Wiretap.LOGGER.trace("Loaded wiretap device (%s#%s) skull @ %s".formatted(new Object[]{deviceType, pairId, skullBlockEntity.method_11016()}));
    }

    public List<UUID> getNearbyMicrophones(class_3218 level, class_243 pos) {
        double range = Wiretap.SERVER_CONFIG.microphonePickupRange.get();
        return this.microphones.entrySet().stream().filter(l -> ((DimensionLocation)l.getValue()).isDimension((class_1937)level)).filter(l -> ((DimensionLocation)l.getValue()).getDistance(pos) <= range).map(Map.Entry::getKey).toList();
    }

    public void onMicPacket(MicrophonePacketEvent event) {
        VoicechatConnection senderConnection = event.getSenderConnection();
        if (senderConnection == null) {
            return;
        }
        class_3222 player = (class_3222)senderConnection.getPlayer().getPlayer();
        class_3218 serverLevel = player.method_51469();
        this.onAudio(serverLevel, player.method_5667(), player.method_19538(), ((MicrophonePacket)event.getPacket()).getOpusEncodedData());
    }

    private void onAudio(class_3218 serverLevel, UUID sender, class_243 senderLocation, byte[] opusEncodedData) {
        List<UUID> nearbyMicrophones = this.getNearbyMicrophones(serverLevel, senderLocation);
        for (UUID id : nearbyMicrophones) {
            SpeakerChannel channel;
            this.verifyChannel(serverLevel, id);
            if (!this.microphones.containsKey(id) || (channel = this.speakers.get(id)) == null) continue;
            channel.addPacket(sender, senderLocation, opusEncodedData);
        }
    }

    private void verifyChannel(class_3218 serverLevel, UUID id) {
        long time = System.currentTimeMillis();
        if (time - this.getLastCheck(id) < 1000L) {
            return;
        }
        this.lastCheckCache.put((Object)id, (Object)time);
        serverLevel.method_8503().execute(() -> {
            SpeakerChannel channel;
            DimensionLocation dimensionLocation = this.microphones.get(id);
            if (dimensionLocation == null) {
                return;
            }
            boolean valid = this.verifyMicrophoneLocation(id, dimensionLocation);
            if (!valid) {
                this.microphones.remove(id);
            }
            if ((channel = this.speakers.get(id)) == null) {
                return;
            }
            valid = this.verifySpeakerLocation(id, channel);
            if (!valid) {
                channel.close();
                this.speakers.remove(id);
            }
        });
    }

    private long getLastCheck(UUID id) {
        try {
            return (Long)this.lastCheckCache.get((Object)id, () -> 0L);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean verifyMicrophoneLocation(UUID microphoneId, @Nullable DimensionLocation location) {
        if (location == null) {
            return false;
        }
        class_3218 level = location.getLevel();
        class_2338 pos = location.getPos();
        if (!location.isLoaded()) {
            return false;
        }
        class_2586 blockEntity = level.method_8321(pos);
        if (!(blockEntity instanceof class_2631)) {
            return false;
        }
        class_2631 skullBlockEntity = (class_2631)blockEntity;
        IWiretapDeviceHolder wiretapDevice = (IWiretapDeviceHolder)skullBlockEntity;
        if (wiretapDevice.wiretap$getDeviceType() != DeviceType.MICROPHONE) {
            return false;
        }
        return wiretapDevice.wiretap$getPairId().equals(microphoneId);
    }

    public boolean verifySpeakerLocation(UUID speakerId, @Nullable SpeakerChannel channel) {
        if (channel == null) {
            return false;
        }
        DimensionLocation dimensionLocation = channel.getDimensionLocation();
        class_3218 level = dimensionLocation.getLevel();
        class_2338 pos = dimensionLocation.getPos();
        if (!dimensionLocation.isLoaded()) {
            return false;
        }
        class_2586 blockEntity = level.method_8321(pos);
        if (!(blockEntity instanceof class_2631)) {
            return false;
        }
        class_2631 skullBlockEntity = (class_2631)blockEntity;
        IWiretapDeviceHolder wiretapDevice = (IWiretapDeviceHolder)skullBlockEntity;
        if (wiretapDevice.wiretap$getDeviceType() != DeviceType.SPEAKER) {
            return false;
        }
        return wiretapDevice.wiretap$getPairId().equals(speakerId);
    }

    public void removeMicrophone(UUID microphone) {
        this.microphones.remove(microphone);
    }

    public void removeSpeaker(UUID speaker) {
        SpeakerChannel speakerChannel = this.speakers.remove(speaker);
        if (speakerChannel != null) {
            speakerChannel.close();
        }
    }

    public void onPlayerDisconnect(class_3222 serverPlayer) {
        this.speakers.values().forEach(speakerChannel -> speakerChannel.onPlayerDisconnect(serverPlayer));
    }

    @Nullable
    public DimensionLocation getMicrophoneLocation(UUID microphone) {
        return this.microphones.get(microphone);
    }

    @Nullable
    public SpeakerChannel getSpeakerChannel(UUID speaker) {
        return this.speakers.get(speaker);
    }

    public void clear() {
        this.speakers.values().forEach(SpeakerChannel::close);
        this.speakers.clear();
        this.microphones.clear();
    }

    public static WiretapManager getInstance() {
        if (instance == null) {
            instance = new WiretapManager();
        }
        return instance;
    }
}

