/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.wiretap.soundeffects;

import de.maxhenkel.wiretap.soundeffects.SoundEffect;

public class OldSpeakerEffect
implements SoundEffect {
    private static final double SAMPLE_RATE = 48000.0;
    private static final double MAX_SHORT = 32767.0;
    private final double normalizedCenterFrequency;
    private final double normalizedBandwidth;
    private double lastInputSample1;
    private double lastInputSample2;
    private double lastOutputSample1;
    private double lastOutputSample2;

    public OldSpeakerEffect(double centerFrequency, double bandwidth) {
        this.normalizedCenterFrequency = 2.0 * centerFrequency / 48000.0;
        this.normalizedBandwidth = 2.0 * bandwidth / 48000.0;
    }

    public OldSpeakerEffect() {
        this(750.0, 2000.0);
    }

    @Override
    public short[] applyEffect(short[] audioData) {
        double[] doubleSamples = new double[audioData.length];
        for (int i = 0; i < audioData.length; ++i) {
            doubleSamples[i] = (double)audioData[i] / 32767.0;
        }
        double maxValue = 32767.0;
        for (int i = 0; i < doubleSamples.length; ++i) {
            doubleSamples[i] = this.bandpassFilter(doubleSamples[i]) * 32767.0;
            if (!(Math.abs(doubleSamples[i]) > maxValue)) continue;
            maxValue = Math.abs(doubleSamples[i]);
        }
        short[] outputData = new short[audioData.length];
        double factor = 32767.0 / maxValue;
        for (int i = 0; i < doubleSamples.length; ++i) {
            outputData[i] = (short)Math.floor(doubleSamples[i] * factor);
        }
        return outputData;
    }

    private double bandpassFilter(double inputSample) {
        double w0 = Math.PI * 2 * this.normalizedCenterFrequency;
        double alpha = Math.sin(w0) * Math.sinh(Math.log(2.0) / 2.0 * this.normalizedBandwidth * w0 / Math.sin(w0));
        double a0 = 1.0 + alpha;
        double b0 = (1.0 - Math.cos(w0)) / 2.0;
        double b1 = 1.0 - Math.cos(w0);
        double b2 = b0;
        double a1 = -2.0 * Math.cos(w0);
        double a2 = 1.0 - alpha;
        double filteredSample = (b0 * inputSample + b1 * this.lastInputSample1 + b2 * this.lastInputSample2 - a1 * this.lastOutputSample1 - a2 * this.lastOutputSample2) / a0;
        this.lastInputSample2 = this.lastInputSample1;
        this.lastInputSample1 = inputSample;
        this.lastOutputSample2 = this.lastOutputSample1;
        this.lastOutputSample1 = filteredSample;
        return filteredSample;
    }
}

