/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.wiretap.mixin;

import com.mojang.serialization.DynamicOps;
import de.maxhenkel.wiretap.Wiretap;
import de.maxhenkel.wiretap.item.WiretapDevice;
import de.maxhenkel.wiretap.wiretap.DeviceType;
import de.maxhenkel.wiretap.wiretap.IWiretapDeviceHolder;
import de.maxhenkel.wiretap.wiretap.WiretapManager;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2631;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import net.minecraft.class_9279;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_2631.class})
public class SkullBlockEntityMixin
extends class_2586
implements IWiretapDeviceHolder {
    @Unique
    private WiretapDevice deviceData = null;

    public SkullBlockEntityMixin(class_2338 blockPos, class_2680 blockState) {
        super(class_2591.field_11913, blockPos, blockState);
    }

    @Inject(method={"loadAdditional"}, at={@At(value="RETURN")})
    public void load(class_2487 compoundTag, class_7225.class_7874 provider, CallbackInfo ci) {
        if (!compoundTag.method_10573("wiretap_data", 10)) {
            this.deviceData = null;
            return;
        }
        class_2487 tag = compoundTag.method_10562("wiretap_data");
        this.deviceData = WiretapDevice.CODEC.parse((DynamicOps)class_2509.field_11560, (Object)tag).resultOrPartial(err -> Wiretap.LOGGER.error("Failed to read wiretap device ({}): {}", (Object)tag, err)).orElse(null);
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            WiretapManager.getInstance().onLoadHead((class_2631)this);
        }
    }

    @Inject(method={"saveAdditional"}, at={@At(value="RETURN")})
    public void save(class_2487 compoundTag, class_7225.class_7874 provider, CallbackInfo ci) {
        if (this.deviceData != null) {
            compoundTag.method_10566("wiretap_data", (class_2520)this.deviceData.getSerialisationCodec().encodeStart((DynamicOps)class_2509.field_11560, (Object)this.deviceData).getOrThrow());
        }
    }

    @Inject(method={"applyImplicitComponents"}, at={@At(value="RETURN")})
    protected void applyExtraComponents(class_2586.class_9473 dataComponentInput, CallbackInfo ci) {
        class_9279 data = (class_9279)dataComponentInput.method_58694(class_9334.field_49628);
        if (data == null) {
            return;
        }
        class_2487 dataCompound = data.method_57461();
        if (!dataCompound.method_10573("wiretap_data", 10)) {
            this.deviceData = null;
            return;
        }
        class_2487 tag = dataCompound.method_10562("wiretap_data");
        Optional wiretapDevice = WiretapDevice.CODEC.parse((DynamicOps)class_2509.field_11560, (Object)tag).resultOrPartial(err -> Wiretap.LOGGER.error("Failed to read wiretap device ({}): {}", (Object)tag, err));
        if (wiretapDevice.isEmpty()) {
            return;
        }
        this.deviceData = (WiretapDevice)wiretapDevice.get();
        if (this.wiretap$getDeviceType() != DeviceType.NON_WIRETAP && this.field_11863 != null && !this.field_11863.field_9236) {
            WiretapManager.getInstance().onLoadHead((class_2631)this);
        }
    }

    @Inject(method={"collectImplicitComponents(Lnet/minecraft/core/component/DataComponentMap$Builder;)V"}, at={@At(value="RETURN")})
    protected void collectExtraComponents(class_9323.class_9324 builder, CallbackInfo ci) {
        if (this.deviceData == null) {
            return;
        }
        class_9279 data = this.deviceData.saveToNewCustomData();
        builder.method_57840(class_9334.field_49628, (Object)data);
    }

    public void method_31662(class_1937 newLevel) {
        class_1937 oldLevel = this.field_11863;
        super.method_31662(newLevel);
        if (oldLevel == null && newLevel != null && !newLevel.field_9236) {
            WiretapManager.getInstance().onLoadHead((class_2631)this);
        }
    }

    @Override
    @Nonnull
    public DeviceType wiretap$getDeviceType() {
        return this.deviceData == null ? DeviceType.NON_WIRETAP : this.deviceData.getDeviceType();
    }

    @Override
    public UUID wiretap$getPairId() {
        if (this.deviceData == null) {
            throw new IllegalStateException("Failed to check device type before getting pair id");
        }
        return this.deviceData.getPairUUID();
    }

    @Override
    public Optional<WiretapDevice> wiretap$getDeviceData() {
        return Optional.ofNullable(this.deviceData);
    }
}

