/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.shape.v1;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.class_2350;
import net.minecraft.class_259;
import net.minecraft.class_265;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public final class ShapesHelper {
    private ShapesHelper() {
    }

    public static Map<class_2350, class_265> rotate(class_265 voxelShape) {
        EnumMap shapes = Maps.newEnumMap(class_2350.class);
        for (class_2350 direction : class_2350.values()) {
            shapes.put(direction, ShapesHelper.rotate(direction.method_23224(), voxelShape));
        }
        return Maps.immutableEnumMap((Map)shapes);
    }

    public static Map<class_2350, class_265> rotateHorizontally(class_265 voxelShape) {
        EnumMap shapes = Maps.newEnumMap(class_2350.class);
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            Quaternionf rotation = ShapesHelper.getHorizontalRotation(direction);
            shapes.put(direction, ShapesHelper.rotate(rotation, voxelShape));
        }
        return Maps.immutableEnumMap((Map)shapes);
    }

    public static Quaternionf getHorizontalRotation(class_2350 direction) {
        return new Quaternionf().rotationY((float)Math.atan2(direction.method_10148(), direction.method_10165()));
    }

    @Deprecated(forRemoval=true)
    public static class_265 rotate(class_2350 direction, class_265 voxelShape) {
        return ShapesHelper.rotate(direction.method_23224(), voxelShape);
    }

    @Deprecated(forRemoval=true)
    public static class_265 rotate(class_2350 direction, class_265 voxelShape, Vector3d originOffset) {
        return ShapesHelper.rotate(direction.method_23224(), voxelShape, originOffset);
    }

    public static class_265 rotate(Quaternionf rotation, class_265 voxelShape) {
        return ShapesHelper.rotate(rotation, voxelShape, new Vector3d(0.5, 0.5, 0.5));
    }

    public static class_265 rotate(Quaternionf rotation, class_265 voxelShape, Vector3d originOffset) {
        class_265[] joinedVoxelShape = new class_265[]{class_259.method_1073()};
        voxelShape.method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> {
            Vector3d start = rotation.transform(new Vector3d(minX, minY, minZ).sub((Vector3dc)originOffset)).add((Vector3dc)originOffset);
            Vector3d end = rotation.transform(new Vector3d(maxX, maxY, maxZ).sub((Vector3dc)originOffset)).add((Vector3dc)originOffset);
            joinedVoxelShape[0] = class_259.method_1084((class_265)joinedVoxelShape[0], (class_265)ShapesHelper.box(start.x, start.y, start.z, end.x, end.y, end.z));
        });
        return joinedVoxelShape[0];
    }

    public static class_265 box(double startX, double startY, double startZ, double endX, double endY, double endZ) {
        return class_259.method_1081((double)Math.min(startX, endX), (double)Math.min(startY, endY), (double)Math.min(startZ, endZ), (double)Math.max(startX, endX), (double)Math.max(startY, endY), (double)Math.max(startZ, endZ));
    }
}

