/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.network;

import com.teamresourceful.resourcefullib.common.network.Packet;
import com.teamresourceful.resourcefullib.common.network.base.ClientboundPacketType;
import com.teamresourceful.resourcefullib.common.network.base.Networking;
import com.teamresourceful.resourcefullib.common.network.base.PacketType;
import com.teamresourceful.resourcefullib.common.network.base.ServerboundPacketType;
import com.teamresourceful.resourcefullib.common.network.fabric.NetworkImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Collection;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2802;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3215;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;

public class Network
implements Networking {
    private final Networking networking;
    private final boolean optional;

    public Network(class_2960 channel, int protocolVersion) {
        this(channel, protocolVersion, false);
    }

    public Network(class_2960 channel, int protocolVersion, boolean optional) {
        this.networking = Network.getNetwork(channel, protocolVersion, optional);
        this.optional = optional;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="22.0")
    public Network(String modid, int protocolVersion, String channel) {
        this(modid, protocolVersion, channel, false);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="22.0")
    public Network(String modid, int protocolVersion, String channel, boolean optional) {
        this.networking = Network.getNetwork(class_2960.method_60655((String)modid, (String)channel), protocolVersion, optional);
        this.optional = optional;
    }

    @Override
    public final <T extends Packet<T>> void register(ClientboundPacketType<T> type) {
        this.networking.register(type);
    }

    @Override
    public final <T extends Packet<T>> void register(ServerboundPacketType<T> type) {
        this.networking.register(type);
    }

    @Override
    public final <T extends Packet<T>> void sendToServer(T message) {
        this.networking.sendToServer(message);
    }

    @Override
    public final <T extends Packet<T>> void sendToPlayer(T message, class_3222 player) {
        if (this.optional && !this.canSendToPlayer(player, message.type())) {
            return;
        }
        this.networking.sendToPlayer(message, player);
    }

    public final <T extends Packet<T>> void sendToPlayer(T message, class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            this.sendToPlayer(message, serverPlayer);
        }
    }

    public final <T extends Packet<T>> void sendToPlayers(T message, Collection<? extends class_1657> players) {
        players.forEach(player -> this.sendToPlayer(message, (class_1657)player));
    }

    public final <T extends Packet<T>> void sendToAllPlayers(T message, MinecraftServer server) {
        this.sendToPlayers(message, server.method_3760().method_14571());
    }

    public final <T extends Packet<T>> void sendToPlayersInLevel(T message, class_1937 level) {
        this.sendToPlayers(message, level.method_18456());
    }

    public final <T extends Packet<T>> void sendToAllLoaded(T message, class_1937 level, class_2338 pos) {
        class_2802 class_28022;
        class_2818 chunk = level.method_8500(pos);
        if (chunk != null && (class_28022 = level.method_8398()) instanceof class_3215) {
            class_3215 serverCache = (class_3215)class_28022;
            serverCache.field_17254.method_17210(chunk.method_12004(), false).forEach(player -> this.sendToPlayer(message, (class_3222)player));
        }
    }

    public final <T extends Packet<T>> void sendToPlayersInRange(T message, class_1937 level, class_2338 pos, double range) {
        for (class_1657 player : level.method_18456()) {
            if (!(player.method_24515().method_10262((class_2382)pos) <= range)) continue;
            this.sendToPlayer(message, player);
        }
    }

    @Override
    public final boolean canSendToPlayer(class_3222 player, PacketType<?> type) {
        return this.networking.canSendToPlayer(player, type);
    }

    public final boolean canSendToPlayer(class_1657 player, PacketType<?> type) {
        class_3222 serverPlayer;
        return player instanceof class_3222 && this.canSendToPlayer(serverPlayer = (class_3222)player, type);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ApiStatus.Internal
    @Contract(pure=true)
    @ExpectPlatform.Transformed
    public static Networking getNetwork(class_2960 channel, int protocolVersion, boolean optional) {
        void var2_2;
        void var1_1;
        return NetworkImpl.getNetwork(channel, (int)var1_1, (boolean)var2_2);
    }
}

