/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.utils;

import com.moulberry.axiom.VersionUtilsNbt;
import com.moulberry.axiom.packets.AxiomServerboundManipulateEntity;
import com.moulberry.axiom.packets.AxiomServerboundSpawnEntity;
import com.moulberry.axiom.utils.IntMatrix;
import com.moulberry.axiom.utils.NbtHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;

public class EntityDataUtils {
    public static class_2487 saveWithoutId(class_1297 entity) {
        return entity.method_5647(new class_2487());
    }

    @Nullable
    public static class_2487 saveRoot(class_1297 entity) {
        class_2487 tag = new class_2487();
        return entity.method_5662(tag) ? tag : null;
    }

    @Nullable
    public static class_2487 saveAsPassenger(class_1297 entity) {
        class_2487 tag = new class_2487();
        return entity.method_5786(tag) ? tag : null;
    }

    public static void load(class_1297 entity, class_2487 compoundTag) {
        entity.method_5651(compoundTag);
    }

    @Nullable
    public static class_243 getEntityPosition(class_2487 entity) {
        class_2499 listTag;
        if (entity.method_10545("TileX") && entity.method_10545("TileY") && entity.method_10545("TileZ")) {
            int tileX = VersionUtilsNbt.helperCompoundTagGetIntOr(entity, "TileX", 0);
            int tileY = VersionUtilsNbt.helperCompoundTagGetIntOr(entity, "TileY", 0);
            int tileZ = VersionUtilsNbt.helperCompoundTagGetIntOr(entity, "TileZ", 0);
            return new class_243((double)tileX + 0.5, (double)tileY + 0.5, (double)tileZ + 0.5);
        }
        if (entity.method_10545("Pos") && (listTag = NbtHelper.getList(entity, "Pos", 6)).size() == 3) {
            return new class_243(VersionUtilsNbt.helperListTagGetDoubleOr(listTag, 0, 0.0), VersionUtilsNbt.helperListTagGetDoubleOr(listTag, 1, 0.0), VersionUtilsNbt.helperListTagGetDoubleOr(listTag, 2, 0.0));
        }
        return null;
    }

    public static void setEntityPosition(class_2487 entity, class_243 vec3) {
        if (entity.method_10545("TileX") && entity.method_10545("TileY") && entity.method_10545("TileZ")) {
            entity.method_10569("TileX", (int)Math.floor(vec3.field_1352));
            entity.method_10569("TileY", (int)Math.floor(vec3.field_1351));
            entity.method_10569("TileZ", (int)Math.floor(vec3.field_1350));
            return;
        }
        class_2499 position = new class_2499();
        position.add((Object)class_2489.method_23241((double)vec3.field_1352));
        position.add((Object)class_2489.method_23241((double)vec3.field_1351));
        position.add((Object)class_2489.method_23241((double)vec3.field_1350));
        entity.method_10566("Pos", (class_2520)position);
    }

    public static boolean cloneEntity(UUID newUuid, class_2487 entity, class_243 translation, IntMatrix rotationMatrix, List<AxiomServerboundSpawnEntity.SpawnEntry> spawnEntries, List<AxiomServerboundManipulateEntity.ManipulateEntry> manipulateEntries, List<UUID> allUuids) {
        float pitch;
        class_243 position = EntityDataUtils.getEntityPosition(entity);
        if (position == null) {
            return false;
        }
        double x = position.field_1352 - 0.5;
        double y = position.field_1351 - 0.5;
        double z = position.field_1350 - 0.5;
        Vector2f rotation = EntityDataUtils.getEntityRotation(entity);
        float yaw = rotation == null ? 0.0f : rotation.x;
        float f = pitch = rotation == null ? 0.0f : rotation.y;
        if (rotationMatrix == null || rotationMatrix.isIdentity()) {
            position = new class_243(x + translation.field_1352 + 0.5, y + translation.field_1351 + 0.5, z + translation.field_1350 + 0.5);
        } else {
            double nx = rotationMatrix.transformDoubleX(x, y, z);
            double ny = rotationMatrix.transformDoubleY(x, y, z);
            double nz = rotationMatrix.transformDoubleZ(x, y, z);
            position = new class_243(nx + translation.field_1352 + 0.5, ny + translation.field_1351 + 0.5, nz + translation.field_1350 + 0.5);
            double pitchRadians = Math.toRadians(pitch);
            double yawRadians = Math.toRadians(-yaw);
            double cosYaw = Math.cos(yawRadians);
            double sinYaw = Math.sin(yawRadians);
            double cosPitch = Math.cos(pitchRadians);
            double sinPitch = Math.sin(pitchRadians);
            class_243 viewVector = new class_243(sinYaw * cosPitch, -sinPitch, cosYaw * cosPitch);
            double viewX = rotationMatrix.transformDoubleX(viewVector.field_1352, viewVector.field_1351, viewVector.field_1350);
            double viewY = rotationMatrix.transformDoubleY(viewVector.field_1352, viewVector.field_1351, viewVector.field_1350);
            double viewZ = rotationMatrix.transformDoubleZ(viewVector.field_1352, viewVector.field_1351, viewVector.field_1350);
            double viewXZ = Math.sqrt(viewX * viewX + viewZ * viewZ);
            pitch = class_3532.method_15393((float)((float)(-(class_3532.method_15349((double)viewY, (double)viewXZ) * 57.2957763671875))));
            yaw = class_3532.method_15393((float)((float)(class_3532.method_15349((double)viewZ, (double)viewX) * 57.2957763671875) - 90.0f));
            pitch = (float)Math.round(pitch * 256.0f) / 256.0f;
            yaw = (float)Math.round(yaw * 256.0f) / 256.0f;
        }
        ArrayList<UUID> childrenUuids = new ArrayList<UUID>();
        for (class_2487 child : EntityDataUtils.splitChildren(entity)) {
            UUID childUuid = UUID.randomUUID();
            if (!EntityDataUtils.cloneEntity(childUuid, child, translation, rotationMatrix, spawnEntries, manipulateEntries, allUuids)) continue;
            childrenUuids.add(childUuid);
        }
        spawnEntries.add(new AxiomServerboundSpawnEntity.SpawnEntry(newUuid, position, yaw, pitch, null, entity));
        if (!childrenUuids.isEmpty()) {
            manipulateEntries.add(new AxiomServerboundManipulateEntity.ManipulateEntry(newUuid, AxiomServerboundManipulateEntity.PassengerManipulation.ADD_LIST, childrenUuids));
        }
        allUuids.add(newUuid);
        return true;
    }

    public static void applyMatrixToEntity(class_2487 entity, IntMatrix matrix) {
        if (matrix == null || matrix.isIdentity()) {
            return;
        }
        class_243 position = EntityDataUtils.getEntityPosition(entity);
        if (position == null) {
            return;
        }
        double x = position.field_1352 - 0.5;
        double y = position.field_1351 - 0.5;
        double z = position.field_1350 - 0.5;
        Vector2f rotation = EntityDataUtils.getEntityRotation(entity);
        float yaw = rotation == null ? 0.0f : rotation.x;
        float pitch = rotation == null ? 0.0f : rotation.y;
        double nx = matrix.transformDoubleX(x, y, z);
        double ny = matrix.transformDoubleY(x, y, z);
        double nz = matrix.transformDoubleZ(x, y, z);
        position = new class_243(nx + 0.5, ny + 0.5, nz + 0.5);
        double pitchRadians = Math.toRadians(pitch);
        double yawRadians = Math.toRadians(-yaw);
        double cosYaw = Math.cos(yawRadians);
        double sinYaw = Math.sin(yawRadians);
        double cosPitch = Math.cos(pitchRadians);
        double sinPitch = Math.sin(pitchRadians);
        class_243 viewVector = new class_243(sinYaw * cosPitch, -sinPitch, cosYaw * cosPitch);
        double viewX = matrix.transformDoubleX(viewVector.field_1352, viewVector.field_1351, viewVector.field_1350);
        double viewY = matrix.transformDoubleY(viewVector.field_1352, viewVector.field_1351, viewVector.field_1350);
        double viewZ = matrix.transformDoubleZ(viewVector.field_1352, viewVector.field_1351, viewVector.field_1350);
        double viewXZ = Math.sqrt(viewX * viewX + viewZ * viewZ);
        pitch = class_3532.method_15393((float)((float)(-(class_3532.method_15349((double)viewY, (double)viewXZ) * 57.2957763671875))));
        yaw = class_3532.method_15393((float)((float)(class_3532.method_15349((double)viewZ, (double)viewX) * 57.2957763671875) - 90.0f));
        pitch = (float)Math.round(pitch * 256.0f) / 256.0f;
        yaw = (float)Math.round(yaw * 256.0f) / 256.0f;
        EntityDataUtils.setEntityPosition(entity, position);
        EntityDataUtils.setEntityRotation(entity, new Vector2f(yaw, pitch));
        for (class_2487 child : EntityDataUtils.getChildren(entity)) {
            EntityDataUtils.applyMatrixToEntity(child, matrix);
        }
    }

    public static List<class_2487> splitChildren(class_2487 entity) {
        class_2499 listTag;
        if (entity.method_10545("Passengers") && !(listTag = NbtHelper.getList(entity, "Passengers", 10)).isEmpty()) {
            ArrayList<class_2487> children = new ArrayList<class_2487>();
            for (class_2520 tag : listTag) {
                children.add((class_2487)tag);
            }
            entity.method_10551("Passengers");
            return children;
        }
        return List.of();
    }

    public static List<class_2487> getChildren(class_2487 entity) {
        class_2499 listTag;
        if (entity.method_10545("Passengers") && !(listTag = NbtHelper.getList(entity, "Passengers", 10)).isEmpty()) {
            ArrayList<class_2487> children = new ArrayList<class_2487>();
            for (class_2520 tag : listTag) {
                children.add((class_2487)tag);
            }
            return children;
        }
        return List.of();
    }

    @Nullable
    public static Vector2f getEntityRotation(class_2487 entity) {
        class_2499 listTag;
        if (entity.method_10545("Rotation") && (listTag = NbtHelper.getList(entity, "Rotation", 5)).size() == 2) {
            return new Vector2f(VersionUtilsNbt.helperListTagGetFloatOr(listTag, 0, 0.0f), VersionUtilsNbt.helperListTagGetFloatOr(listTag, 1, 0.0f));
        }
        return null;
    }

    public static void setEntityRotation(class_2487 entity, Vector2f vector2f) {
        class_2499 rotation = new class_2499();
        rotation.add((Object)class_2494.method_23244((float)vector2f.x));
        rotation.add((Object)class_2494.method_23244((float)vector2f.y));
        entity.method_10566("Rotation", (class_2520)rotation);
    }

    public static void offsetEntityRecursive(class_2487 entity, class_243 offset) {
        class_2499 listTag;
        if (entity.method_10545("Pos") && (listTag = NbtHelper.getList(entity, "Pos", 6)).size() == 3) {
            listTag.method_10535(0, (class_2520)class_2489.method_23241((double)(VersionUtilsNbt.helperListTagGetDoubleOr(listTag, 0, 0.0) + offset.field_1352)));
            listTag.method_10535(1, (class_2520)class_2489.method_23241((double)(VersionUtilsNbt.helperListTagGetDoubleOr(listTag, 1, 0.0) + offset.field_1351)));
            listTag.method_10535(2, (class_2520)class_2489.method_23241((double)(VersionUtilsNbt.helperListTagGetDoubleOr(listTag, 2, 0.0) + offset.field_1350)));
        }
        if (entity.method_10545("TileX")) {
            entity.method_10569("TileX", VersionUtilsNbt.helperCompoundTagGetIntOr(entity, "TileX", 0) + (int)Math.round(offset.field_1352));
        }
        if (entity.method_10545("TileY")) {
            entity.method_10569("TileY", VersionUtilsNbt.helperCompoundTagGetIntOr(entity, "TileY", 0) + (int)Math.round(offset.field_1351));
        }
        if (entity.method_10545("TileZ")) {
            entity.method_10569("TileZ", VersionUtilsNbt.helperCompoundTagGetIntOr(entity, "TileZ", 0) + (int)Math.round(offset.field_1350));
        }
        if (entity.method_10545("Passengers")) {
            listTag = NbtHelper.getList(entity, "Passengers", 10);
            for (class_2520 tag : listTag) {
                EntityDataUtils.offsetEntityRecursive((class_2487)tag, offset);
            }
        }
    }
}

