/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.stamp;

import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.tools.stamp.TransformedBlockRegions;
import com.moulberry.axiom.world_modification.CompressedBlockEntity;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;

public record StampPlacement(ChunkedBlockRegion blockRegion, Long2ObjectMap<CompressedBlockEntity> blockEntities, TransformedBlockRegions originalSet, int originalRotations, boolean originalFlipX, boolean originalFlipZ, int x, int y, int z, int baseX, int baseY, int baseZ) {
    public StampPlacement withBasePosition(int baseX, int baseY, int baseZ) {
        int relX = this.x - this.baseX;
        int relY = this.y - this.baseY;
        int relZ = this.z - this.baseZ;
        return new StampPlacement(this.blockRegion, this.blockEntities, this.originalSet, this.originalRotations, this.originalFlipX, this.originalFlipZ, baseX + relX, baseY + relY, baseZ + relZ, baseX, baseY, baseZ);
    }

    public StampPlacement rotate(int rotations) {
        int newRotations = (this.originalRotations + rotations) % 4;
        return new StampPlacement(this.originalSet.getBlocks(newRotations, this.originalFlipX, this.originalFlipZ), this.originalSet.getBlockEntities(newRotations, this.originalFlipX, this.originalFlipZ), this.originalSet, newRotations, this.originalFlipX, this.originalFlipZ, this.x, this.y, this.z, this.baseX, this.baseY, this.baseZ);
    }

    public void pasteInto(ChunkedBlockRegion into, Long2ObjectMap<CompressedBlockEntity> blockEntities) {
        int minX = this.blockRegion.min().method_10263();
        int minY = this.blockRegion.min().method_10264();
        int minZ = this.blockRegion.min().method_10260();
        int maxX = this.blockRegion.max().method_10263();
        int maxY = this.blockRegion.max().method_10264();
        int maxZ = this.blockRegion.max().method_10260();
        int xo = this.x - (maxX + minX) / 2;
        int yo = this.y - (maxY + minY) / 2;
        int zo = this.z - (maxZ + minZ) / 2;
        this.blockRegion.forEachEntry((x, y, z, state) -> into.addBlock(x + xo, y + yo, z + zo, (class_2680)state));
        for (Long2ObjectMap.Entry entry : this.blockEntities.long2ObjectEntrySet()) {
            blockEntities.put(class_2338.method_10096((long)entry.getLongKey(), (int)xo, (int)yo, (int)zo), (Object)((CompressedBlockEntity)entry.getValue()));
        }
    }

    public void pasteIntoExtendToGround(ChunkedBlockRegion into, Long2ObjectMap<CompressedBlockEntity> blockEntities, class_1937 level) {
        int minX = this.blockRegion.min().method_10263();
        int minY = this.blockRegion.min().method_10264();
        int minZ = this.blockRegion.min().method_10260();
        int maxX = this.blockRegion.max().method_10263();
        int maxY = this.blockRegion.max().method_10264();
        int maxZ = this.blockRegion.max().method_10260();
        int xo = this.x - (maxX + minX) / 2;
        int yo = this.y - (maxY + minY) / 2;
        int zo = this.z - (maxZ + minZ) / 2;
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        this.blockRegion.forEachEntry((x, y, z, state) -> {
            into.addBlock(x + xo, y + yo, z + zo, (class_2680)state);
            if (y == minY && state.method_51366()) {
                for (int y2 = y - 1; y2 > y - 33 && !level.method_8320((class_2338)mutableBlockPos.method_10103(x + xo, y2 + yo, z + zo)).method_51366(); --y2) {
                    into.addBlock(x + xo, y2 + yo, z + zo, (class_2680)state);
                }
            }
        });
        for (Long2ObjectMap.Entry entry : this.blockEntities.long2ObjectEntrySet()) {
            blockEntities.put(class_2338.method_10096((long)entry.getLongKey(), (int)xo, (int)yo, (int)zo), (Object)((CompressedBlockEntity)entry.getValue()));
        }
    }

    public void pasteIntoApplyGravity(ChunkedBlockRegion into, Long2ObjectMap<CompressedBlockEntity> blockEntities, class_1937 level) {
        int minX = this.blockRegion.min().method_10263();
        int minY = this.blockRegion.min().method_10264();
        int minZ = this.blockRegion.min().method_10260();
        int maxX = this.blockRegion.max().method_10263();
        int maxY = this.blockRegion.max().method_10264();
        int maxZ = this.blockRegion.max().method_10260();
        int xo = this.x - (maxX + minX) / 2;
        int yo = this.y - (maxY + minY) / 2;
        int zo = this.z - (maxZ + minZ) / 2;
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        this.blockRegion.forEachEntryLowestFirst((x, y, z, state) -> {
            for (int y2 = y - 1; y2 > y - 33; --y2) {
                mutableBlockPos.method_10103(x + xo, y2 + yo, z + zo);
                class_2680 existing = into.getBlockStateOrDelegate((class_2338)mutableBlockPos, level);
                if (existing.method_26215()) continue;
                into.addBlock(x + xo, y2 + yo + 1, z + zo, (class_2680)state);
                long pos = class_2338.method_10064((int)x, (int)y, (int)z);
                CompressedBlockEntity blockEntity = (CompressedBlockEntity)this.blockEntities.get(pos);
                if (blockEntity == null) break;
                blockEntities.put(class_2338.method_10064((int)(x + xo), (int)(y2 + yo + 1), (int)(z + zo)), (Object)blockEntity);
                break;
            }
        });
    }

    public class_243 getRenderOffset() {
        int minX = this.blockRegion.min().method_10263();
        int minY = this.blockRegion.min().method_10264();
        int minZ = this.blockRegion.min().method_10260();
        int maxX = this.blockRegion.max().method_10263();
        int maxY = this.blockRegion.max().method_10264();
        int maxZ = this.blockRegion.max().method_10260();
        int x = this.x - (maxX + minX) / 2;
        int y = this.y - (maxY + minY) / 2;
        int z = this.z - (maxZ + minZ) / 2;
        return new class_243((double)x, (double)y, (double)z);
    }
}

