/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools;

import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.utils.AsyncFileDialogs;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.Nullable;

public class ImageHeightmapProvider {
    public static Path getHeightmapDirectory() {
        return Axiom.getInstance().getConfigDirectory().resolve("heightmaps");
    }

    private static void loadDefaultFolder() {
        boolean loadDefault;
        Path directory = ImageHeightmapProvider.getHeightmapDirectory();
        Path defaultMarker = directory.resolve(".created_default_heightmaps");
        try {
            Files.deleteIfExists(directory.resolve(".loaded_defaults"));
            Files.deleteIfExists(directory.resolve(".loaded_default_heightmaps"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        boolean bl = loadDefault = !Files.exists(directory, new LinkOption[0]) || !Files.exists(defaultMarker, new LinkOption[0]);
        if (loadDefault) {
            try {
                Files.createDirectories(directory, new FileAttribute[0]);
                try {
                    Files.createFile(defaultMarker, new FileAttribute[0]);
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {
                    // empty catch block
                }
                Path dunes = directory.resolve("dunes");
                Path geometric = directory.resolve("geometric");
                Path procedural = directory.resolve("procedural");
                Path realworld = directory.resolve("realworld");
                Files.createDirectories(dunes, new FileAttribute[0]);
                Files.createDirectories(geometric, new FileAttribute[0]);
                Files.createDirectories(procedural, new FileAttribute[0]);
                Files.createDirectories(realworld, new FileAttribute[0]);
                ImageHeightmapProvider.putDefaultFile(dunes.resolve("cross.png"), "/default_heightmaps/dunes/cross.png");
                ImageHeightmapProvider.putDefaultFile(dunes.resolve("simple_25.png"), "/default_heightmaps/dunes/simple_25.png");
                ImageHeightmapProvider.putDefaultFile(dunes.resolve("simple_50.png"), "/default_heightmaps/dunes/simple_50.png");
                ImageHeightmapProvider.putDefaultFile(dunes.resolve("simple_100.png"), "/default_heightmaps/dunes/simple_100.png");
                ImageHeightmapProvider.putDefaultFile(geometric.resolve("clover.png"), "/default_heightmaps/geometric/clover.png");
                ImageHeightmapProvider.putDefaultFile(geometric.resolve("semicircle.png"), "/default_heightmaps/geometric/semicircle.png");
                ImageHeightmapProvider.putDefaultFile(geometric.resolve("square.png"), "/default_heightmaps/geometric/square.png");
                ImageHeightmapProvider.putDefaultFile(geometric.resolve("triangle.png"), "/default_heightmaps/geometric/triangle.png");
                ImageHeightmapProvider.putDefaultFile(procedural.resolve("cells.png"), "/default_heightmaps/procedural/cells.png");
                ImageHeightmapProvider.putDefaultFile(procedural.resolve("cloudy.png"), "/default_heightmaps/procedural/cloudy.png");
                ImageHeightmapProvider.putDefaultFile(procedural.resolve("cubism.png"), "/default_heightmaps/procedural/cubism.png");
                ImageHeightmapProvider.putDefaultFile(procedural.resolve("rocky.png"), "/default_heightmaps/procedural/rocky.png");
                ImageHeightmapProvider.putDefaultFile(procedural.resolve("smoke.png"), "/default_heightmaps/procedural/smoke.png");
                ImageHeightmapProvider.putDefaultFile(procedural.resolve("swirl.png"), "/default_heightmaps/procedural/swirl.png");
                ImageHeightmapProvider.putDefaultFile(realworld.resolve("california_gulf.png"), "/default_heightmaps/realworld/california_gulf.png");
                ImageHeightmapProvider.putDefaultFile(realworld.resolve("cerro_nevado.png"), "/default_heightmaps/realworld/cerro_nevado.png");
                ImageHeightmapProvider.putDefaultFile(realworld.resolve("gunung_agung.png"), "/default_heightmaps/realworld/gunung_agung.png");
                ImageHeightmapProvider.putDefaultFile(realworld.resolve("hawassa.png"), "/default_heightmaps/realworld/hawassa.png");
                ImageHeightmapProvider.putDefaultFile(realworld.resolve("matterhorn.png"), "/default_heightmaps/realworld/matterhorn.png");
                ImageHeightmapProvider.putDefaultFile(realworld.resolve("pico_de_tancitaro.png"), "/default_heightmaps/realworld/pico_de_tancitaro.png");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void putDefaultFile(Path target, String resource) {
        try {
            InputStream png = ImageHeightmapProvider.class.getResourceAsStream(resource);
            if (png != null) {
                Files.write(target, png.readAllBytes(), new OpenOption[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Nullable
    public static CompletableFuture<BufferedImage> chooseHeightmap() {
        String separator;
        ImageHeightmapProvider.loadDefaultFolder();
        Path directory = ImageHeightmapProvider.getHeightmapDirectory();
        if (!Files.exists(directory, new LinkOption[0]) || !Files.isDirectory(directory, new LinkOption[0])) {
            return null;
        }
        Object defaultPath = directory.toString();
        if (!((String)defaultPath).endsWith(separator = directory.getFileSystem().getSeparator())) {
            defaultPath = (String)defaultPath + separator;
        }
        CompletableFuture<String> fileFuture = AsyncFileDialogs.openFileDialog((String)defaultPath, "Image", "png");
        return fileFuture.thenApply(pathStr -> {
            if (pathStr == null) {
                return null;
            }
            Path path = Path.of(pathStr, new String[0]);
            try {
                return ImageIO.read(path.toFile());
            }
            catch (Throwable t2) {
                return null;
            }
        });
    }
}

