/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.configuration;

import com.moulberry.axiom.configuration.BlockAttributesConfiguration;
import com.moulberry.axiom.configuration.BlueprintConfiguration;
import com.moulberry.axiom.configuration.CapabilitiesConfiguration;
import com.moulberry.axiom.configuration.InternalConfiguration;
import com.moulberry.axiom.configuration.KeybindConfiguration;
import com.moulberry.axiom.configuration.RenderingConfiguration;
import com.moulberry.axiom.utils.ChatUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;

public class Configuration {
    private static final Lock lock = new ReentrantLock();
    private static HoconConfigurationLoader mainLoader = null;
    private static CommentedConfigurationNode mainRoot = null;
    private static HoconConfigurationLoader internalLoader = null;
    private static CommentedConfigurationNode internalRoot = null;
    public static CapabilitiesConfiguration capabilities;
    public static BlockAttributesConfiguration blockAttributes;
    public static BlueprintConfiguration blueprint;
    public static RenderingConfiguration rendering;
    public static KeybindConfiguration keybind;
    public static InternalConfiguration internal;

    public static void load(Path main, Path internal) {
        if (mainLoader != null) {
            throw new IllegalStateException();
        }
        mainLoader = ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().path(main)).emitComments(true).prettyPrinting(true).defaultOptions(ConfigurationOptions.defaults().header("Axiom Configuration"))).build();
        internalLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().path(internal)).prettyPrinting(true).build();
        lock.lock();
        try {
            mainRoot = Files.exists(main, new LinkOption[0]) && Files.size(main) > 1L ? (CommentedConfigurationNode)mainLoader.load() : (CommentedConfigurationNode)mainLoader.createNode();
            internalRoot = Files.exists(internal, new LinkOption[0]) && Files.size(internal) > 1L ? (CommentedConfigurationNode)internalLoader.load() : (CommentedConfigurationNode)internalLoader.createNode();
        }
        catch (IOException e) {
            System.err.println("An error occurred while loading this configuration: " + e.getMessage());
            if (e.getCause() != null) {
                e.getCause().printStackTrace();
            }
            System.exit(-847);
            return;
        }
        finally {
            lock.unlock();
        }
        Configuration.init();
        Configuration.save();
    }

    private static void init() {
        capabilities = new CapabilitiesConfiguration((CommentedConfigurationNode)mainRoot.node(new Object[]{"capabilities"}));
        blockAttributes = new BlockAttributesConfiguration((CommentedConfigurationNode)mainRoot.node(new Object[]{"blockAttributes"}));
        rendering = new RenderingConfiguration((CommentedConfigurationNode)mainRoot.node(new Object[]{"rendering"}));
        keybind = new KeybindConfiguration((CommentedConfigurationNode)mainRoot.node(new Object[]{"keybinds"}));
        blueprint = new BlueprintConfiguration((CommentedConfigurationNode)mainRoot.node(new Object[]{"blueprint"}));
        internal = new InternalConfiguration(internalRoot);
    }

    public static void save() {
        if (mainRoot == null) {
            return;
        }
        if (lock.tryLock()) {
            try {
                capabilities.save();
                blockAttributes.save();
                rendering.save();
                keybind.save();
                blueprint.save();
                internal.save();
                mainLoader.save(mainRoot);
                internalLoader.save(internalRoot);
            }
            catch (Exception e) {
                ChatUtils.error("Unable to save Axiom configuration: " + e.getMessage());
            }
            finally {
                lock.unlock();
            }
        }
    }
}

