/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.collections;

import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.utils.BlockCondition;
import com.moulberry.axiom.utils.PositionUtils;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Arrays;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2841;

public class ChunkedPredicateDistanceField {
    private static final int CHAMFER_A = 108;
    private static final int CHAMFER_B = 153;
    private static final int CHAMFER_C = 187;
    private static final int MAX_VALUE = 0x7FFFFF44;
    private final Long2ByteOpenHashMap sectionFlags = new Long2ByteOpenHashMap();
    private final Long2ObjectMap<int[]> map = new Long2ObjectOpenHashMap();
    private final SectionProvider sectionProvider;
    private final BlockCondition predicate;
    private static final int FLAG_PROPAGATE_EDGE_X = 1;
    private static final int FLAG_PROPAGATE_EDGE_Y = 2;
    private static final int FLAG_PROPAGATE_EDGE_Z = 4;
    private static final int FLAG_PROPAGATE_FACE_X = 14;
    private static final int FLAG_PROPAGATE_FACE_Y = 21;
    private static final int FLAG_PROPAGATE_FACE_Z = 35;
    private static final int FLAG_PROPAGATE_ALL = 127;
    private long lastChunkPos = PositionUtils.MIN_POSITION_LONG;
    private int[] lastChunk = null;

    public ChunkedPredicateDistanceField(SectionProvider sectionProvider, BlockCondition predicate) {
        this.sectionProvider = sectionProvider;
        this.predicate = predicate;
    }

    private int[] computeCorner(int cx, int cy, int cz) {
        long key = class_2338.method_10064((int)cx, (int)cy, (int)cz);
        if (this.map.containsKey(key)) {
            return (int[])this.map.get(key);
        }
        int[] distances = new int[5832];
        Arrays.fill(distances, 0x7FFFFF44);
        class_2841<class_2680> container = this.sectionProvider.get(cx, cy, cz);
        if (container != null) {
            this.propagateInitial(distances, container);
        }
        this.map.put(key, (Object)distances);
        return distances;
    }

    private int[] computeEdge(int cx, int cy, int cz, int[] p, int[] n, class_2350.class_2351 axis) {
        boolean initial;
        int[] distances;
        int cStep;
        int bStep;
        int aStep;
        int propagateFlag = switch (axis) {
            case class_2350.class_2351.field_11048 -> {
                aStep = 1;
                bStep = 18;
                cStep = 324;
                yield 1;
            }
            case class_2350.class_2351.field_11052 -> {
                aStep = 18;
                bStep = 1;
                cStep = 324;
                yield 2;
            }
            case class_2350.class_2351.field_11051 -> {
                aStep = 324;
                bStep = 1;
                cStep = 18;
                yield 4;
            }
            default -> throw new FaultyImplementationError();
        };
        long key = class_2338.method_10064((int)cx, (int)cy, (int)cz);
        if (this.map.containsKey(key)) {
            distances = (int[])this.map.get(key);
            if ((this.sectionFlags.get(key) & propagateFlag) == propagateFlag) {
                return distances;
            }
            initial = false;
        } else {
            distances = new int[5832];
            Arrays.fill(distances, 0x7FFFFF44);
            initial = true;
        }
        for (int b = 0; b < 16; ++b) {
            for (int c = 0; c < 16; ++c) {
                distances[16 * aStep + b * bStep + c * cStep + 343] = p[0 * aStep + b * bStep + c * cStep + 343];
                distances[-1 * aStep + b * bStep + c * cStep + 343] = n[15 * aStep + b * bStep + c * cStep + 343];
            }
        }
        if (initial) {
            class_2841<class_2680> container = this.sectionProvider.get(cx, cy, cz);
            if (container != null) {
                this.propagateInitial(distances, container);
            } else {
                this.propagate(distances);
            }
            this.map.put(key, (Object)distances);
        } else {
            this.propagate(distances);
        }
        this.sectionFlags.put(key, (byte)(this.sectionFlags.get(key) | propagateFlag));
        return distances;
    }

    private int[] computeFace(int cx, int cy, int cz, int[] zp, int[] zn, int[] pz, int[] nz, class_2350.class_2351 axis) {
        boolean initial;
        int[] distances;
        int cStep;
        int bStep;
        int aStep;
        int propagateFlag = switch (axis) {
            case class_2350.class_2351.field_11048 -> {
                aStep = 1;
                bStep = 18;
                cStep = 324;
                yield 14;
            }
            case class_2350.class_2351.field_11052 -> {
                aStep = 18;
                bStep = 1;
                cStep = 324;
                yield 21;
            }
            case class_2350.class_2351.field_11051 -> {
                aStep = 324;
                bStep = 1;
                cStep = 18;
                yield 35;
            }
            default -> throw new FaultyImplementationError();
        };
        long key = class_2338.method_10064((int)cx, (int)cy, (int)cz);
        if (this.map.containsKey(key)) {
            distances = (int[])this.map.get(key);
            if ((this.sectionFlags.get(key) & propagateFlag) == propagateFlag) {
                return distances;
            }
            initial = false;
        } else {
            distances = new int[5832];
            Arrays.fill(distances, 0x7FFFFF44);
            initial = true;
        }
        for (int a = 0; a < 16; ++a) {
            for (int c = 0; c < 16; ++c) {
                distances[a * aStep + 16 * bStep + c * cStep + 343] = pz[a * aStep + 0 * bStep + c * cStep + 343];
                distances[a * aStep + -1 * bStep + c * cStep + 343] = nz[a * aStep + 15 * bStep + c * cStep + 343];
                distances[a * aStep + c * bStep + 16 * cStep + 343] = zp[a * aStep + c * bStep + 0 * cStep + 343];
                distances[a * aStep + c * bStep + -1 * cStep + 343] = zn[a * aStep + c * bStep + 15 * cStep + 343];
            }
        }
        if (initial) {
            class_2841<class_2680> container = this.sectionProvider.get(cx, cy, cz);
            if (container != null) {
                this.propagateInitial(distances, container);
            } else {
                this.propagate(distances);
            }
            this.map.put(key, (Object)distances);
        } else {
            this.propagate(distances);
        }
        this.sectionFlags.put(key, (byte)(this.sectionFlags.get(key) | propagateFlag));
        return distances;
    }

    private int[] computeFull(int cx, int cy, int cz) {
        boolean initial;
        int[] distances;
        int[] ppp = this.computeCorner(cx + 1, cy + 1, cz + 1);
        int[] npp = this.computeCorner(cx - 1, cy + 1, cz + 1);
        int[] pnp = this.computeCorner(cx + 1, cy - 1, cz + 1);
        int[] nnp = this.computeCorner(cx - 1, cy - 1, cz + 1);
        int[] ppn = this.computeCorner(cx + 1, cy + 1, cz - 1);
        int[] npn = this.computeCorner(cx - 1, cy + 1, cz - 1);
        int[] pnn = this.computeCorner(cx + 1, cy - 1, cz - 1);
        int[] nnn = this.computeCorner(cx - 1, cy - 1, cz - 1);
        int[] zpp = this.computeEdge(cx, cy + 1, cz + 1, ppp, npp, class_2350.class_2351.field_11048);
        int[] znp = this.computeEdge(cx, cy - 1, cz + 1, pnp, nnp, class_2350.class_2351.field_11048);
        int[] zpn = this.computeEdge(cx, cy + 1, cz - 1, ppn, npn, class_2350.class_2351.field_11048);
        int[] znn = this.computeEdge(cx, cy - 1, cz - 1, pnn, nnn, class_2350.class_2351.field_11048);
        int[] pzp = this.computeEdge(cx + 1, cy, cz + 1, ppp, pnp, class_2350.class_2351.field_11052);
        int[] nzp = this.computeEdge(cx - 1, cy, cz + 1, npp, nnp, class_2350.class_2351.field_11052);
        int[] pzn = this.computeEdge(cx + 1, cy, cz - 1, ppn, pnn, class_2350.class_2351.field_11052);
        int[] nzn = this.computeEdge(cx - 1, cy, cz - 1, npn, nnn, class_2350.class_2351.field_11052);
        int[] ppz = this.computeEdge(cx + 1, cy + 1, cz, ppp, ppn, class_2350.class_2351.field_11051);
        int[] npz = this.computeEdge(cx - 1, cy + 1, cz, npp, npn, class_2350.class_2351.field_11051);
        int[] pnz = this.computeEdge(cx + 1, cy - 1, cz, pnp, pnn, class_2350.class_2351.field_11051);
        int[] nnz = this.computeEdge(cx - 1, cy - 1, cz, nnp, nnn, class_2350.class_2351.field_11051);
        int[] pzz = this.computeFace(cx + 1, cy, cz, pzp, pzn, ppz, pnz, class_2350.class_2351.field_11048);
        int[] nzz = this.computeFace(cx - 1, cy, cz, nzp, nzn, npz, nnz, class_2350.class_2351.field_11048);
        int[] zpz = this.computeFace(cx, cy + 1, cz, zpp, zpn, ppz, npz, class_2350.class_2351.field_11052);
        int[] znz = this.computeFace(cx, cy - 1, cz, znp, znn, pnz, nnz, class_2350.class_2351.field_11052);
        int[] zzp = this.computeFace(cx, cy, cz + 1, zpp, znp, pzp, nzp, class_2350.class_2351.field_11051);
        int[] zzn = this.computeFace(cx, cy, cz - 1, zpn, znn, pzn, nzn, class_2350.class_2351.field_11051);
        long key = class_2338.method_10064((int)cx, (int)cy, (int)cz);
        if (this.map.containsKey(key)) {
            distances = (int[])this.map.get(key);
            initial = false;
        } else {
            distances = new int[5832];
            Arrays.fill(distances, 0x7FFFFF44);
            initial = true;
        }
        boolean xStep = true;
        int yStep = 18;
        int zStep = 324;
        for (int a = 0; a < 16; ++a) {
            for (int b = 0; b < 16; ++b) {
                distances[16 + a * 18 + b * 324 + 343] = pzz[0 + a * 18 + b * 324 + 343];
                distances[-1 + a * 18 + b * 324 + 343] = nzz[15 + a * 18 + b * 324 + 343];
                distances[a * 1 + 288 + b * 324 + 343] = zpz[a * 1 + 0 + b * 324 + 343];
                distances[a * 1 + -18 + b * 324 + 343] = znz[a * 1 + 270 + b * 324 + 343];
                distances[a * 1 + b * 18 + 5184 + 343] = zzp[a * 1 + b * 18 + 0 + 343];
                distances[a * 1 + b * 18 + -324 + 343] = zzn[a * 1 + b * 18 + 4860 + 343];
            }
        }
        if (initial) {
            class_2841<class_2680> container = this.sectionProvider.get(cx, cy, cz);
            if (container != null) {
                this.propagateInitial(distances, container);
            } else {
                this.propagate(distances);
            }
            this.map.put(key, (Object)distances);
        } else {
            this.propagate(distances);
        }
        this.sectionFlags.put(class_2338.method_10064((int)cx, (int)cy, (int)cz), (byte)127);
        return distances;
    }

    private void propagateInitial(int[] distances, class_2841<class_2680> container) {
        int index;
        int z;
        int y;
        int x;
        boolean xIndexOffset = true;
        int yIndexOffset = 18;
        int zIndexOffset = 324;
        for (x = 0; x < 16; ++x) {
            for (y = 0; y < 16; ++y) {
                for (z = 0; z < 16; ++z) {
                    index = (x + 1) * 1 + (y + 1) * 18 + (z + 1) * 324;
                    class_2680 blockState = (class_2680)container.method_12321(x, y, z);
                    if (this.predicate.matches(blockState)) {
                        distances[index] = 0;
                        continue;
                    }
                    int least = 0x7FFFFF44;
                    least = Math.min(least, distances[index - 1 - 18 - 324] + 187);
                    least = Math.min(least, distances[index - 1 - 18] + 153);
                    least = Math.min(least, distances[index - 1 - 18 + 324] + 187);
                    least = Math.min(least, distances[index - 1 - 324] + 153);
                    least = Math.min(least, distances[index - 1] + 108);
                    least = Math.min(least, distances[index - 1 + 324] + 153);
                    least = Math.min(least, distances[index - 1 + 18 - 324] + 187);
                    least = Math.min(least, distances[index - 1 + 18] + 153);
                    least = Math.min(least, distances[index - 1 + 18 + 324] + 187);
                    least = Math.min(least, distances[index - 18 - 324] + 153);
                    least = Math.min(least, distances[index - 18] + 108);
                    least = Math.min(least, distances[index - 18 + 324] + 153);
                    distances[index] = least = Math.min(least, distances[index - 324] + 108);
                }
            }
        }
        for (x = 15; x >= 0; --x) {
            for (y = 15; y >= 0; --y) {
                for (z = 15; z >= 0; --z) {
                    index = (x + 1) * 1 + (y + 1) * 18 + (z + 1) * 324;
                    int least = distances[index];
                    least = Math.min(least, distances[index + 1 + 18 + 324] + 187);
                    least = Math.min(least, distances[index + 1 + 18] + 153);
                    least = Math.min(least, distances[index + 1 + 18 - 324] + 187);
                    least = Math.min(least, distances[index + 1 + 324] + 153);
                    least = Math.min(least, distances[index + 1] + 108);
                    least = Math.min(least, distances[index + 1 - 324] + 153);
                    least = Math.min(least, distances[index + 1 - 18 + 324] + 187);
                    least = Math.min(least, distances[index + 1 - 18] + 153);
                    least = Math.min(least, distances[index + 1 - 18 - 324] + 187);
                    least = Math.min(least, distances[index + 18 + 324] + 153);
                    least = Math.min(least, distances[index + 18] + 108);
                    least = Math.min(least, distances[index + 18 - 324] + 153);
                    distances[index] = least = Math.min(least, distances[index + 324] + 108);
                }
            }
        }
    }

    private void propagate(int[] distances) {
        int least;
        int index;
        int z;
        int y;
        int x;
        boolean xIndexOffset = true;
        int yIndexOffset = 18;
        int zIndexOffset = 324;
        for (x = 0; x < 16; ++x) {
            for (y = 0; y < 16; ++y) {
                for (z = 0; z < 16; ++z) {
                    index = (x + 1) * 1 + (y + 1) * 18 + (z + 1) * 324;
                    least = distances[index];
                    least = Math.min(least, distances[index - 1 - 18 - 324] + 187);
                    least = Math.min(least, distances[index - 1 - 18] + 153);
                    least = Math.min(least, distances[index - 1 - 18 + 324] + 187);
                    least = Math.min(least, distances[index - 1 - 324] + 153);
                    least = Math.min(least, distances[index - 1] + 108);
                    least = Math.min(least, distances[index - 1 + 324] + 153);
                    least = Math.min(least, distances[index - 1 + 18 - 324] + 187);
                    least = Math.min(least, distances[index - 1 + 18] + 153);
                    least = Math.min(least, distances[index - 1 + 18 + 324] + 187);
                    least = Math.min(least, distances[index - 18 - 324] + 153);
                    least = Math.min(least, distances[index - 18] + 108);
                    least = Math.min(least, distances[index - 18 + 324] + 153);
                    distances[index] = least = Math.min(least, distances[index - 324] + 108);
                }
            }
        }
        for (x = 15; x >= 0; --x) {
            for (y = 15; y >= 0; --y) {
                for (z = 15; z >= 0; --z) {
                    index = (x + 1) * 1 + (y + 1) * 18 + (z + 1) * 324;
                    least = distances[index];
                    least = Math.min(least, distances[index + 1 + 18 + 324] + 187);
                    least = Math.min(least, distances[index + 1 + 18] + 153);
                    least = Math.min(least, distances[index + 1 + 18 - 324] + 187);
                    least = Math.min(least, distances[index + 1 + 324] + 153);
                    least = Math.min(least, distances[index + 1] + 108);
                    least = Math.min(least, distances[index + 1 - 324] + 153);
                    least = Math.min(least, distances[index + 1 - 18 + 324] + 187);
                    least = Math.min(least, distances[index + 1 - 18] + 153);
                    least = Math.min(least, distances[index + 1 - 18 - 324] + 187);
                    least = Math.min(least, distances[index + 18 + 324] + 153);
                    least = Math.min(least, distances[index + 18] + 108);
                    least = Math.min(least, distances[index + 18 - 324] + 153);
                    distances[index] = least = Math.min(least, distances[index + 324] + 108);
                }
            }
        }
    }

    public void reset() {
        this.sectionFlags.clear();
        this.map.clear();
        this.lastChunkPos = PositionUtils.MIN_POSITION_LONG;
        this.lastChunk = null;
    }

    public int getDistance(int x, int y, int z) {
        int xC = x >> 4;
        int yC = y >> 4;
        int zC = z >> 4;
        int[] array = this.getOrCreateChunk(xC, yC, zC);
        return array[(x & 0xF) + (y & 0xF) * 18 + (z & 0xF) * 18 * 18 + 343];
    }

    public int[] getOrCreateChunk(int cx, int cy, int cz) {
        long pos = class_2338.method_10064((int)cx, (int)cy, (int)cz);
        if (this.lastChunk == null || this.lastChunkPos != pos) {
            int[] chunk = this.sectionFlags.get(pos) == 127 ? (int[])this.map.get(pos) : this.computeFull(cx, cy, cz);
            this.lastChunkPos = pos;
            this.lastChunk = chunk;
        }
        return this.lastChunk;
    }

    @FunctionalInterface
    public static interface SectionProvider {
        public class_2841<class_2680> get(int var1, int var2, int var3);
    }
}

