/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.WholeImageFilter;
import java.awt.Rectangle;

public class ReduceNoiseFilter
extends WholeImageFilter {
    private int smooth(int[] v) {
        int minindex = 0;
        int maxindex = 0;
        int min2 = Integer.MAX_VALUE;
        int max2 = Integer.MIN_VALUE;
        for (int i = 0; i < 9; ++i) {
            if (i == 4) continue;
            if (v[i] < min2) {
                min2 = v[i];
                minindex = i;
            }
            if (v[i] <= max2) continue;
            max2 = v[i];
            maxindex = i;
        }
        if (v[4] < min2) {
            return v[minindex];
        }
        if (v[4] > max2) {
            return v[maxindex];
        }
        return v[4];
    }

    protected int[] filterPixels(int width, int height, int[] inPixels, Rectangle transformedSpace) {
        int index = 0;
        int[] r = new int[9];
        int[] g2 = new int[9];
        int[] b = new int[9];
        int[] outPixels = new int[width * height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int k = 0;
                for (int dy = -1; dy <= 1; ++dy) {
                    int iy = y + dy;
                    if (0 > iy || iy >= height) continue;
                    int ioffset = iy * width;
                    for (int dx = -1; dx <= 1; ++dx) {
                        int ix = x + dx;
                        if (0 > ix || ix >= width) continue;
                        int rgb = inPixels[ioffset + ix];
                        r[k] = rgb >> 16 & 0xFF;
                        g2[k] = rgb >> 8 & 0xFF;
                        b[k] = rgb & 0xFF;
                        ++k;
                    }
                }
                while (k < 9) {
                    b[k] = 0;
                    g2[k] = 0;
                    r[k] = 0;
                    ++k;
                }
                outPixels[index] = inPixels[index] & 0xFF000000 | this.smooth(r) << 16 | this.smooth(g2) << 8 | this.smooth(b);
                ++index;
            }
        }
        return outPixels;
    }

    public String toString() {
        return "Blur/Smooth";
    }
}

