/*
 * Decompiled with CFR 0.152.
 */
package net.fieldb0y.wanna_play_chess.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.fieldb0y.wanna_play_chess.chess.ChessGrid;
import net.fieldb0y.wanna_play_chess.chess.utils.ChessPieces;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5481;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector2i;
import org.joml.Vector4i;

public class Utils {
    public static boolean isMouseInBounds(int x, int y, int width, int height, double mouseX, double mouseY) {
        return mouseX >= (double)(x - 1) && mouseX < (double)(x + width + 1) && mouseY >= (double)(y - 1) && mouseY < (double)(y + height + 1);
    }

    public static boolean isCellInSquare(int cellX, int cellY, int centerX, int centerY, int squareRadius) {
        boolean withinX = cellX >= centerX - squareRadius && cellX <= centerX + squareRadius;
        boolean withinY = cellY >= centerY - squareRadius && cellY <= centerY + squareRadius;
        return withinX && withinY;
    }

    public static boolean isPathHasNoPieces(List<Vector2i> path, ChessGrid grid) {
        for (Vector2i cell : path) {
            if (grid.safeGetPieceId(cell.x, cell.y) == ChessPieces.EMPTY.id) continue;
            return false;
        }
        return true;
    }

    public static List<Vector2f> toRelative(List<Vector2i> absoluteVertices, int windowWidth, int windowHeight) {
        ArrayList<Vector2f> relativeVertices = new ArrayList<Vector2f>();
        for (Vector2i absoluteVertex : absoluteVertices) {
            relativeVertices.add(Utils.toRelative(absoluteVertex, windowWidth, windowHeight));
        }
        return relativeVertices;
    }

    public static Vector2f toRelative(Vector2i absoluteVertex, int windowWidth, int windowHeight) {
        return new Vector2f((float)absoluteVertex.x / (float)windowWidth, (float)absoluteVertex.y / (float)windowHeight);
    }

    public static Vector2i secondsToMinAndSec(int seconds) {
        return new Vector2i((int)Math.floor((double)seconds / 60.0), seconds % 60);
    }

    public static String timeToString(Vector2i time) {
        if (time.equals(-1, -1)) {
            return "\u2014\u2014:\u2014\u2014";
        }
        return time.x + ":" + (String.valueOf(time.y).length() == 1 ? "0" : "") + time.y;
    }

    public static File getFile(String path) {
        return new File(path);
    }

    public static void drawLine(class_332 context, int x1, int y1, int x2, int y2, int color) {
        int dx = Math.abs(x2 - x1);
        int dy = Math.abs(y2 - y1);
        int sx = x1 < x2 ? 1 : -1;
        int sy = y1 < y2 ? 1 : -1;
        int err = dx - dy;
        int currentX = x1;
        int currentY = y1;
        while (true) {
            context.method_25294(currentX, currentY, currentX + 1, currentY + 1, color);
            if (currentX == x2 && currentY == y2) break;
            int e2 = 2 * err;
            if (e2 > -dy) {
                err -= dy;
                currentX += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            currentY += sy;
        }
    }

    public static void advancedFill(class_332 context, int x1, int y1, int x2, int y2, Vector4i color) {
        int i;
        Matrix4f matrix4f = context.method_51448().method_23760().method_23761();
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        class_4588 vertexConsumer = context.method_51450().getBuffer(class_1921.method_51784());
        vertexConsumer.method_22918(matrix4f, (float)x1, (float)y1, 0.0f).method_1336(color.x, color.y, color.z, color.w);
        vertexConsumer.method_22918(matrix4f, (float)x1, (float)y2, 0.0f).method_1336(color.x, color.y, color.z, color.w);
        vertexConsumer.method_22918(matrix4f, (float)x2, (float)y2, 0.0f).method_1336(color.x, color.y, color.z, color.w);
        vertexConsumer.method_22918(matrix4f, (float)x2, (float)y1, 0.0f).method_1336(color.x, color.y, color.z, color.w);
        context.method_51452();
    }

    public static void renderScaledHead(class_332 context, class_1799 head, float scale, int baseX, int baseY) {
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_46416((float)(baseX + 8), (float)(baseY + 8), 0.0f);
        matrices.method_22905(scale, scale, scale);
        matrices.method_46416(-8.0f, -8.0f, 0.0f);
        context.method_51427(head, 0, 0);
        matrices.method_22909();
    }

    public static String orderedTextToString(class_5481 orderedText) {
        StringBuilder stringBuilder = new StringBuilder();
        orderedText.accept((index, style, codePoint) -> {
            stringBuilder.appendCodePoint(codePoint);
            return true;
        });
        return stringBuilder.toString();
    }
}

