/*
 * Decompiled with CFR 0.152.
 */
package net.fieldb0y.wanna_play_chess.screen;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fieldb0y.wanna_play_chess.chess.gameStates.ChessGameState;
import net.fieldb0y.wanna_play_chess.chess.renderingStates.ChessGameRenderingState;
import net.fieldb0y.wanna_play_chess.network.c2sPayloads.CellClickPayload;
import net.fieldb0y.wanna_play_chess.screen.ClickableRect;
import net.minecraft.class_332;
import net.minecraft.class_8710;
import org.joml.Vector2f;

public class ClickableGrid {
    private static final String FILE_PATH = "/assets/wanna_play_chess/grid/clickable2.grid";
    public ChessGameRenderingState renderingState;
    public List<ClickableRect> rects = new ArrayList<ClickableRect>();
    private boolean isActive = true;

    public ClickableGrid(ChessGameRenderingState renderingState) {
        this.renderingState = renderingState;
        this.generate();
    }

    public void render(class_332 context) {
        for (ClickableRect rect : this.rects) {
            rect.render(context);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY) {
        if (this.isActive) {
            ClickableRect rect = this.getClickedRect(mouseX, mouseY);
            if (rect == null) {
                return false;
            }
            int x = this.renderingState.getPlayerRole() == 0 ? rect.gridX : rect.getOppositeX();
            int y = this.renderingState.getPlayerRole() == 0 ? rect.gridY : rect.getOppositeY();
            ClientPlayNetworking.send((class_8710)new CellClickPayload(this.renderingState.blockEntity.method_11016(), x, y, ((ChessGameState)this.renderingState.getServerState()).isSingleplayer ? ((ChessGameState)this.renderingState.getServerState()).currentTurn : this.renderingState.getPlayerRole()));
        }
        return true;
    }

    private ClickableRect getClickedRect(double mouseX, double mouseY) {
        for (ClickableRect rect : this.rects) {
            if (!rect.isMouseInRect(mouseX, mouseY)) continue;
            return rect;
        }
        return null;
    }

    public void onScreenResize() {
        int x = this.renderingState.getScreenWidth() / 2 - 213 * this.renderingState.getScreenHeight() / 240;
        for (ClickableRect rect : this.rects) {
            rect.updateVertices(this.renderingState.getScreenHeight());
            rect.setOffset(x, rect.offset.y);
        }
    }

    public void generate() {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(Objects.requireNonNull(this.getClass().getResourceAsStream(FILE_PATH))));){
            for (int i = 0; i < 8; ++i) {
                String line;
                for (int j = 0; j < 8 && (line = br.readLine()) != null; ++j) {
                    this.rects.add(new ClickableRect(this.parseLineToVectorList(line), j, i, 427, 240, this.renderingState.getScreenHeight()));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private List<Vector2f> parseLineToVectorList(String line) {
        List<Vector2f> vertices = new ArrayList<Vector2f>();
        ArrayList<Float> numbers = new ArrayList<Float>();
        Pattern pattern = Pattern.compile("\\d+\\.\\d+");
        Matcher matcher = pattern.matcher(line);
        while (matcher.find()) {
            numbers.add(Float.valueOf(Float.parseFloat(matcher.group())));
        }
        if (numbers.size() >= 8) {
            vertices = List.of(new Vector2f(((Float)numbers.get(0)).floatValue(), ((Float)numbers.get(1)).floatValue()), new Vector2f(((Float)numbers.get(2)).floatValue(), ((Float)numbers.get(3)).floatValue()), new Vector2f(((Float)numbers.get(4)).floatValue(), ((Float)numbers.get(5)).floatValue()), new Vector2f(((Float)numbers.get(6)).floatValue(), ((Float)numbers.get(7)).floatValue()));
        }
        return vertices;
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }
}

