/*
 * Decompiled with CFR 0.152.
 */
package net.fieldb0y.wanna_play_chess.item.custom;

import java.util.List;
import java.util.Map;
import net.fieldb0y.wanna_play_chess.chess.ChessGrid;
import net.fieldb0y.wanna_play_chess.chess.PiecesData;
import net.fieldb0y.wanna_play_chess.chess.utils.ChessPieces;
import net.fieldb0y.wanna_play_chess.chess.utils.PieceAction;
import net.fieldb0y.wanna_play_chess.item.ModItems;
import net.fieldb0y.wanna_play_chess.item.custom.ChessPiece;
import net.fieldb0y.wanna_play_chess.utils.Role;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_918;
import org.joml.Vector2i;

public class Knight
extends ChessPiece {
    public Knight(class_1792.class_1793 settings, Role role) {
        super(settings, role);
    }

    @Override
    public class_1799 getWhiteStack() {
        return ModItems.WHITE_KNIGHT.method_7854();
    }

    @Override
    public class_1799 getBlackStack() {
        return ModItems.BLACK_KNIGHT.method_7854();
    }

    @Override
    public void render(class_918 renderer, class_4587 matrices, class_4597 vertexConsumers, class_1937 world, int light, int overlay, int xSquare, int ySquare) {
        super.render(renderer, matrices, vertexConsumers, world, light, overlay, xSquare, ySquare);
    }

    @Override
    protected Map<PieceAction, List<Vector2i>> calculateStandardMoves(int x, int y, int role, ChessGrid grid, List<Vector2i> moveCells, List<Vector2i> takeCells, boolean allPossible) {
        List<Vector2i> tempCells = List.of(new Vector2i(x + 1, y - 2), new Vector2i(x - 1, y - 2), new Vector2i(x - 2, y - 1), new Vector2i(x - 2, y + 1), new Vector2i(x - 1, y + 2), new Vector2i(x + 1, y + 2), new Vector2i(x + 2, y - 1), new Vector2i(x + 2, y + 1));
        for (Vector2i pos : tempCells) {
            int pieceId = grid.safeGetPieceId(pos.x, pos.y);
            if (pieceId == -1) continue;
            if (allPossible && ChessGrid.getPieceRole(pieceId) == role) {
                moveCells.add(pos);
            }
            if (pieceId == ChessPieces.EMPTY.id) {
                moveCells.add(pos);
                continue;
            }
            if (ChessGrid.getPieceRole(pieceId) == role) continue;
            takeCells.add(pos);
        }
        return Map.of(PieceAction.MOVE, moveCells, PieceAction.TAKE, takeCells);
    }

    @Override
    public void updatePieceData(Vector2i fromCell, Vector2i toCell, PiecesData data) {
        super.updatePieceData(fromCell, toCell, data);
    }
}

