/*
 * Decompiled with CFR 0.152.
 */
package net.fieldb0y.wanna_play_chess.item.custom;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fieldb0y.wanna_play_chess.chess.ChessGrid;
import net.fieldb0y.wanna_play_chess.chess.PiecesData;
import net.fieldb0y.wanna_play_chess.chess.utils.ChessPieces;
import net.fieldb0y.wanna_play_chess.chess.utils.PieceAction;
import net.fieldb0y.wanna_play_chess.item.ModItems;
import net.fieldb0y.wanna_play_chess.item.custom.ChessPiece;
import net.fieldb0y.wanna_play_chess.item.custom.Pawn;
import net.fieldb0y.wanna_play_chess.utils.Role;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_918;
import org.joml.Vector2i;

public class King
extends ChessPiece {
    public King(class_1792.class_1793 settings, Role role) {
        super(settings, role);
    }

    @Override
    public class_1799 getWhiteStack() {
        return ModItems.WHITE_KING.method_7854();
    }

    @Override
    public class_1799 getBlackStack() {
        return ModItems.BLACK_KING.method_7854();
    }

    @Override
    public void render(class_918 renderer, class_4587 matrices, class_4597 vertexConsumers, class_1937 world, int light, int overlay, int xSquare, int ySquare) {
        super.render(renderer, matrices, vertexConsumers, world, light, overlay, xSquare, ySquare);
    }

    @Override
    protected Map<PieceAction, List<Vector2i>> calculateStandardMoves(int x, int y, int role, ChessGrid grid, List<Vector2i> moveCells, List<Vector2i> takeCells, boolean allPossible) {
        ArrayList<Vector2i> castleCells = new ArrayList<Vector2i>();
        List<Vector2i> cells = List.of(new Vector2i(x, y - 1), new Vector2i(x, y + 1), new Vector2i(x - 1, y), new Vector2i(x + 1, y), new Vector2i(x + 1, y - 1), new Vector2i(x - 1, y - 1), new Vector2i(x + 1, y + 1), new Vector2i(x - 1, y + 1));
        for (Vector2i cell : cells) {
            PieceAction kingAction = this.getKingActionTo(cell.x, cell.y, role, grid);
            if (kingAction == PieceAction.MOVE) {
                moveCells.add(cell);
                continue;
            }
            if (kingAction != PieceAction.TAKE) continue;
            takeCells.add(cell);
        }
        if (grid.getGameState().piecesData.hasDataTag(x, y, PiecesData.DataTag.CAN_CASTLE_SHORT)) {
            castleCells.add(new Vector2i(x - 2, y));
        }
        if (grid.getGameState().piecesData.hasDataTag(x, y, PiecesData.DataTag.CAN_CASTLE_LONG)) {
            castleCells.add(new Vector2i(x + 2, y));
        }
        return Map.of(PieceAction.MOVE, moveCells, PieceAction.TAKE, takeCells, PieceAction.CASTLE, castleCells);
    }

    private PieceAction getKingActionTo(int x, int y, int role, ChessGrid grid) {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                int currentPieceId = grid.safeGetPieceId(i, j);
                if (ChessGrid.getPieceRole(currentPieceId) == role || currentPieceId == ChessPieces.EMPTY.id || currentPieceId == -1) continue;
                ChessPiece piece = ChessGrid.getPieceById(currentPieceId);
                if (currentPieceId == (role == 0 ? ChessPieces.BLACK_KING.id : ChessPieces.WHITE_KING.id)) {
                    if (!grid.isCellInArea(new Vector2i(i, j), new Vector2i(x, y), 1)) continue;
                    return PieceAction.NONE;
                }
                if (currentPieceId == ChessPieces.WHITE_PAWN.id || currentPieceId == ChessPieces.BLACK_PAWN.id || currentPieceId == ChessPieces.WHITE_KNIGHT.id || currentPieceId == ChessPieces.BLACK_KNIGHT.id) {
                    Map<PieceAction, List<Vector2i>> piecePossibleMoves = piece.getPossibleMoves(i, j, ChessGrid.getPieceRole(currentPieceId), grid, true);
                    for (List<Vector2i> list : piecePossibleMoves.values()) {
                        if (!list.contains(new Vector2i(x, y)) || piece instanceof Pawn && (ChessGrid.getPieceRole(currentPieceId) == 0 && new Vector2i(x, y).equals((Object)new Vector2i(i, j - 1)) || ChessGrid.getPieceRole(currentPieceId) == 1 && new Vector2i(x, y).equals((Object)new Vector2i(i, j + 1)))) continue;
                        return PieceAction.NONE;
                    }
                    continue;
                }
                List<Vector2i> path = ChessPiece.getAttackPath(new Vector2i(i, j), new Vector2i(x, y), piece, true);
                if (path.isEmpty() || path.getLast().equals(i, j)) continue;
                boolean isPieceOnPath = false;
                for (Vector2i cell : path) {
                    if (cell == path.getLast()) break;
                    int pieceId = grid.safeGetPieceId(cell.x, cell.y);
                    if (pieceId == (role == 0 ? ChessPieces.WHITE_KING.id : ChessPieces.BLACK_KING.id) || pieceId == ChessPieces.EMPTY.id) continue;
                    isPieceOnPath = true;
                    break;
                }
                if (path.isEmpty() || isPieceOnPath) continue;
                return PieceAction.NONE;
            }
        }
        int pieceId = grid.safeGetPieceId(x, y);
        return pieceId != -1 ? (pieceId == ChessPieces.EMPTY.id ? PieceAction.MOVE : (ChessGrid.getPieceRole(pieceId) != role ? PieceAction.TAKE : PieceAction.NONE)) : PieceAction.NONE;
    }

    @Override
    public void updatePieceData(Vector2i fromCell, Vector2i toCell, PiecesData data) {
        super.updatePieceData(fromCell, toCell, data);
    }
}

