/*
 * Decompiled with CFR 0.152.
 */
package net.fieldb0y.wanna_play_chess.item.custom;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fieldb0y.wanna_play_chess.block.entity.renderer.PieceAnimator;
import net.fieldb0y.wanna_play_chess.chess.ChessGrid;
import net.fieldb0y.wanna_play_chess.chess.PiecesData;
import net.fieldb0y.wanna_play_chess.chess.gameStates.ChessGameState;
import net.fieldb0y.wanna_play_chess.chess.utils.ChessPieces;
import net.fieldb0y.wanna_play_chess.chess.utils.PieceAction;
import net.fieldb0y.wanna_play_chess.item.custom.Bishop;
import net.fieldb0y.wanna_play_chess.item.custom.Queen;
import net.fieldb0y.wanna_play_chess.item.custom.Rook;
import net.fieldb0y.wanna_play_chess.utils.Role;
import net.fieldb0y.wanna_play_chess.utils.Utils;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_918;
import org.joml.Vector2i;

public abstract class ChessPiece
extends class_1792 {
    protected Role role;
    public static final float SQUARE_SIZE = 0.915f;

    public ChessPiece(class_1792.class_1793 settings, Role role) {
        super(settings);
        this.role = role;
    }

    public abstract class_1799 getWhiteStack();

    public abstract class_1799 getBlackStack();

    public void render(class_918 renderer, class_4587 matrices, class_4597 vertexConsumers, class_1937 world, int light, int overlay, int xSquare, int ySquare) {
        matrices.method_22903();
        matrices.method_22905(0.09f, 0.09f, 0.09f);
        matrices.method_46416(2.35f + (float)xSquare * 0.915f, 1.75f, 2.35f + (float)ySquare * 0.915f);
        if (this.role == Role.BLACK) {
            matrices.method_22907(class_7833.field_40715.rotationDegrees(180.0f));
        }
        renderer.method_23178(this.role == Role.WHITE ? this.getWhiteStack() : this.getBlackStack(), class_811.field_4315, light, overlay, matrices, vertexConsumers, world, 0);
        matrices.method_22909();
    }

    public void renderMovingAnimation(PieceAnimator animator, class_918 renderer, class_4587 matrices, class_4597 vertexConsumers, class_1937 world, int light, int overlay) {
        matrices.method_22903();
        float progress = animator.getProgress();
        Vector2i from = animator.fromCell;
        Vector2i to = animator.toCell;
        float startX = (float)from.x * 0.915f;
        float startZ = (float)from.y * 0.915f;
        float endX = (float)to.x * 0.915f;
        float endZ = (float)to.y * 0.915f;
        float currentX = startX + (endX - startX) * progress;
        float currentZ = startZ + (endZ - startZ) * progress;
        matrices.method_22905(0.09f, 0.09f, 0.09f);
        matrices.method_46416(2.35f + currentX, 1.75f, 2.35f + currentZ);
        if (this.role == Role.BLACK) {
            matrices.method_22907(class_7833.field_40715.rotationDegrees(180.0f));
        }
        renderer.method_23178(this.role == Role.WHITE ? this.getWhiteStack() : this.getBlackStack(), class_811.field_4315, light, overlay, matrices, vertexConsumers, world, 0);
        matrices.method_22909();
    }

    protected static void loopDirection(int dl, int x, int y, int xDir, int yDir, int role, List<Vector2i> moveCells, List<Vector2i> takeCells, ChessGrid grid, boolean getAllPossible) {
        for (int i = 1; i < dl; ++i) {
            Vector2i pos = new Vector2i(x + i * xDir, y + i * yDir);
            int pieceId = grid.safeGetPieceId(pos.x, pos.y);
            PieceAction action = ChessPiece.getAction(pieceId, role, getAllPossible);
            if (action == PieceAction.NONE) break;
            if (action == PieceAction.OTHER) {
                moveCells.add(pos);
                break;
            }
            if (action == PieceAction.MOVE) {
                moveCells.add(pos);
                continue;
            }
            takeCells.add(pos);
            if (!getAllPossible) break;
        }
    }

    protected static PieceAction getAction(int pieceId, int role, boolean getAllPossible) {
        if (pieceId == -1) {
            return PieceAction.NONE;
        }
        if (ChessGrid.getPieceRole(pieceId) == role) {
            return getAllPossible ? PieceAction.OTHER : PieceAction.NONE;
        }
        if (pieceId == ChessPieces.EMPTY.id) {
            return PieceAction.MOVE;
        }
        return PieceAction.TAKE;
    }

    protected abstract Map<PieceAction, List<Vector2i>> calculateStandardMoves(int var1, int var2, int var3, ChessGrid var4, List<Vector2i> var5, List<Vector2i> var6, boolean var7);

    public Map<PieceAction, List<Vector2i>> getPossibleMoves(int x, int y, int role, ChessGrid grid) {
        return this.getPossibleMoves(x, y, role, grid, false);
    }

    public Map<PieceAction, List<Vector2i>> getPossibleMoves(int x, int y, int role, ChessGrid grid, boolean allPossible) {
        ArrayList<Vector2i> moveCells = new ArrayList<Vector2i>();
        ArrayList<Vector2i> takeCells = new ArrayList<Vector2i>();
        ChessGameState state = grid.getGameState();
        Vector2i kingPos = grid.findPiecePos(role == 0 ? ChessPieces.WHITE_KING.id : ChessPieces.BLACK_KING.id);
        if (kingPos == null) {
            return Map.of();
        }
        if (state.getCheckedKingRole() == -1 || state.getCheckedKingRole() != role || kingPos.equals(x, y)) {
            Map<PieceAction, List<Vector2i>> standartMoves = this.calculateStandardMoves(x, y, role, grid, moveCells, takeCells, allPossible);
            ArrayList<Vector2i> realTakeCells = new ArrayList<Vector2i>();
            ArrayList<Vector2i> realMoveCells = new ArrayList<Vector2i>();
            if (state.piecesData.hasDataTag(x, y, PiecesData.DataTag.CANT_MOVE)) {
                for (int i = 0; i < 8; ++i) {
                    for (int j = 0; j < 8; ++j) {
                        List<Vector2i> path;
                        int id = grid.safeGetPieceId(i, j);
                        if (id == ChessPieces.EMPTY.id || id == -1 || id == ChessPieces.WHITE_KING.id || id == ChessPieces.BLACK_KING.id || !(path = ChessPiece.getAttackPath(kingPos, new Vector2i(i, j), ChessGrid.getPieceById(id), false)).contains(new Vector2i(x, y))) continue;
                        if (takeCells.contains(new Vector2i(i, j))) {
                            realTakeCells.add(new Vector2i(i, j));
                        }
                        for (Vector2i pathCell : path) {
                            if (!moveCells.contains(pathCell)) continue;
                            realMoveCells.add(pathCell);
                        }
                    }
                }
                return Map.of(PieceAction.MOVE, realMoveCells, PieceAction.TAKE, realTakeCells, PieceAction.NONE, List.of(new Vector2i(x, y)));
            }
            return standartMoves;
        }
        if (state.piecesData.hasDataTag(x, y, PiecesData.DataTag.CANT_MOVE)) {
            return Map.of(PieceAction.NONE, List.of(new Vector2i(x, y)));
        }
        List<Vector2i> checkingPiecesCells = grid.getCheckingPiecesCells();
        if (checkingPiecesCells.size() >= 2) {
            return Map.of();
        }
        Vector2i attackerPos = checkingPiecesCells.getFirst();
        ChessPiece attacker = grid.getPieceAt(attackerPos.x, attackerPos.y);
        List<Vector2i> attackPath = ChessPiece.getAttackPath(kingPos, attackerPos, attacker, false);
        this.calculateStandardMoves(x, y, role, grid, moveCells, takeCells, false);
        this.filterCheckMoves(moveCells, takeCells, attackPath, attackerPos);
        return Map.of(PieceAction.MOVE, moveCells, PieceAction.TAKE, takeCells);
    }

    public boolean isAbleToMove(int x, int y, int role, ChessGrid grid) {
        Map<PieceAction, List<Vector2i>> possibleMoves = this.getPossibleMoves(x, y, role, grid);
        for (PieceAction action : possibleMoves.keySet()) {
            if (possibleMoves.get((Object)action).isEmpty()) continue;
            return true;
        }
        return false;
    }

    private void filterCheckMoves(List<Vector2i> moveCells, List<Vector2i> takeCells, List<Vector2i> attackPath, Vector2i attackerPos) {
        moveCells.removeIf(cell -> !attackPath.contains(cell));
        takeCells.removeIf(cell -> !cell.equals((Object)attackerPos));
    }

    public static List<Vector2i> getAttackPath(Vector2i kingPos, Vector2i attackerPos, ChessPiece attacker, boolean includeEndCell) {
        ArrayList<Vector2i> path = new ArrayList<Vector2i>();
        if (attacker instanceof Bishop || attacker instanceof Queen) {
            ChessPiece.addDiagonalPath(kingPos, attackerPos, path, includeEndCell);
        }
        if (attacker instanceof Rook || attacker instanceof Queen) {
            ChessPiece.addStraightPath(kingPos, attackerPos, path, includeEndCell);
        }
        return path;
    }

    public static void addStraightPath(Vector2i start, Vector2i end, List<Vector2i> path, boolean includeEndCell) {
        int dx = Integer.compare(end.x - start.x, 0);
        int dy = Integer.compare(end.y - start.y, 0);
        if (dx == 0 || dy == 0) {
            Vector2i current = new Vector2i(start.x + dx, start.y + dy);
            while (!current.equals((Object)end)) {
                path.add(current);
                current = new Vector2i(current.x + dx, current.y + dy);
            }
        }
        if (includeEndCell && (dx == 0 || dy == 0) && Utils.isCellInSquare(end.x, end.y, path.isEmpty() ? start.x : path.getLast().x, path.isEmpty() ? start.y : path.getLast().y, 1)) {
            path.add(end);
        }
    }

    public static void addDiagonalPath(Vector2i start, Vector2i end, List<Vector2i> path, boolean includeEndCell) {
        int dx = Integer.compare(end.x - start.x, 0);
        int dy = Integer.compare(end.y - start.y, 0);
        if (Math.abs(end.x - start.x) == Math.abs(end.y - start.y)) {
            Vector2i current = new Vector2i(start.x + dx, start.y + dy);
            while (!current.equals(end.x, end.y)) {
                path.add(current);
                current = new Vector2i(current.x + dx, current.y + dy);
            }
        }
        if (includeEndCell && Math.abs(end.x - start.x) == Math.abs(end.y - start.y) && Utils.isCellInSquare(end.x, end.y, path.isEmpty() ? start.x : path.getLast().x, path.isEmpty() ? start.y : path.getLast().y, 1)) {
            path.add(end);
        }
    }

    public void updatePieceData(Vector2i fromCell, Vector2i toCell, PiecesData data) {
        data.clearData(fromCell.x, fromCell.y);
        data.clearData(toCell.x, toCell.y);
    }

    public Role getRole() {
        return this.role;
    }
}

