/*
 * Decompiled with CFR 0.152.
 */
package net.fieldb0y.wanna_play_chess.chess.utils;

import java.util.ArrayList;
import java.util.List;
import net.fieldb0y.wanna_play_chess.chess.ChessGrid;
import net.fieldb0y.wanna_play_chess.item.ModItems;
import net.fieldb0y.wanna_play_chess.item.custom.ChessPiece;

public enum ChessPieces {
    EMPTY(0, null),
    WHITE_PAWN(1, (ChessPiece)ModItems.WHITE_PAWN),
    WHITE_KNIGHT(2, (ChessPiece)ModItems.WHITE_KNIGHT),
    WHITE_BISHOP(3, (ChessPiece)ModItems.WHITE_BISHOP),
    WHITE_ROOK(4, (ChessPiece)ModItems.WHITE_ROOK),
    WHITE_QUEEN(5, (ChessPiece)ModItems.WHITE_QUEEN),
    WHITE_KING(6, (ChessPiece)ModItems.WHITE_KING),
    BLACK_PAWN(7, (ChessPiece)ModItems.BLACK_PAWN),
    BLACK_KNIGHT(8, (ChessPiece)ModItems.BLACK_KNIGHT),
    BLACK_BISHOP(9, (ChessPiece)ModItems.BLACK_BISHOP),
    BLACK_ROOK(10, (ChessPiece)ModItems.BLACK_ROOK),
    BLACK_QUEEN(11, (ChessPiece)ModItems.BLACK_QUEEN),
    BLACK_KING(12, (ChessPiece)ModItems.BLACK_KING);

    public final int id;
    public final ChessPiece item;

    private ChessPieces(int id, ChessPiece item) {
        this.id = id;
        this.item = item;
    }

    public static List<Integer> getAllIds() {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (ChessPieces piece : ChessPieces.values()) {
            if (piece == EMPTY) continue;
            ids.add(piece.id);
        }
        return ids;
    }

    public static List<Integer> getAllIdsExcept(List<Integer> exceptList) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (ChessPieces piece : ChessPieces.values()) {
            if (piece == EMPTY || exceptList.contains(piece.id)) continue;
            ids.add(piece.id);
        }
        return ids;
    }

    public static List<Integer> getAllIdsWithRoleExcept(int role, List<Integer> exceptList) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (ChessPieces piece : ChessPieces.values()) {
            if (piece == EMPTY || exceptList.contains(piece.id) || ChessGrid.getPieceRole(piece.id) != role) continue;
            ids.add(piece.id);
        }
        return ids;
    }

    public static Integer getId(ChessPiece piece) {
        for (ChessPieces pieceValue : ChessPieces.values()) {
            if (pieceValue.item != piece) continue;
            return pieceValue.id;
        }
        return -1;
    }
}

