/*
 * Decompiled with CFR 0.152.
 */
package net.fieldb0y.wanna_play_chess.chess.renderingStates;

import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fieldb0y.wanna_play_chess.CameraAnimationPlayable;
import net.fieldb0y.wanna_play_chess.chess.gameStates.ChessGameOverState;
import net.fieldb0y.wanna_play_chess.chess.gameStates.ChessState;
import net.fieldb0y.wanna_play_chess.chess.renderingStates.ChessRenderingState;
import net.fieldb0y.wanna_play_chess.chess.renderingStates.RenderingProperties;
import net.fieldb0y.wanna_play_chess.mixin.ScreenAccessor;
import net.fieldb0y.wanna_play_chess.network.c2sPayloads.BackToLobbyButtonPayload;
import net.fieldb0y.wanna_play_chess.screen.ChessBoardScreen;
import net.fieldb0y.wanna_play_chess.utils.Utils;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_8710;
import net.minecraft.class_9296;
import net.minecraft.class_9334;

public class ChessGameOverRenderingState
extends ChessRenderingState {
    public static final class_2561 BACK_TO_LOBBY_BUTTON_TEXT = class_2561.method_43471((String)"wanna_play_chess.game_over_rs.back_to_lobby");
    public static final class_2561 WHITE_WORD = class_2561.method_43471((String)"wanna_play_chess.game_over_rs.white_word");
    public static final class_2561 BLACK_WORD = class_2561.method_43471((String)"wanna_play_chess.game_over_rs.black");
    public static final class_2561 WON_WORD = class_2561.method_43471((String)"wanna_play_chess.game_over_rs.won_word");
    public static final class_2561 DRAW_TEXT = class_2561.method_43471((String)"wanna_play_chess.game_over_rs.draw_text");
    public static final class_2561 GAME_OVER_REASON_TEXT = class_2561.method_43471((String)"wanna_play_chess.game_over_rs.game_over_reason_text");
    private static final class_2960 CHESS_GAME_OVER_TEXTURE = class_2960.method_60655((String)"wanna_play_chess", (String)"textures/gui/chess_game_over.png");
    public class_1657 player;
    private class_4185 backToLobbyButton;
    private float whiteSkullScale = -1.0f;
    private float blackSkullScale = -1.0f;
    private float winnerSkullScale = 2.0f;
    private float looserSkullScale = 1.5f;

    public ChessGameOverRenderingState(ChessState serverState, ChessBoardScreen screen) {
        super(serverState, screen, new RenderingProperties(false, false));
        this.player = this.client.field_1724;
        this.focusCamera();
    }

    @Override
    public void createWidgets(ChessBoardScreen screen) {
        int centerX = this.getScreenWidth() / 2;
        int centerY = this.getScreenHeight() / 2;
        this.backToLobbyButton = class_4185.method_46430((class_2561)BACK_TO_LOBBY_BUTTON_TEXT, button -> ClientPlayNetworking.send((class_8710)new BackToLobbyButtonPayload(this.blockEntity.method_11016()))).method_46434(centerX - 39, centerY + 52, 80, 18).method_46431();
        ((ScreenAccessor)((Object)screen)).addWidget(this.backToLobbyButton);
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        ScreenAccessor accessor = (ScreenAccessor)((Object)this.screen);
        class_327 textRenderer = accessor.getTextRenderer();
        class_4587 matrices = context.method_51448();
        ChessGameOverState gameOverState = (ChessGameOverState)this.serverState;
        int centerX = this.getScreenWidth() / 2;
        int centerY = this.getScreenHeight() / 2;
        this.renderSkulls(context);
        matrices.method_22903();
        if (gameOverState.winnerRole == 0 || gameOverState.winnerRole == 1) {
            class_5250 text = class_2561.method_43470((String)(gameOverState.winnerRole == 0 ? WHITE_WORD.getString() : BLACK_WORD.getString())).method_27695(new class_124[]{gameOverState.winnerRole == 0 ? class_124.field_1068 : class_124.field_1063, class_124.field_1067}).method_27693(" ").method_10852((class_2561)WON_WORD.method_27661().method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}));
            int textWidth = textRenderer.method_27525((class_5348)text);
            float maxScale = Math.min(1.3f, 110.0f / (float)textWidth);
            matrices.method_22905(maxScale, maxScale, 1.0f);
            int x = (int)((float)centerX / maxScale - (float)textWidth / 2.0f);
            int y = (int)((float)(centerY - 53) / maxScale);
            context.method_51439(textRenderer, (class_2561)text, x, y, -8355712, true);
        } else {
            class_5250 text = DRAW_TEXT.method_27661().method_27695(new class_124[]{class_124.field_1075, class_124.field_1067});
            int textWidth = textRenderer.method_27525((class_5348)text);
            float maxScale = Math.min(1.3f, 110.0f / (float)textWidth);
            matrices.method_22905(maxScale, maxScale, 1.0f);
            int x = (int)((float)centerX / maxScale - (float)textWidth / 2.0f);
            int y = (int)((float)(centerY - 53) / maxScale);
            context.method_51439(textRenderer, (class_2561)text, x, y, -8355712, true);
        }
        matrices.method_22909();
        context.method_51439(textRenderer, (class_2561)GAME_OVER_REASON_TEXT.method_27661().method_27692(class_124.field_1073), centerX - 45, centerY + 10, -4539718, false);
        if (gameOverState.gameOverReason != null) {
            context.method_51439(textRenderer, (class_2561)gameOverState.gameOverReason.text.method_27661().method_27692(class_124.field_1056), centerX - textRenderer.method_27525((class_5348)gameOverState.gameOverReason.text) / 2, centerY + 25, -256, false);
        }
    }

    private void renderSkulls(class_332 context) {
        ChessGameOverState gameOverState = (ChessGameOverState)this.serverState;
        if (gameOverState.players[0] != null && gameOverState.players[1] != null) {
            class_1799 whitePlayerHead = new class_1799((class_1935)class_1802.field_8575);
            class_1799 blackPlayerHead = new class_1799((class_1935)class_1802.field_8575);
            class_1657 whitePlayer = this.blockEntity.method_10997().method_18470(gameOverState.players[0]);
            class_1657 blackPlayer = this.blockEntity.method_10997().method_18470(gameOverState.players[1]);
            if (whitePlayer != null) {
                whitePlayerHead.method_57379(class_9334.field_49617, (Object)new class_9296(whitePlayer.method_7334()));
            }
            if (blackPlayer != null) {
                blackPlayerHead.method_57379(class_9334.field_49617, (Object)new class_9296(blackPlayer.method_7334()));
            }
            if (gameOverState.winnerRole == 0) {
                if (this.whiteSkullScale == -1.0f) {
                    this.whiteSkullScale = this.looserSkullScale;
                }
                if (this.blackSkullScale == -1.0f) {
                    this.blackSkullScale = this.winnerSkullScale;
                }
                this.whiteSkullScale = class_3532.method_16439((float)0.02f, (float)this.whiteSkullScale, (float)this.winnerSkullScale);
                this.blackSkullScale = class_3532.method_16439((float)0.02f, (float)this.blackSkullScale, (float)this.looserSkullScale);
            } else if (gameOverState.winnerRole == 1) {
                if (this.whiteSkullScale == -1.0f) {
                    this.whiteSkullScale = this.winnerSkullScale;
                }
                if (this.blackSkullScale == -1.0f) {
                    this.blackSkullScale = this.looserSkullScale;
                }
                this.whiteSkullScale = class_3532.method_16439((float)0.02f, (float)this.whiteSkullScale, (float)this.looserSkullScale);
                this.blackSkullScale = class_3532.method_16439((float)0.02f, (float)this.blackSkullScale, (float)this.winnerSkullScale);
            } else {
                if (this.whiteSkullScale == -1.0f) {
                    this.whiteSkullScale = this.looserSkullScale;
                }
                if (this.blackSkullScale == -1.0f) {
                    this.blackSkullScale = this.looserSkullScale;
                }
                this.whiteSkullScale = class_3532.method_16439((float)0.02f, (float)this.whiteSkullScale, (float)this.winnerSkullScale);
                this.blackSkullScale = class_3532.method_16439((float)0.02f, (float)this.blackSkullScale, (float)this.winnerSkullScale);
            }
            Utils.renderScaledHead(context, whitePlayerHead, this.whiteSkullScale, this.getScreenWidth() / 2 - 40, this.getScreenHeight() / 2 - 25);
            Utils.renderScaledHead(context, blackPlayerHead, this.blackSkullScale, this.getScreenWidth() / 2 + 25, this.getScreenHeight() / 2 - 25);
        }
    }

    @Override
    public void drawBackground(class_332 context, float delta, int mouseX, int mouseY) {
        int centerX = this.getScreenWidth() / 2;
        int centerY = this.getScreenHeight() / 2;
        context.method_25290(CHESS_GAME_OVER_TEXTURE, centerX - 59, centerY - 59, 0.0f, 0.0f, 256, 256, 256, 256);
    }

    @Override
    public void afterSwitch() {
        this.backToLobbyButton.field_22764 = false;
        this.screen.renderingGameStates.get(0).createWidgets(this.screen);
    }

    private void focusCamera() {
        if (this.shouldRender()) {
            class_4184 camera = this.client.field_1773.method_19418();
            ((CameraAnimationPlayable)camera).focusOnBlockEntity(this.blockEntity, 0);
        }
    }
}

