/*
 * Decompiled with CFR 0.152.
 */
package net.fieldb0y.wanna_play_chess.chess;

import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fieldb0y.wanna_play_chess.chess.gameStates.ChessGameState;
import net.fieldb0y.wanna_play_chess.chess.renderingStates.ChessGameRenderingState;
import net.fieldb0y.wanna_play_chess.network.c2sPayloads.CellClickPayload;
import net.fieldb0y.wanna_play_chess.screen.ChessRenderingCell;
import net.fieldb0y.wanna_play_chess.utils.Utils;
import net.minecraft.class_332;
import net.minecraft.class_8710;
import org.joml.Vector2i;

public class Rendering2DBoard {
    private final Vector2i offset;
    public ChessGameRenderingState renderingState;
    public ChessRenderingCell[][] cells = new ChessRenderingCell[8][8];
    public boolean isActive;

    public Rendering2DBoard(ChessGameRenderingState renderingState) {
        this(new Vector2i(0, 0), false, renderingState);
    }

    public Rendering2DBoard(Vector2i offset, boolean isActive, ChessGameRenderingState renderingState) {
        this.offset = offset;
        this.renderingState = renderingState;
        this.isActive = isActive;
        for (int i = 0; i < this.cells.length; ++i) {
            for (int j = 0; j < this.cells.length; ++j) {
                this.cells[i][j] = new ChessRenderingCell((i + j) % 2 == 0 ? 0 : 1, i + offset.x, j + offset.y, 20, 20);
            }
        }
    }

    public void render(class_332 context) {
        if (this.isActive) {
            for (int i = 0; i < this.cells.length; ++i) {
                for (int j = 0; j < this.cells.length; ++j) {
                    int[][] gridData = ((ChessGameState)this.renderingState.getServerState()).getGrid().data;
                    int x = this.renderingState.getPlayerRole() == 0 ? i : 7 - i;
                    int y = this.renderingState.getPlayerRole() == 0 ? j : 7 - j;
                    this.cells[x][y].putPiece(gridData[i][j]);
                    this.cells[x][y].render(context);
                }
            }
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY) {
        if (this.isActive) {
            ChessRenderingCell clickedCell = this.getClickedCell(mouseX, mouseY);
            if (clickedCell == null) {
                return false;
            }
            int x = this.renderingState.getPlayerRole() == 0 ? clickedCell.x : clickedCell.getOppositeX();
            int y = this.renderingState.getPlayerRole() == 0 ? clickedCell.y : clickedCell.getOppositeY();
            ClientPlayNetworking.send((class_8710)new CellClickPayload(this.renderingState.blockEntity.method_11016(), x - this.offset.x, y - this.offset.y, this.renderingState.getPlayerRole()));
        }
        return true;
    }

    private ChessRenderingCell getClickedCell(double mouseX, double mouseY) {
        for (int i = 0; i < this.cells.length; ++i) {
            for (int j = 0; j < this.cells.length; ++j) {
                ChessRenderingCell cell = this.cells[i][j];
                if (!Utils.isMouseInBounds(cell.getRealX(), cell.getRealY(), cell.width, cell.height, mouseX, mouseY)) continue;
                return cell;
            }
        }
        return null;
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }
}

