/*
 * Decompiled with CFR 0.152.
 */
package net.fieldb0y.wanna_play_chess.block.entity.renderer;

import net.fieldb0y.wanna_play_chess.chess.ChessGrid;
import net.minecraft.class_2487;
import org.joml.Vector2i;

public class PieceAnimator {
    public ChessGrid grid;
    public boolean isAnimationPlaying = false;
    public Vector2i fromCell = new Vector2i(-1, -1);
    public Vector2i toCell = new Vector2i(-1, -1);
    private long animationStartTime;
    private static final long ANIMATION_DURATION = 100L;

    public PieceAnimator(ChessGrid grid) {
        this.grid = grid;
    }

    public void playAnimation(Vector2i fromCell, Vector2i toCell) {
        this.fromCell = fromCell;
        this.toCell = toCell;
        this.isAnimationPlaying = true;
        this.animationStartTime = System.currentTimeMillis();
    }

    public float getProgress() {
        if (!this.isAnimationPlaying) {
            return 1.0f;
        }
        long elapsed = System.currentTimeMillis() - this.animationStartTime;
        float progress = (float)elapsed / 100.0f;
        if (progress >= 1.0f) {
            this.stopAnimation();
            return 1.0f;
        }
        return progress;
    }

    public void stopAnimation() {
        this.isAnimationPlaying = false;
        this.grid.blockEntity.updateClient();
    }

    public void readNbt(class_2487 nbt) {
        this.isAnimationPlaying = nbt.method_10577("IsAnimPlaying");
        this.fromCell = new Vector2i(nbt.method_10561("FromCell"));
        this.toCell = new Vector2i(nbt.method_10561("ToCell"));
        if (this.isAnimationPlaying) {
            this.animationStartTime = System.currentTimeMillis();
        }
    }

    public void writeNbt(class_2487 nbt) {
        nbt.method_10556("IsAnimPlaying", this.isAnimationPlaying);
        nbt.method_10539("FromCell", new int[]{this.fromCell.x, this.fromCell.y});
        nbt.method_10539("ToCell", new int[]{this.toCell.x, this.toCell.y});
    }
}

