/*
 * Decompiled with CFR 0.152.
 */
package net.fieldb0y.wanna_play_chess.block.entity.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Map;
import net.fieldb0y.wanna_play_chess.block.custom.ChessBoardBlock;
import net.fieldb0y.wanna_play_chess.block.entity.ChessBoardBlockEntity;
import net.fieldb0y.wanna_play_chess.block.entity.model.ChessBoardModel;
import net.fieldb0y.wanna_play_chess.chess.ChessGrid;
import net.fieldb0y.wanna_play_chess.chess.PiecesData;
import net.fieldb0y.wanna_play_chess.chess.gameStates.ChessGameOverState;
import net.fieldb0y.wanna_play_chess.chess.gameStates.ChessGameState;
import net.fieldb0y.wanna_play_chess.chess.gameStates.ChessState;
import net.fieldb0y.wanna_play_chess.chess.utils.ChessPieces;
import net.fieldb0y.wanna_play_chess.chess.utils.PieceAction;
import net.fieldb0y.wanna_play_chess.item.custom.ChessPiece;
import net.fieldb0y.wanna_play_chess.layer.ModModelLayers;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import net.minecraft.class_918;
import org.joml.Matrix4f;
import org.joml.Vector2i;
import org.joml.Vector4i;

public class ChessBoardRenderer
implements class_827<ChessBoardBlockEntity> {
    private final class_5614.class_5615 context;
    private final ChessBoardModel model;

    public ChessBoardRenderer(class_5614.class_5615 context) {
        this.context = context;
        this.model = new ChessBoardModel(context.method_32140(ModModelLayers.CHESS_BOARD));
    }

    public void render(ChessBoardBlockEntity blockEntity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        this.renderBoardModel(blockEntity, matrices, vertexConsumers, light, overlay);
        this.renderPieces(blockEntity, matrices, vertexConsumers, light, overlay);
        this.renderPossibleMoves(blockEntity, matrices, vertexConsumers, light, overlay);
        if (blockEntity.currentState != null && blockEntity.currentState.equals(blockEntity.states.get(1))) {
            this.renderTakenPieces(blockEntity, matrices, vertexConsumers, light, overlay);
        }
    }

    private void renderPieces(ChessBoardBlockEntity blockEntity, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        class_918 itemRenderer = this.context.method_43335();
        class_1937 world = blockEntity.method_10997();
        ChessGrid grid = null;
        if (blockEntity.currentState.equals(blockEntity.states.get(0))) {
            return;
        }
        if (blockEntity.currentState.equals(blockEntity.states.get(1))) {
            grid = ((ChessGameState)blockEntity.currentState).getGrid();
        } else if (blockEntity.currentState.equals(blockEntity.states.get(2))) {
            grid = ((ChessGameOverState)blockEntity.currentState).getGrid();
        }
        int[][] gridData = grid.data;
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                int pieceId = gridData[i][j];
                if (pieceId == ChessPieces.EMPTY.id) continue;
                matrices.method_22903();
                matrices.method_46416(0.5f, 0.0f, 0.5f);
                switch (grid.getDirection()) {
                    case field_11034: {
                        matrices.method_22907(class_7833.field_40715.rotationDegrees(90.0f));
                        break;
                    }
                    case field_11035: {
                        matrices.method_22907(class_7833.field_40715.rotationDegrees(180.0f));
                        break;
                    }
                    case field_11039: {
                        matrices.method_22907(class_7833.field_40715.rotationDegrees(270.0f));
                        break;
                    }
                    default: {
                        matrices.method_22907(class_7833.field_40715.rotationDegrees(0.0f));
                    }
                }
                matrices.method_46416(-0.5f, 0.0f, -0.5f);
                ChessPiece pieceItem = ChessPieces.values()[pieceId].item;
                Vector2i currentCell = new Vector2i(i, j);
                if (grid.pieceAnimator.isAnimationPlaying && grid.pieceAnimator.toCell.equals((Object)currentCell)) {
                    pieceItem.renderMovingAnimation(grid.pieceAnimator, itemRenderer, matrices, vertexConsumers, world, light, overlay);
                } else {
                    pieceItem.render(itemRenderer, matrices, vertexConsumers, world, light, overlay, i, j);
                }
                matrices.method_22909();
            }
        }
    }

    private void renderTakenPieces(ChessBoardBlockEntity blockEntity, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        class_918 itemRenderer = this.context.method_43335();
        Map<Integer, List<Integer>> takenPieces = ((ChessGameState)blockEntity.currentState).getTakenPieces();
        for (int role = 0; role < 2; ++role) {
            List<Integer> piecesIds = takenPieces.get(role);
            if (piecesIds == null) {
                return;
            }
            for (int i = 0; i < piecesIds.size(); ++i) {
                int pieceId = piecesIds.get(i);
                ChessPiece piece = ChessGrid.getPieceById(pieceId);
                matrices.method_22903();
                matrices.method_46416(0.5f, 0.0f, 0.5f);
                switch (((ChessGameState)blockEntity.currentState).getGrid().getDirection()) {
                    case field_11034: {
                        matrices.method_22907(class_7833.field_40715.rotationDegrees(90.0f));
                        break;
                    }
                    case field_11035: {
                        matrices.method_22907(class_7833.field_40715.rotationDegrees(180.0f));
                        break;
                    }
                    case field_11039: {
                        matrices.method_22907(class_7833.field_40715.rotationDegrees(270.0f));
                        break;
                    }
                    default: {
                        matrices.method_22907(class_7833.field_40715.rotationDegrees(0.0f));
                    }
                }
                matrices.method_46416(-0.5f, 0.0f, -0.5f);
                matrices.method_22905(0.05f, 0.05f, 0.05f);
                matrices.method_46416((role == 0 ? 2.0f : 18.0f) + (float)i * (role == 0 ? 1.0f : -1.0f), 3.0f, role == 0 ? 18.0f : 2.0f);
                itemRenderer.method_23178(role == 0 ? piece.getBlackStack() : piece.getWhiteStack(), class_811.field_4315, light, overlay, matrices, vertexConsumers, blockEntity.method_10997(), 0);
                matrices.method_22909();
            }
        }
    }

    private void renderBoardModel(ChessBoardBlockEntity blockEntity, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        matrices.method_22903();
        matrices.method_46416(0.5f, 0.0f, 0.5f);
        matrices.method_22905(0.88f, 1.0f, 0.88f);
        if (blockEntity.currentState == null || blockEntity.currentState == blockEntity.states.get(0)) {
            this.rotateMatrixByDirection(matrices, (class_2350)blockEntity.method_11010().method_11654((class_2769)ChessBoardBlock.FACING), class_7833.field_40716);
        } else {
            ChessGrid chessGrid = blockEntity.currentState == blockEntity.states.get(1) ? ((ChessGameState)blockEntity.currentState).getGrid() : ((ChessGameOverState)blockEntity.currentState).getGrid();
            this.rotateMatrixByDirection(matrices, chessGrid.getDirection(), class_7833.field_40716);
        }
        this.model.method_60879(matrices, vertexConsumers.getBuffer(class_1921.method_23572((class_2960)ChessBoardModel.TEXTURE)), light, overlay);
        matrices.method_22909();
    }

    private void renderPossibleMoves(ChessBoardBlockEntity blockEntity, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        ChessState chessState = blockEntity.currentState;
        if (chessState instanceof ChessGameState) {
            ChessGameState state = (ChessGameState)chessState;
            Map<PieceAction, List<Vector2i>> possibleMoves = state.getPossibleMoves();
            if (!possibleMoves.isEmpty()) {
                this.renderSquareOnCell(state.currentChosenCell.x, state.currentChosenCell.y, new Vector4i(252, 186, 3, 141), state.getGrid(), matrices, vertexConsumers, light, overlay);
            }
            for (PieceAction action : possibleMoves.keySet()) {
                Vector4i color = action.getColor();
                for (Vector2i pos : possibleMoves.get((Object)action)) {
                    if (action == PieceAction.NONE || action == PieceAction.OTHER) continue;
                    this.renderSquareOnCell(pos.x, pos.y, color, state.getGrid(), matrices, vertexConsumers, light, overlay);
                }
            }
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < 8; ++j) {
                    int pieceId = state.getGrid().safeGetPieceId(i, j);
                    if (pieceId != ChessPieces.WHITE_KING.id && pieceId != ChessPieces.BLACK_KING.id || !state.piecesData.hasDataTag(i, j, PiecesData.DataTag.CHECKED)) continue;
                    this.renderSquareOnCell(i, j, PieceAction.TAKE.getColor(), state.getGrid(), matrices, vertexConsumers, light, overlay);
                }
            }
        } else {
            chessState = blockEntity.currentState;
            if (chessState instanceof ChessGameOverState) {
                ChessGameOverState state = (ChessGameOverState)chessState;
                if (!state.matedKingCell.equals(-1, -1)) {
                    this.renderSquareOnCell(state.matedKingCell.x, state.matedKingCell.y, PieceAction.TAKE.getColor(), state.getGrid(), matrices, vertexConsumers, light, overlay);
                }
            }
        }
    }

    private void renderSquareOnCell(int x, int y, Vector4i rgba, ChessGrid grid, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        matrices.method_22903();
        matrices.method_22904(0.21, 0.0, 0.21);
        Matrix4f matrix = matrices.method_23760().method_23761();
        class_4588 consumer = vertexConsumers.getBuffer(class_1921.method_23580((class_2960)ChessBoardModel.TEXTURE));
        float size = 0.0415f;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        switch (grid.getDirection()) {
            case field_11034: {
                matrices.method_22904(0.58, 0.0, 0.0);
                matrices.method_22907(class_7833.field_40715.rotationDegrees(90.0f));
                break;
            }
            case field_11035: {
                matrices.method_46416(0.58f, 0.0f, 0.58f);
                matrices.method_22907(class_7833.field_40715.rotationDegrees(180.0f));
                break;
            }
            case field_11039: {
                matrices.method_46416(0.0f, 0.0f, 0.58f);
                matrices.method_22907(class_7833.field_40715.rotationDegrees(270.0f));
                break;
            }
            default: {
                matrices.method_22907(class_7833.field_40715.rotationDegrees(0.0f));
            }
        }
        consumer.method_22918(matrix, (float)x * size * 2.0f - size, 0.1251f, (float)y * size * 2.0f - size).method_1336(rgba.x, rgba.y, rgba.z, rgba.w).method_22913(0.0f, 0.0f).method_22922(overlay).method_60803(light).method_22914(0.0f, 1.0f, 0.0f);
        consumer.method_22918(matrix, (float)x * size * 2.0f - size, 0.1251f, (float)y * size * 2.0f + size).method_1336(rgba.x, rgba.y, rgba.z, rgba.w).method_22913(0.0f, 0.0234375f).method_22922(overlay).method_60803(light).method_22914(0.0f, 1.0f, 0.0f);
        consumer.method_22918(matrix, (float)x * size * 2.0f + size, 0.1251f, (float)y * size * 2.0f + size).method_1336(rgba.x, rgba.y, rgba.z, rgba.w).method_22913(0.0234375f, 0.0234375f).method_22922(overlay).method_60803(light).method_22914(0.0f, 1.0f, 0.0f);
        consumer.method_22918(matrix, (float)x * size * 2.0f + size, 0.1251f, (float)y * size * 2.0f - size).method_1336(rgba.x, rgba.y, rgba.z, rgba.w).method_22913(0.0234375f, 0.0f).method_22922(overlay).method_60803(light).method_22914(0.0f, 1.0f, 0.0f);
        matrices.method_22909();
        RenderSystem.disableBlend();
    }

    private void rotateMatrixByDirection(class_4587 matrices, class_2350 direction, class_7833 rotationAxis) {
        switch (direction) {
            case field_11034: {
                matrices.method_22907(rotationAxis.rotationDegrees(270.0f));
                break;
            }
            case field_11035: {
                matrices.method_22907(rotationAxis.rotationDegrees(180.0f));
                break;
            }
            case field_11039: {
                matrices.method_22907(rotationAxis.rotationDegrees(90.0f));
                break;
            }
            default: {
                matrices.method_22907(rotationAxis.rotationDegrees(0.0f));
            }
        }
    }
}

