/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.server.serializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import dev.kosmx.playerAnim.core.util.Pair;
import io.github.kosmx.emotes.common.tools.BiMap;
import java.lang.reflect.Type;
import java.util.UUID;

public class BiMapSerializer
implements JsonSerializer<BiMap<UUID, UUID>>,
JsonDeserializer<BiMap<UUID, UUID>> {
    public JsonElement serialize(BiMap<UUID, UUID> src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("bedrock-emote", "java-emote");
        for (Pair<UUID, UUID> pair : src) {
            jsonObject.addProperty(((UUID)pair.getLeft()).toString(), ((UUID)pair.getRight()).toString());
        }
        return jsonObject;
    }

    public BiMap<UUID, UUID> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        BiMap<UUID, UUID> map = new BiMap<UUID, UUID>();
        json.getAsJsonObject().entrySet().forEach(entry -> {
            if (((String)entry.getKey()).equals("bedrock-emote")) {
                return;
            }
            try {
                map.put(UUID.fromString((String)entry.getKey()), UUID.fromString(((JsonElement)entry.getValue()).getAsString()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        });
        return map;
    }
}

