/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_paintings.network.payload.c2s;

import java.awt.image.BufferedImage;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.EnumSet;
import net.conczin.immersive_paintings.Main;
import net.conczin.immersive_paintings.Painting;
import net.conczin.immersive_paintings.ServerPaintingManager;
import net.conczin.immersive_paintings.network.NetworkHandler;
import net.conczin.immersive_paintings.network.payload.ImmersivePayload;
import net.conczin.immersive_paintings.network.payload.c2s.ImageUploadPayload;
import net.conczin.immersive_paintings.network.payload.s2c.PaintingRegisterErrorPayload;
import net.conczin.immersive_paintings.network.payload.s2c.PaintingSyncPayload;
import net.conczin.immersive_paintings.registration.Configs;
import net.conczin.immersive_paintings.util.ImageManipulations;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record PaintingRegisterPayload(int width, int height, int resolution, String name, EnumSet<Painting.Flag> flags) implements ImmersivePayload
{
    public static final class_8710.class_9154<PaintingRegisterPayload> TYPE = new class_8710.class_9154(Main.locate("painting_register"));
    public static final class_9139<class_2540, PaintingRegisterPayload> STREAM_CODEC = class_9139.method_56906((class_9139)class_9135.field_49675, PaintingRegisterPayload::width, (class_9139)class_9135.field_49675, PaintingRegisterPayload::height, (class_9139)class_9135.field_49675, PaintingRegisterPayload::resolution, (class_9139)class_9135.field_48554, PaintingRegisterPayload::name, Painting.Flag.STREAM_CODEC, PaintingRegisterPayload::flags, PaintingRegisterPayload::new);

    private static void paintingRegisterError(class_1657 player, String error, class_2960 i) {
        NetworkHandler.sendToClient((class_3222)player, new PaintingRegisterErrorPayload(i, error));
    }

    public static class_2960 handle(class_1657 player, BufferedImage image, Painting painting) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            String hash = String.format("%032x", new BigInteger(1, md5.digest(ImageManipulations.encode(image))));
            painting = painting.withHash(hash);
            class_2960 identifier = painting.location();
            ServerPaintingManager.registerPainting(player.method_5682(), identifier, painting, image);
            NetworkHandler.sendToAllClients(player.method_5682(), new PaintingSyncPayload(identifier, painting));
            PaintingRegisterPayload.paintingRegisterError(player, "", identifier);
            return identifier;
        }
        catch (NoSuchAlgorithmException e) {
            Main.LOGGER.error("failed to hash painting {}", (Object)painting.location(), (Object)e);
            PaintingRegisterPayload.paintingRegisterError(player, "hash_failed", painting.location());
            return null;
        }
    }

    @Override
    public void handle(class_1657 player, ImmersivePayload.Runner runner) {
        int width = this.width();
        int height = this.height();
        int resolution = this.resolution();
        String name = this.name();
        EnumSet<Painting.Flag> flags = this.flags();
        runner.run(() -> {
            BufferedImage image = ImageUploadPayload.uploaded.remove(player.method_5845());
            if (!player.method_5687(Configs.COMMON.uploadPermissionLevel)) {
                PaintingRegisterPayload.paintingRegisterError(player, "no_permission", null);
                return;
            }
            if (image.getWidth() > Configs.COMMON.maxUserImageWidth || image.getHeight() > Configs.COMMON.maxUserImageHeight) {
                PaintingRegisterPayload.paintingRegisterError(player, "too_large", null);
                return;
            }
            long count = ServerPaintingManager.getCustomPaintings(player.method_5682()).values().stream().filter(p -> p.authorUUID().equals(player.method_5667())).count();
            if (count > (long)Configs.COMMON.maxUserImages) {
                PaintingRegisterPayload.paintingRegisterError(player, "limit_reached", null);
                return;
            }
            Painting p2 = new Painting(width, height, resolution, name, player.method_7334().getName(), player.method_5667(), Painting.Type.PAINTING, flags, "");
            PaintingRegisterPayload.handle(player, image, p2);
        });
    }

    public class_8710.class_9154<PaintingRegisterPayload> method_56479() {
        return TYPE;
    }
}

