/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_paintings.network.payload.c2s;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.conczin.immersive_paintings.Main;
import net.conczin.immersive_paintings.Painting;
import net.conczin.immersive_paintings.ServerPaintingManager;
import net.conczin.immersive_paintings.network.NetworkHandler;
import net.conczin.immersive_paintings.network.payload.ImmersivePayload;
import net.conczin.immersive_paintings.network.payload.s2c.PaintingSyncPayload;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;

public record PaintingDeletePayload(class_2960 identifier, boolean adminDelete) implements ImmersivePayload
{
    public static final class_8710.class_9154<PaintingDeletePayload> TYPE = new class_8710.class_9154(Main.locate("painting_delete"));
    public static final class_9139<class_2540, PaintingDeletePayload> STREAM_CODEC = class_9139.method_56435((class_9139)class_2960.field_48267, PaintingDeletePayload::identifier, (class_9139)class_9135.field_48547, PaintingDeletePayload::adminDelete, PaintingDeletePayload::new);

    private static void deletePainting(MinecraftServer server, class_1657 player, class_2960 painting) {
        ServerPaintingManager.deregisterPainting(server, painting);
        Main.LOGGER.info("Player {} deleted painting {}", (Object)player, (Object)painting);
    }

    @Override
    public void handle(class_1657 player, ImmersivePayload.Runner runner) {
        class_2960 identifier = this.identifier();
        boolean adminDelete = this.adminDelete();
        runner.run(() -> {
            PaintingSyncPayload payload;
            Painting painting = ServerPaintingManager.getCustomPaintings(player.method_5682()).get(identifier);
            UUID authorUUID = painting.authorUUID();
            if (!authorUUID.equals(player.method_5667()) && !player.method_5687(4)) {
                Main.LOGGER.warn("Player {} tried to delete painting {}, which they do not own", (Object)player, (Object)identifier);
                return;
            }
            MinecraftServer server = player.method_5682();
            if (adminDelete) {
                Map<class_2960, Optional<Painting>> deletedPaintings = ServerPaintingManager.getCustomPaintings(server).entrySet().stream().filter(p -> ((Painting)p.getValue()).authorUUID().equals(authorUUID) && !((Painting)p.getValue()).is(Painting.Type.DATAPACK)).collect(Collectors.toMap(Map.Entry::getKey, e -> Optional.empty()));
                deletedPaintings.forEach((id, o) -> PaintingDeletePayload.deletePainting(server, player, id));
                payload = new PaintingSyncPayload(deletedPaintings, false);
            } else {
                PaintingDeletePayload.deletePainting(server, player, identifier);
                payload = new PaintingSyncPayload(identifier, null);
            }
            NetworkHandler.sendToAllClients(server, payload);
        });
    }

    public class_8710.class_9154<PaintingDeletePayload> method_56479() {
        return TYPE;
    }
}

