/*
 * Decompiled with CFR 0.152.
 */
package org.redlance.dima_dencep.mods.online_emotes.network;

import io.github.kosmx.emotes.api.proxy.AbstractNetworkInstance;
import io.github.kosmx.emotes.common.network.EmotePacket;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.util.concurrent.ScheduledFuture;
import java.io.IOException;
import java.net.URI;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.redlance.dima_dencep.mods.online_emotes.OnlineEmotes;
import org.redlance.dima_dencep.mods.online_emotes.OnlineEmotesConfig;
import org.redlance.dima_dencep.mods.online_emotes.client.FancyToast;
import org.redlance.dima_dencep.mods.online_emotes.netty.HandshakeHandler;
import org.redlance.dima_dencep.mods.online_emotes.netty.WebsocketHandler;
import org.redlance.dima_dencep.mods.online_emotes.utils.EmotePacketWrapper;
import org.redlance.dima_dencep.mods.online_emotes.utils.NettyObjectFactory;

@ChannelHandler.Sharable
public class OnlineNetworkInstance
extends AbstractNetworkInstance {
    private static final URI URI_ADDRESS = URI.create("wss://api.redlance.org:443/websockets/online-emotes");
    public static final int PAYLOAD_LENGHT = Integer.MAX_VALUE;
    public final Bootstrap bootstrap = new Bootstrap();
    private ScheduledFuture<?> reconnectingFuture;
    public HandshakeHandler handshakeHandler;
    public Channel ch;

    public OnlineNetworkInstance() {
        this.bootstrap.group(NettyObjectFactory.newEventLoopGroup());
        this.bootstrap.channel(NettyObjectFactory.getSocketChannel());
        this.bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(@NotNull SocketChannel ch) throws SSLException {
                ChannelPipeline pipeline = ch.pipeline();
                if ("wss".equals(URI_ADDRESS.getScheme())) {
                    pipeline.addLast(new ChannelHandler[]{SslContextBuilder.forClient().build().newHandler(ch.alloc(), URI_ADDRESS.getHost(), URI_ADDRESS.getPort())});
                }
                pipeline.addLast("http-codec", (ChannelHandler)new HttpClientCodec());
                pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(Integer.MAX_VALUE));
                pipeline.addLast("handshaker", (ChannelHandler)OnlineNetworkInstance.this.handshakeHandler);
                pipeline.addLast("ws-handler", (ChannelHandler)new WebsocketHandler(OnlineNetworkInstance.this));
            }
        });
    }

    public void connect() {
        if (this.isActive()) {
            this.sendOnlineEmotesConfig();
            return;
        }
        this.stopReconnecting();
        this.reconnectingFuture = this.bootstrap.config().group().scheduleAtFixedRate(() -> {
            if (!this.isActive()) {
                OnlineEmotes.LOGGER.info("Try (re)connecting...");
                this.connectInternal();
            }
        }, 0L, OnlineEmotesConfig.reconnectionDelay(), TimeUnit.SECONDS);
    }

    private void connectInternal() {
        this.handshakeHandler = new HandshakeHandler(WebSocketClientHandshakerFactory.newHandshaker((URI)URI_ADDRESS, (WebSocketVersion)WebSocketVersion.V13, null, (boolean)true, (HttpHeaders)EmptyHttpHeaders.INSTANCE, (int)Integer.MAX_VALUE));
        ChannelFuture channelFuture = this.bootstrap.connect(URI_ADDRESS.getHost(), URI_ADDRESS.getPort());
        channelFuture.addListener(l -> {
            if (l.isSuccess()) {
                this.disconnectNetty();
                this.ch = channelFuture.channel();
                this.handshakeHandler.handshakeFuture.addListener(e -> {
                    if (e.isSuccess()) {
                        this.sendOnlineEmotesConfig();
                    } else {
                        OnlineEmotes.LOGGER.error("Failed to connect!", e.cause());
                    }
                });
            } else {
                OnlineEmotes.LOGGER.error("Failed to connect!", l.cause());
            }
        });
    }

    public boolean sendPlayerID() {
        return true;
    }

    public void sendOnlineEmotesConfig() {
        this.sendC2SConfig(builder -> {
            try {
                this.sendMessage((EmotePacket.Builder)builder, null);
            }
            catch (IOException e) {
                OnlineEmotes.LOGGER.fatal("Failed to send message!", (Throwable)e);
            }
        });
    }

    public boolean isActive() {
        return this.ch != null && this.ch.isActive() && this.handshakeHandler != null && this.handshakeHandler.isSuccess();
    }

    public void sendMessage(EmotePacket.Builder builder, @Nullable UUID target) throws IOException {
        if (!this.isActive()) {
            OnlineEmotes.LOGGER.error("Can't send packet to an inactive channel!");
            return;
        }
        if (target != null) {
            builder.configureTarget(target);
        }
        EmotePacket writer = builder.setSizeLimit(Integer.MAX_VALUE).build();
        this.ch.writeAndFlush((Object)new EmotePacketWrapper(writer.write().array()).toWebSocketFrame(), this.ch.voidPromise());
        if (writer.data.emoteData != null && writer.data.emoteData.extraData.containsKey("song") && !writer.data.writeSong) {
            FancyToast.sendMessage((class_2561)class_2561.method_43471((String)"emotecraft.song_too_big_to_send"));
        }
    }

    protected void disconnectNetty() {
        if (this.isActive()) {
            this.ch.writeAndFlush((Object)new CloseWebSocketFrame(), this.ch.voidPromise());
            try {
                this.ch.close().awaitUninterruptibly();
            }
            catch (Throwable th) {
                OnlineEmotes.LOGGER.error("Failed to disconnect WebSocket!", th);
            }
            this.ch = null;
        }
    }

    public void disconnect() {
        this.stopReconnecting();
        this.disconnectNetty();
        super.disconnect();
    }

    private void stopReconnecting() {
        try {
            if (this.reconnectingFuture != null && !this.reconnectingFuture.isCancelled()) {
                OnlineEmotes.LOGGER.warn("What happened to the reconnector?");
                this.reconnectingFuture.cancel(true);
                this.reconnectingFuture = null;
            }
        }
        catch (Throwable th) {
            OnlineEmotes.LOGGER.error("Failed to stop reconnector:", th);
        }
    }

    public boolean isReconnectorAlive() {
        return this.reconnectingFuture != null;
    }
}

