/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.tile;

import net.mehvahdjukaar.amendments.Amendments;
import net.mehvahdjukaar.amendments.common.PendulumAnimation;
import net.mehvahdjukaar.amendments.common.SwingAnimation;
import net.mehvahdjukaar.amendments.configs.ClientConfigs;
import net.mehvahdjukaar.amendments.reg.ModBlockProperties;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_7225;
import net.minecraft.class_7713;
import net.minecraft.class_7715;
import net.minecraft.class_7718;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class HangingSignTileExtension {
    @Nullable
    private ModBlockProperties.PostType leftAttachment = null;
    @Nullable
    private ModBlockProperties.PostType rightAttachment = null;
    private final boolean isCeiling;
    private boolean canSwing = true;
    private SwingAnimation animation;
    private class_1799 frontItem = class_1799.field_8037;
    private class_1799 backItem = class_1799.field_8037;

    public HangingSignTileExtension(class_2680 state) {
        this.isCeiling = state.method_26204() instanceof class_7713;
    }

    public void clientTick(class_1937 level, class_2338 pos, class_2680 state) {
        SwingAnimation animation = this.getClientAnimation();
        if (!this.canSwing) {
            animation.reset();
        } else {
            animation.tick(level, pos, state);
        }
    }

    private Vector3f getRotationAxis(class_2680 state) {
        return state.method_28498((class_2769)class_7715.field_40319) ? ((class_2350)state.method_11654((class_2769)class_7715.field_40319)).method_10170().method_23955() : new Vector3f(0.0f, 0.0f, 1.0f).rotateY((float)Math.PI / 180 * (90.0f + class_7718.method_45482((int)((Integer)state.method_11654((class_2769)class_7713.field_40300)))));
    }

    public ModBlockProperties.PostType getRightAttachment() {
        return this.rightAttachment;
    }

    public ModBlockProperties.PostType getLeftAttachment() {
        return this.leftAttachment;
    }

    public void saveAdditional(class_2487 tag, class_7225.class_7874 registries) {
        if (!this.isCeiling) {
            if (this.leftAttachment != null) {
                tag.method_10567("left_attachment", (byte)this.leftAttachment.ordinal());
            }
            if (this.rightAttachment != null) {
                tag.method_10567("right_attachment", (byte)this.rightAttachment.ordinal());
            }
        }
        if (!this.canSwing) {
            tag.method_10556("can_swing", false);
        }
        if (!this.frontItem.method_7960()) {
            tag.method_10566("front_item", this.frontItem.method_57358(registries));
        }
        if (!this.backItem.method_7960()) {
            tag.method_10566("back_item", this.backItem.method_57358(registries));
        }
    }

    public void load(class_2487 tag, class_7225.class_7874 registries) {
        if (!this.isCeiling) {
            if (tag.method_10545("left_attachment")) {
                this.leftAttachment = ModBlockProperties.PostType.values()[tag.method_10571("left_attachment")];
            }
            if (tag.method_10545("right_attachment")) {
                this.rightAttachment = ModBlockProperties.PostType.values()[tag.method_10571("right_attachment")];
            }
        }
        this.canSwing = tag.method_10545("can_swing") ? tag.method_10577("can_swing") : true;
        if (tag.method_10545("front_item")) {
            this.setFrontItem(class_1799.method_57359((class_7225.class_7874)registries, (class_2487)tag.method_10562("front_item")));
        } else {
            this.setFrontItem(class_1799.field_8037);
        }
        if (tag.method_10545("back_item")) {
            this.setBackItem(class_1799.method_57359((class_7225.class_7874)registries, (class_2487)tag.method_10562("back_item")));
        } else {
            this.setBackItem(class_1799.field_8037);
        }
    }

    public void updateShape(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 level, class_2338 pos, class_2338 neighborPos) {
        if (!this.isCeiling) {
            class_2350 selfFacing = (class_2350)state.method_11654((class_2769)class_7715.field_40319);
            if (direction == selfFacing.method_10170()) {
                this.rightAttachment = ModBlockProperties.PostType.get(neighborState, true);
                if (level instanceof class_1937) {
                    class_1937 l = (class_1937)level;
                    l.method_8413(pos, state, state, 2);
                }
            } else if (direction == selfFacing.method_10160()) {
                this.leftAttachment = ModBlockProperties.PostType.get(neighborState, true);
                if (level instanceof class_1937) {
                    class_1937 l = (class_1937)level;
                    l.method_8413(pos, state, state, 2);
                }
            }
        }
        if (direction == class_2350.field_11033) {
            this.updateCanSwing(state, neighborState, level, pos);
        }
    }

    private void updateCanSwing(class_2680 state, class_2680 neighborState, class_1936 level, class_2338 pos) {
        this.canSwing = this.isCeiling ? !((Boolean)state.method_11654((class_2769)class_7713.field_40301)).booleanValue() : !Amendments.canConnectDown(neighborState, level, pos);
    }

    public void updateAttachments(class_1937 level, class_2338 pos, class_2680 state) {
        if (!this.isCeiling) {
            class_2350 selfFacing = (class_2350)state.method_11654((class_2769)class_7715.field_40319);
            this.rightAttachment = ModBlockProperties.PostType.get(level.method_8320(pos.method_10093(selfFacing.method_10170())), true);
            this.leftAttachment = ModBlockProperties.PostType.get(level.method_8320(pos.method_10093(selfFacing.method_10160())), true);
        }
        class_2680 below = level.method_8320(pos.method_10074());
        this.updateCanSwing(state, below, (class_1936)level, pos);
    }

    public boolean canSwing() {
        return this.canSwing;
    }

    public void setFrontItem(class_1799 frontItem) {
        this.frontItem = frontItem;
    }

    public class_1799 getFrontItem() {
        return this.frontItem;
    }

    public void setBackItem(class_1799 backItem) {
        this.backItem = backItem;
    }

    public class_1799 getBackItem() {
        return this.backItem;
    }

    public SwingAnimation getClientAnimation() {
        if (!ClientConfigs.SWINGING_SIGNS.get().booleanValue()) {
            return SwingAnimation.EMPTY;
        }
        if (this.animation == null) {
            this.animation = new PendulumAnimation(ClientConfigs.HANGING_SIGN_CONFIG, this::getRotationAxis);
        }
        return this.animation;
    }
}

