/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import org.luaj.vm2.LocVars;
import org.luaj.vm2.Lua;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaInteger;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Prototype;
import org.luaj.vm2.compiler.Constants;
import org.luaj.vm2.compiler.FuncState;
import org.luaj.vm2.compiler.InstructionPtr;
import org.luaj.vm2.compiler.IntPtr;
import org.luaj.vm2.compiler.LuaC;
import org.luaj.vm2.lib.MathLib;

public class LexState
extends Constants {
    protected static final String RESERVED_LOCAL_VAR_FOR_CONTROL = "(for control)";
    protected static final String RESERVED_LOCAL_VAR_FOR_STATE = "(for state)";
    protected static final String RESERVED_LOCAL_VAR_FOR_GENERATOR = "(for generator)";
    protected static final String RESERVED_LOCAL_VAR_FOR_STEP = "(for step)";
    protected static final String RESERVED_LOCAL_VAR_FOR_LIMIT = "(for limit)";
    protected static final String RESERVED_LOCAL_VAR_FOR_INDEX = "(for index)";
    protected static final String[] RESERVED_LOCAL_VAR_KEYWORDS = new String[]{"(for control)", "(for generator)", "(for index)", "(for limit)", "(for state)", "(for step)"};
    private static final Hashtable RESERVED_LOCAL_VAR_KEYWORDS_TABLE = new Hashtable();
    private static final int EOZ = -1;
    private static final int MAX_INT = 0x7FFFFFFD;
    private static final int UCHAR_MAX = 255;
    private static final int LUAI_MAXCCALLS = 200;
    private static final int LUA_COMPAT_LSTR = 1;
    private static final boolean LUA_COMPAT_VARARG = true;
    static final int NO_JUMP = -1;
    static final int OPR_ADD = 0;
    static final int OPR_SUB = 1;
    static final int OPR_MUL = 2;
    static final int OPR_DIV = 3;
    static final int OPR_MOD = 4;
    static final int OPR_POW = 5;
    static final int OPR_CONCAT = 6;
    static final int OPR_NE = 7;
    static final int OPR_EQ = 8;
    static final int OPR_LT = 9;
    static final int OPR_LE = 10;
    static final int OPR_GT = 11;
    static final int OPR_GE = 12;
    static final int OPR_AND = 13;
    static final int OPR_OR = 14;
    static final int OPR_NOBINOPR = 15;
    static final int OPR_MINUS = 0;
    static final int OPR_NOT = 1;
    static final int OPR_LEN = 2;
    static final int OPR_NOUNOPR = 3;
    static final int VVOID = 0;
    static final int VNIL = 1;
    static final int VTRUE = 2;
    static final int VFALSE = 3;
    static final int VK = 4;
    static final int VKNUM = 5;
    static final int VNONRELOC = 6;
    static final int VLOCAL = 7;
    static final int VUPVAL = 8;
    static final int VINDEXED = 9;
    static final int VJMP = 10;
    static final int VRELOCABLE = 11;
    static final int VCALL = 12;
    static final int VVARARG = 13;
    int current;
    int linenumber;
    int lastline;
    final Token t = new Token();
    final Token lookahead = new Token();
    FuncState fs;
    LuaC.CompileState L;
    InputStream z;
    char[] buff;
    int nbuff;
    Dyndata dyd = new Dyndata();
    LuaString source;
    LuaString envn;
    byte decpoint;
    static final String[] luaX_tokens;
    static final int TK_AND = 257;
    static final int TK_BREAK = 258;
    static final int TK_DO = 259;
    static final int TK_ELSE = 260;
    static final int TK_ELSEIF = 261;
    static final int TK_END = 262;
    static final int TK_FALSE = 263;
    static final int TK_FOR = 264;
    static final int TK_FUNCTION = 265;
    static final int TK_GOTO = 266;
    static final int TK_IF = 267;
    static final int TK_IN = 268;
    static final int TK_LOCAL = 269;
    static final int TK_NIL = 270;
    static final int TK_NOT = 271;
    static final int TK_OR = 272;
    static final int TK_REPEAT = 273;
    static final int TK_RETURN = 274;
    static final int TK_THEN = 275;
    static final int TK_TRUE = 276;
    static final int TK_UNTIL = 277;
    static final int TK_WHILE = 278;
    static final int TK_CONCAT = 279;
    static final int TK_DOTS = 280;
    static final int TK_EQ = 281;
    static final int TK_GE = 282;
    static final int TK_LE = 283;
    static final int TK_NE = 284;
    static final int TK_DBCOLON = 285;
    static final int TK_EOS = 286;
    static final int TK_NUMBER = 287;
    static final int TK_NAME = 288;
    static final int TK_STRING = 289;
    static final int FIRST_RESERVED = 257;
    static final int NUM_RESERVED = 22;
    static final Hashtable RESERVED;
    static Priority[] priority;
    static final int UNARY_PRIORITY = 8;

    private static final String LUA_QS(String s2) {
        return "'" + s2 + "'";
    }

    private static final String LUA_QL(Object o) {
        return LexState.LUA_QS(String.valueOf(o));
    }

    public static boolean isReservedKeyword(String varName) {
        return RESERVED_LOCAL_VAR_KEYWORDS_TABLE.containsKey(varName);
    }

    private boolean isalnum(int c) {
        return c >= 48 && c <= 57 || c >= 97 && c <= 122 || c >= 65 && c <= 90 || c == 95;
    }

    private boolean isalpha(int c) {
        return c >= 97 && c <= 122 || c >= 65 && c <= 90;
    }

    private boolean isdigit(int c) {
        return c >= 48 && c <= 57;
    }

    private boolean isxdigit(int c) {
        return c >= 48 && c <= 57 || c >= 97 && c <= 102 || c >= 65 && c <= 70;
    }

    private boolean isspace(int c) {
        return c >= 0 && c <= 32;
    }

    public LexState(LuaC.CompileState state, InputStream stream) {
        this.z = stream;
        this.buff = new char[32];
        this.L = state;
    }

    void nextChar() {
        try {
            this.current = this.z.read();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.current = -1;
        }
    }

    boolean currIsNewline() {
        return this.current == 10 || this.current == 13;
    }

    void save_and_next() {
        this.save(this.current);
        this.nextChar();
    }

    void save(int c) {
        if (this.buff == null || this.nbuff + 1 > this.buff.length) {
            this.buff = LexState.realloc(this.buff, this.nbuff * 2 + 1);
        }
        this.buff[this.nbuff++] = (char)c;
    }

    String token2str(int token) {
        if (token < 257) {
            return LexState.iscntrl(token) ? this.L.pushfstring("char(" + token + ")") : this.L.pushfstring(String.valueOf((char)token));
        }
        return luaX_tokens[token - 257];
    }

    private static boolean iscntrl(int token) {
        return token < 32;
    }

    String txtToken(int token) {
        switch (token) {
            case 287: 
            case 288: 
            case 289: {
                return new String(this.buff, 0, this.nbuff);
            }
        }
        return this.token2str(token);
    }

    void lexerror(String msg, int token) {
        String cid = Lua.chunkid(this.source.tojstring());
        this.L.pushfstring(cid + ":" + this.linenumber + ": " + msg);
        if (token != 0) {
            this.L.pushfstring("syntax error: " + msg + " near " + this.txtToken(token));
        }
        throw new LuaError(cid + ":" + this.linenumber + ": " + msg);
    }

    void syntaxerror(String msg) {
        this.lexerror(msg, this.t.token);
    }

    LuaString newstring(String s2) {
        return this.L.newTString(s2);
    }

    LuaString newstring(char[] chars, int offset, int len) {
        return this.L.newTString(new String(chars, offset, len));
    }

    void inclinenumber() {
        int old = this.current;
        LexState._assert(this.currIsNewline());
        this.nextChar();
        if (this.currIsNewline() && this.current != old) {
            this.nextChar();
        }
        if (++this.linenumber >= 0x7FFFFFFD) {
            this.syntaxerror("chunk has too many lines");
        }
    }

    void setinput(LuaC.CompileState L, int firstByte, InputStream z, LuaString source) {
        this.decpoint = (byte)46;
        this.L = L;
        this.lookahead.token = 286;
        this.z = z;
        this.fs = null;
        this.linenumber = 1;
        this.lastline = 1;
        this.source = source;
        this.envn = LuaValue.ENV;
        this.nbuff = 0;
        this.current = firstByte;
        this.skipShebang();
    }

    private void skipShebang() {
        if (this.current == 35) {
            while (!this.currIsNewline() && this.current != -1) {
                this.nextChar();
            }
        }
    }

    boolean check_next(String set) {
        if (set.indexOf(this.current) < 0) {
            return false;
        }
        this.save_and_next();
        return true;
    }

    void buffreplace(char from, char to) {
        int n = this.nbuff;
        char[] p = this.buff;
        while (--n >= 0) {
            if (p[n] != from) continue;
            p[n] = to;
        }
    }

    LuaValue strx2number(String str, SemInfo seminfo) {
        int s2;
        char[] c = str.toCharArray();
        for (s2 = 0; s2 < c.length && this.isspace(c[s2]); ++s2) {
        }
        double sgn = 1.0;
        if (s2 < c.length && c[s2] == '-') {
            sgn = -1.0;
            ++s2;
        }
        if (s2 + 2 >= c.length || c[s2++] != '0' || c[s2] != 'x' && c[s2] != 'X') {
            return LuaValue.ZERO;
        }
        ++s2;
        double m4 = 0.0;
        int e = 0;
        while (s2 < c.length && this.isxdigit(c[s2])) {
            m4 = m4 * 16.0 + (double)this.hexvalue(c[s2++]);
        }
        if (s2 < c.length && c[s2] == '.') {
            ++s2;
            while (s2 < c.length && this.isxdigit(c[s2])) {
                m4 = m4 * 16.0 + (double)this.hexvalue(c[s2++]);
                e -= 4;
            }
        }
        if (s2 < c.length && (c[s2] == 'p' || c[s2] == 'P')) {
            int exp1 = 0;
            boolean neg1 = false;
            if (++s2 < c.length && c[s2] == '-') {
                neg1 = true;
                ++s2;
            }
            while (s2 < c.length && this.isdigit(c[s2])) {
                exp1 = exp1 * 10 + c[s2++] - 48;
            }
            if (neg1) {
                exp1 = -exp1;
            }
            e += exp1;
        }
        return LuaValue.valueOf(sgn * m4 * MathLib.dpow_d(2.0, e));
    }

    boolean str2d(String str, SemInfo seminfo) {
        if (str.indexOf(110) >= 0 || str.indexOf(78) >= 0) {
            seminfo.r = LuaValue.ZERO;
        } else if (str.indexOf(120) >= 0 || str.indexOf(88) >= 0) {
            seminfo.r = this.strx2number(str, seminfo);
        } else {
            try {
                seminfo.r = LuaValue.valueOf(Double.parseDouble(str.trim()));
            }
            catch (NumberFormatException e) {
                this.lexerror("malformed number (" + e.getMessage() + ")", 287);
            }
        }
        return true;
    }

    void read_numeral(SemInfo seminfo) {
        String expo = "Ee";
        int first = this.current;
        LexState._assert(this.isdigit(this.current));
        this.save_and_next();
        if (first == 48 && this.check_next("Xx")) {
            expo = "Pp";
        }
        while (true) {
            if (this.check_next(expo)) {
                this.check_next("+-");
            }
            if (!this.isxdigit(this.current) && this.current != 46) break;
            this.save_and_next();
        }
        String str = new String(this.buff, 0, this.nbuff);
        this.str2d(str, seminfo);
    }

    int skip_sep() {
        int count = 0;
        int s2 = this.current;
        LexState._assert(s2 == 91 || s2 == 93);
        this.save_and_next();
        while (this.current == 61) {
            this.save_and_next();
            ++count;
        }
        return this.current == s2 ? count : -count - 1;
    }

    void read_long_string(SemInfo seminfo, int sep) {
        int cont = 0;
        this.save_and_next();
        if (this.currIsNewline()) {
            this.inclinenumber();
        }
        boolean endloop = false;
        block6: while (!endloop) {
            switch (this.current) {
                case -1: {
                    this.lexerror(seminfo != null ? "unfinished long string" : "unfinished long comment", 286);
                    continue block6;
                }
                case 91: {
                    if (this.skip_sep() != sep) continue block6;
                    this.save_and_next();
                    ++cont;
                    if (sep != 0) continue block6;
                    this.lexerror("nesting of [[...]] is deprecated", 91);
                    continue block6;
                }
                case 93: {
                    if (this.skip_sep() != sep) continue block6;
                    this.save_and_next();
                    endloop = true;
                    continue block6;
                }
                case 10: 
                case 13: {
                    this.save(10);
                    this.inclinenumber();
                    if (seminfo != null) continue block6;
                    this.nbuff = 0;
                    continue block6;
                }
            }
            if (seminfo != null) {
                this.save_and_next();
                continue;
            }
            this.nextChar();
        }
        if (seminfo != null) {
            seminfo.ts = this.L.newTString(LuaString.valueOf(this.buff, 2 + sep, this.nbuff - 2 * (2 + sep)));
        }
    }

    int hexvalue(int c) {
        return c <= 57 ? c - 48 : (c <= 70 ? c + 10 - 65 : c + 10 - 97);
    }

    int readhexaesc() {
        this.nextChar();
        int c1 = this.current;
        this.nextChar();
        int c2 = this.current;
        if (!this.isxdigit(c1) || !this.isxdigit(c2)) {
            this.lexerror("hexadecimal digit expected 'x" + (char)c1 + (char)c2, 289);
        }
        return (this.hexvalue(c1) << 4) + this.hexvalue(c2);
    }

    void read_string(int del, SemInfo seminfo) {
        this.save_and_next();
        block18: while (this.current != del) {
            switch (this.current) {
                case -1: {
                    this.lexerror("unfinished string", 286);
                    continue block18;
                }
                case 10: 
                case 13: {
                    this.lexerror("unfinished string", 289);
                    continue block18;
                }
                case 92: {
                    int c;
                    this.nextChar();
                    switch (this.current) {
                        case 97: {
                            c = 7;
                            break;
                        }
                        case 98: {
                            c = 8;
                            break;
                        }
                        case 102: {
                            c = 12;
                            break;
                        }
                        case 110: {
                            c = 10;
                            break;
                        }
                        case 114: {
                            c = 13;
                            break;
                        }
                        case 116: {
                            c = 9;
                            break;
                        }
                        case 118: {
                            c = 11;
                            break;
                        }
                        case 120: {
                            c = this.readhexaesc();
                            break;
                        }
                        case 10: 
                        case 13: {
                            this.save(10);
                            this.inclinenumber();
                            continue block18;
                        }
                        case -1: {
                            continue block18;
                        }
                        case 122: {
                            this.nextChar();
                            while (this.isspace(this.current)) {
                                if (this.currIsNewline()) {
                                    this.inclinenumber();
                                    continue;
                                }
                                this.nextChar();
                            }
                            continue block18;
                        }
                        default: {
                            if (!this.isdigit(this.current)) {
                                this.save_and_next();
                                continue block18;
                            }
                            int i = 0;
                            c = 0;
                            do {
                                c = 10 * c + this.current - 48;
                                this.nextChar();
                            } while (++i < 3 && this.isdigit(this.current));
                            if (c > 255) {
                                this.lexerror("escape sequence too large", 289);
                            }
                            this.save(c);
                            continue block18;
                        }
                    }
                    this.save(c);
                    this.nextChar();
                    continue block18;
                }
            }
            this.save_and_next();
        }
        this.save_and_next();
        seminfo.ts = this.L.newTString(LuaString.valueOf(this.buff, 1, this.nbuff - 2));
    }

    /*
     * Unable to fully structure code
     */
    int llex(SemInfo seminfo) {
        this.nbuff = 0;
        block15: while (true) {
            switch (this.current) {
                case 10: 
                case 13: {
                    this.inclinenumber();
                    continue block15;
                }
                case 9: 
                case 11: 
                case 12: 
                case 32: {
                    this.nextChar();
                    continue block15;
                }
                case 45: {
                    this.nextChar();
                    if (this.current != 45) {
                        return 45;
                    }
                    this.nextChar();
                    if (this.current == 91) {
                        sep = this.skip_sep();
                        this.nbuff = 0;
                        if (sep >= 0) {
                            this.read_long_string(null, sep);
                            this.nbuff = 0;
                            continue block15;
                        }
                    }
                    while (true) {
                        if (!this.currIsNewline() && this.current != -1) ** break;
                        continue block15;
                        this.nextChar();
                    }
                }
                case 91: {
                    sep = this.skip_sep();
                    if (sep >= 0) {
                        this.read_long_string(seminfo, sep);
                        return 289;
                    }
                    if (sep == -1) {
                        return 91;
                    }
                    this.lexerror("invalid long string delimiter", 289);
                }
                case 61: {
                    this.nextChar();
                    if (this.current != 61) {
                        return 61;
                    }
                    this.nextChar();
                    return 281;
                }
                case 60: {
                    this.nextChar();
                    if (this.current != 61) {
                        return 60;
                    }
                    this.nextChar();
                    return 283;
                }
                case 62: {
                    this.nextChar();
                    if (this.current != 61) {
                        return 62;
                    }
                    this.nextChar();
                    return 282;
                }
                case 126: {
                    this.nextChar();
                    if (this.current != 61) {
                        return 126;
                    }
                    this.nextChar();
                    return 284;
                }
                case 58: {
                    this.nextChar();
                    if (this.current != 58) {
                        return 58;
                    }
                    this.nextChar();
                    return 285;
                }
                case 34: 
                case 39: {
                    this.read_string(this.current, seminfo);
                    return 289;
                }
                case 46: {
                    this.save_and_next();
                    if (this.check_next(".")) {
                        if (this.check_next(".")) {
                            return 280;
                        }
                        return 279;
                    }
                    if (!this.isdigit(this.current)) {
                        return 46;
                    }
                    this.read_numeral(seminfo);
                    return 287;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.read_numeral(seminfo);
                    return 287;
                }
                case -1: {
                    return 286;
                }
            }
            break;
        }
        if (this.isalpha(this.current) || this.current == 95) {
            do {
                this.save_and_next();
            } while (this.isalnum(this.current));
            ts = this.newstring(this.buff, 0, this.nbuff);
            if (LexState.RESERVED.containsKey(ts)) {
                return (Integer)LexState.RESERVED.get(ts);
            }
            seminfo.ts = ts;
            return 288;
        }
        c = this.current;
        this.nextChar();
        return c;
    }

    void next() {
        this.lastline = this.linenumber;
        if (this.lookahead.token != 286) {
            this.t.set(this.lookahead);
            this.lookahead.token = 286;
        } else {
            this.t.token = this.llex(this.t.seminfo);
        }
    }

    void lookahead() {
        LexState._assert(this.lookahead.token == 286);
        this.lookahead.token = this.llex(this.lookahead.seminfo);
    }

    static final boolean vkisvar(int k) {
        return 7 <= k && k <= 9;
    }

    static final boolean vkisinreg(int k) {
        return k == 6 || k == 7;
    }

    boolean hasmultret(int k) {
        return k == 12 || k == 13;
    }

    void anchor_token() {
        LexState._assert(this.fs != null || this.t.token == 286);
        if (this.t.token == 288 || this.t.token == 289) {
            LuaString ts = this.t.seminfo.ts;
            this.L.cachedLuaString(this.t.seminfo.ts);
        }
    }

    void semerror(String msg) {
        this.t.token = 0;
        this.syntaxerror(msg);
    }

    void error_expected(int token) {
        this.syntaxerror(this.L.pushfstring(LexState.LUA_QS(this.token2str(token)) + " expected"));
    }

    boolean testnext(int c) {
        if (this.t.token == c) {
            this.next();
            return true;
        }
        return false;
    }

    void check(int c) {
        if (this.t.token != c) {
            this.error_expected(c);
        }
    }

    void checknext(int c) {
        this.check(c);
        this.next();
    }

    void check_condition(boolean c, String msg) {
        if (!c) {
            this.syntaxerror(msg);
        }
    }

    void check_match(int what, int who, int where) {
        if (!this.testnext(what)) {
            if (where == this.linenumber) {
                this.error_expected(what);
            } else {
                this.syntaxerror(this.L.pushfstring(LexState.LUA_QS(this.token2str(what)) + " expected (to close " + LexState.LUA_QS(this.token2str(who)) + " at line " + where + ")"));
            }
        }
    }

    LuaString str_checkname() {
        this.check(288);
        LuaString ts = this.t.seminfo.ts;
        this.next();
        return ts;
    }

    void codestring(expdesc e, LuaString s2) {
        e.init(4, this.fs.stringK(s2));
    }

    void checkname(expdesc e) {
        this.codestring(e, this.str_checkname());
    }

    int registerlocalvar(LuaString varname) {
        FuncState fs = this.fs;
        Prototype f = fs.f;
        if (f.locvars == null || fs.nlocvars + 1 > f.locvars.length) {
            f.locvars = LexState.realloc(f.locvars, fs.nlocvars * 2 + 1);
        }
        f.locvars[fs.nlocvars] = new LocVars(varname, 0, 0);
        short s2 = fs.nlocvars;
        fs.nlocvars = (short)(s2 + 1);
        return s2;
    }

    void new_localvar(LuaString name) {
        int reg = this.registerlocalvar(name);
        this.fs.checklimit(this.dyd.n_actvar + 1, 200, "local variables");
        if (this.dyd.actvar == null || this.dyd.n_actvar + 1 > this.dyd.actvar.length) {
            this.dyd.actvar = LexState.realloc(this.dyd.actvar, Math.max(1, this.dyd.n_actvar * 2));
        }
        this.dyd.actvar[this.dyd.n_actvar++] = new Vardesc(reg);
    }

    void new_localvarliteral(String v) {
        LuaString ts = this.newstring(v);
        this.new_localvar(ts);
    }

    void adjustlocalvars(int nvars) {
        FuncState fs = this.fs;
        fs.nactvar = (short)(fs.nactvar + nvars);
        while (nvars > 0) {
            fs.getlocvar((int)(fs.nactvar - nvars)).startpc = fs.pc;
            --nvars;
        }
    }

    void removevars(int tolevel) {
        FuncState fs = this.fs;
        while (fs.nactvar > tolevel) {
            fs.nactvar = (short)(fs.nactvar - 1);
            fs.getlocvar((int)((short)(fs.nactvar - 1))).endpc = fs.pc;
        }
    }

    void singlevar(expdesc var) {
        FuncState fs = this.fs;
        LuaString varname = this.str_checkname();
        if (FuncState.singlevaraux(fs, varname, var, 1) == 0) {
            expdesc key = new expdesc();
            FuncState.singlevaraux(fs, this.envn, var, 1);
            LexState._assert(var.k == 7 || var.k == 8);
            this.codestring(key, varname);
            fs.indexed(var, key);
        }
    }

    void adjust_assign(int nvars, int nexps, expdesc e) {
        FuncState fs = this.fs;
        int extra = nvars - nexps;
        if (this.hasmultret(e.k)) {
            if (++extra < 0) {
                extra = 0;
            }
            fs.setreturns(e, extra);
            if (extra > 1) {
                fs.reserveregs(extra - 1);
            }
        } else {
            if (e.k != 0) {
                fs.exp2nextreg(e);
            }
            if (extra > 0) {
                short reg = fs.freereg;
                fs.reserveregs(extra);
                fs.nil(reg, extra);
            }
        }
    }

    void enterlevel() {
        if (++this.L.nCcalls > 200) {
            this.lexerror("chunk has too many syntax levels", 0);
        }
    }

    void leavelevel() {
        --this.L.nCcalls;
    }

    void closegoto(int g2, Labeldesc label) {
        FuncState fs = this.fs;
        Labeldesc[] gl = this.dyd.gt;
        Labeldesc gt = gl[g2];
        LexState._assert(gt.name.eq_b(label.name));
        if (gt.nactvar < label.nactvar) {
            LuaString vname = fs.getlocvar((int)gt.nactvar).varname;
            String msg = this.L.pushfstring("<goto " + gt.name + "> at line " + gt.line + " jumps into the scope of local '" + vname.tojstring() + "'");
            this.semerror(msg);
        }
        fs.patchlist(gt.pc, label.pc);
        System.arraycopy(gl, g2 + 1, gl, g2, this.dyd.n_gt - g2 - 1);
        gl[--this.dyd.n_gt] = null;
    }

    boolean findlabel(int g2) {
        FuncState.BlockCnt bl = this.fs.bl;
        Dyndata dyd = this.dyd;
        Labeldesc gt = dyd.gt[g2];
        for (int i = bl.firstlabel; i < dyd.n_label; ++i) {
            Labeldesc lb = dyd.label[i];
            if (!lb.name.eq_b(gt.name)) continue;
            if (gt.nactvar > lb.nactvar && (bl.upval || dyd.n_label > bl.firstlabel)) {
                this.fs.patchclose(gt.pc, lb.nactvar);
            }
            this.closegoto(g2, lb);
            return true;
        }
        return false;
    }

    int newlabelentry(Labeldesc[] l, int index, LuaString name, int line, int pc) {
        l[index] = new Labeldesc(name, pc, line, this.fs.nactvar);
        return index;
    }

    void findgotos(Labeldesc lb) {
        Labeldesc[] gl = this.dyd.gt;
        int i = this.fs.bl.firstgoto;
        while (i < this.dyd.n_gt) {
            if (gl[i].name.eq_b(lb.name)) {
                this.closegoto(i, lb);
                continue;
            }
            ++i;
        }
    }

    void breaklabel() {
        LuaString n = LuaString.valueOf("break");
        this.dyd.label = LexState.grow(this.dyd.label, this.dyd.n_label + 1);
        int l = this.newlabelentry(this.dyd.label, this.dyd.n_label++, n, 0, this.fs.pc);
        this.findgotos(this.dyd.label[l]);
    }

    void undefgoto(Labeldesc gt) {
        String msg = this.L.pushfstring(LexState.isReservedKeyword(gt.name.tojstring()) ? "<" + gt.name + "> at line " + gt.line + " not inside a loop" : "no visible label '" + gt.name + "' for <goto> at line " + gt.line);
        this.semerror(msg);
    }

    Prototype addprototype() {
        Prototype clp;
        Prototype f = this.fs.f;
        if (f.p == null || this.fs.np >= f.p.length) {
            f.p = LexState.realloc(f.p, Math.max(1, this.fs.np * 2));
        }
        f.p[this.fs.np++] = clp = new Prototype();
        return clp;
    }

    void codeclosure(expdesc v) {
        FuncState fs = this.fs.prev;
        v.init(11, fs.codeABx(37, 0, fs.np - 1));
        fs.exp2nextreg(v);
    }

    void open_func(FuncState fs, FuncState.BlockCnt bl) {
        fs.prev = this.fs;
        fs.ls = this;
        this.fs = fs;
        fs.pc = 0;
        fs.lasttarget = -1;
        fs.jpc = new IntPtr(-1);
        fs.freereg = 0;
        fs.nk = 0;
        fs.np = 0;
        fs.nups = 0;
        fs.nlocvars = 0;
        fs.nactvar = 0;
        fs.firstlocal = this.dyd.n_actvar;
        fs.bl = null;
        fs.f.source = this.source;
        fs.f.maxstacksize = 2;
        fs.enterblock(bl, false);
    }

    void close_func() {
        FuncState fs = this.fs;
        Prototype f = fs.f;
        fs.ret(0, 0);
        fs.leaveblock();
        f.code = LexState.realloc(f.code, fs.pc);
        f.lineinfo = LexState.realloc(f.lineinfo, fs.pc);
        f.k = LexState.realloc(f.k, fs.nk);
        f.p = LexState.realloc(f.p, fs.np);
        f.locvars = LexState.realloc(f.locvars, (int)fs.nlocvars);
        f.upvalues = LexState.realloc(f.upvalues, (int)fs.nups);
        LexState._assert(fs.bl == null);
        this.fs = fs.prev;
    }

    void fieldsel(expdesc v) {
        FuncState fs = this.fs;
        expdesc key = new expdesc();
        fs.exp2anyregup(v);
        this.next();
        this.checkname(key);
        fs.indexed(v, key);
    }

    void yindex(expdesc v) {
        this.next();
        this.expr(v);
        this.fs.exp2val(v);
        this.checknext(93);
    }

    void recfield(ConsControl cc) {
        FuncState fs = this.fs;
        short reg = this.fs.freereg;
        expdesc key = new expdesc();
        expdesc val = new expdesc();
        if (this.t.token == 288) {
            fs.checklimit(cc.nh, 0x7FFFFFFD, "items in a constructor");
            this.checkname(key);
        } else {
            this.yindex(key);
        }
        ++cc.nh;
        this.checknext(61);
        int rkkey = fs.exp2RK(key);
        this.expr(val);
        fs.codeABC(10, cc.t.u.info, rkkey, fs.exp2RK(val));
        fs.freereg = reg;
    }

    void listfield(ConsControl cc) {
        this.expr(cc.v);
        this.fs.checklimit(cc.na, 0x7FFFFFFD, "items in a constructor");
        ++cc.na;
        ++cc.tostore;
    }

    void constructor(expdesc t2) {
        FuncState fs = this.fs;
        int line = this.linenumber;
        int pc = fs.codeABC(11, 0, 0, 0);
        ConsControl cc = new ConsControl();
        cc.tostore = 0;
        cc.nh = 0;
        cc.na = 0;
        cc.t = t2;
        t2.init(11, pc);
        cc.v.init(0, 0);
        fs.exp2nextreg(t2);
        this.checknext(123);
        do {
            LexState._assert(cc.v.k == 0 || cc.tostore > 0);
            if (this.t.token == 125) break;
            fs.closelistfield(cc);
            switch (this.t.token) {
                case 288: {
                    this.lookahead();
                    if (this.lookahead.token != 61) {
                        this.listfield(cc);
                        break;
                    }
                    this.recfield(cc);
                    break;
                }
                case 91: {
                    this.recfield(cc);
                    break;
                }
                default: {
                    this.listfield(cc);
                }
            }
        } while (this.testnext(44) || this.testnext(59));
        this.check_match(125, 123, line);
        fs.lastlistfield(cc);
        InstructionPtr i = new InstructionPtr(fs.f.code, pc);
        LexState.SETARG_B(i, LexState.luaO_int2fb(cc.na));
        LexState.SETARG_C(i, LexState.luaO_int2fb(cc.nh));
    }

    static int luaO_int2fb(int x) {
        int e = 0;
        while (x >= 16) {
            x = x + 1 >> 1;
            ++e;
        }
        if (x < 8) {
            return x;
        }
        return e + 1 << 3 | x - 8;
    }

    void parlist() {
        FuncState fs = this.fs;
        Prototype f = fs.f;
        int nparams = 0;
        f.is_vararg = 0;
        if (this.t.token != 41) {
            do {
                switch (this.t.token) {
                    case 288: {
                        this.new_localvar(this.str_checkname());
                        ++nparams;
                        break;
                    }
                    case 280: {
                        this.next();
                        f.is_vararg = 1;
                        break;
                    }
                    default: {
                        this.syntaxerror("<name> or " + LexState.LUA_QL("...") + " expected");
                    }
                }
            } while (f.is_vararg == 0 && this.testnext(44));
        }
        this.adjustlocalvars(nparams);
        f.numparams = fs.nactvar;
        fs.reserveregs(fs.nactvar);
    }

    void body(expdesc e, boolean needself, int line) {
        FuncState new_fs = new FuncState();
        FuncState.BlockCnt bl = new FuncState.BlockCnt();
        new_fs.f = this.addprototype();
        new_fs.f.linedefined = line;
        this.open_func(new_fs, bl);
        this.checknext(40);
        if (needself) {
            this.new_localvarliteral("self");
            this.adjustlocalvars(1);
        }
        this.parlist();
        this.checknext(41);
        this.statlist();
        new_fs.f.lastlinedefined = this.linenumber;
        this.check_match(262, 265, line);
        this.codeclosure(e);
        this.close_func();
    }

    int explist(expdesc v) {
        int n = 1;
        this.expr(v);
        while (this.testnext(44)) {
            this.fs.exp2nextreg(v);
            this.expr(v);
            ++n;
        }
        return n;
    }

    void funcargs(expdesc f, int line) {
        int nparams;
        FuncState fs = this.fs;
        expdesc args = new expdesc();
        switch (this.t.token) {
            case 40: {
                this.next();
                if (this.t.token == 41) {
                    args.k = 0;
                } else {
                    this.explist(args);
                    fs.setmultret(args);
                }
                this.check_match(41, 40, line);
                break;
            }
            case 123: {
                this.constructor(args);
                break;
            }
            case 289: {
                this.codestring(args, this.t.seminfo.ts);
                this.next();
                break;
            }
            default: {
                this.syntaxerror("function arguments expected");
                return;
            }
        }
        LexState._assert(f.k == 6);
        int base = f.u.info;
        if (this.hasmultret(args.k)) {
            nparams = -1;
        } else {
            if (args.k != 0) {
                fs.exp2nextreg(args);
            }
            nparams = fs.freereg - (base + 1);
        }
        f.init(12, fs.codeABC(29, base, nparams + 1, 2));
        fs.fixline(line);
        fs.freereg = (short)(base + 1);
    }

    void primaryexp(expdesc v) {
        switch (this.t.token) {
            case 40: {
                int line = this.linenumber;
                this.next();
                this.expr(v);
                this.check_match(41, 40, line);
                this.fs.dischargevars(v);
                return;
            }
            case 288: {
                this.singlevar(v);
                return;
            }
        }
        this.syntaxerror("unexpected symbol " + this.t.token + " (" + (char)this.t.token + ")");
    }

    void suffixedexp(expdesc v) {
        int line = this.linenumber;
        this.primaryexp(v);
        block6: while (true) {
            switch (this.t.token) {
                case 46: {
                    this.fieldsel(v);
                    continue block6;
                }
                case 91: {
                    expdesc key = new expdesc();
                    this.fs.exp2anyregup(v);
                    this.yindex(key);
                    this.fs.indexed(v, key);
                    continue block6;
                }
                case 58: {
                    expdesc key = new expdesc();
                    this.next();
                    this.checkname(key);
                    this.fs.self(v, key);
                    this.funcargs(v, line);
                    continue block6;
                }
                case 40: 
                case 123: 
                case 289: {
                    this.fs.exp2nextreg(v);
                    this.funcargs(v, line);
                    continue block6;
                }
            }
            break;
        }
    }

    void simpleexp(expdesc v) {
        switch (this.t.token) {
            case 287: {
                v.init(5, 0);
                v.u.setNval(this.t.seminfo.r);
                break;
            }
            case 289: {
                this.codestring(v, this.t.seminfo.ts);
                break;
            }
            case 270: {
                v.init(1, 0);
                break;
            }
            case 276: {
                v.init(2, 0);
                break;
            }
            case 263: {
                v.init(3, 0);
                break;
            }
            case 280: {
                FuncState fs = this.fs;
                this.check_condition(fs.f.is_vararg != 0, "cannot use " + LexState.LUA_QL("...") + " outside a vararg function");
                v.init(13, fs.codeABC(38, 0, 1, 0));
                break;
            }
            case 123: {
                this.constructor(v);
                return;
            }
            case 265: {
                this.next();
                this.body(v, false, this.linenumber);
                return;
            }
            default: {
                this.suffixedexp(v);
                return;
            }
        }
        this.next();
    }

    int getunopr(int op) {
        switch (op) {
            case 271: {
                return 1;
            }
            case 45: {
                return 0;
            }
            case 35: {
                return 2;
            }
        }
        return 3;
    }

    int getbinopr(int op) {
        switch (op) {
            case 43: {
                return 0;
            }
            case 45: {
                return 1;
            }
            case 42: {
                return 2;
            }
            case 47: {
                return 3;
            }
            case 37: {
                return 4;
            }
            case 94: {
                return 5;
            }
            case 279: {
                return 6;
            }
            case 284: {
                return 7;
            }
            case 281: {
                return 8;
            }
            case 60: {
                return 9;
            }
            case 283: {
                return 10;
            }
            case 62: {
                return 11;
            }
            case 282: {
                return 12;
            }
            case 257: {
                return 13;
            }
            case 272: {
                return 14;
            }
        }
        return 15;
    }

    int subexpr(expdesc v, int limit) {
        this.enterlevel();
        int uop = this.getunopr(this.t.token);
        if (uop != 3) {
            int line = this.linenumber;
            this.next();
            this.subexpr(v, 8);
            this.fs.prefix(uop, v, line);
        } else {
            this.simpleexp(v);
        }
        int op = this.getbinopr(this.t.token);
        while (op != 15 && LexState.priority[op].left > limit) {
            expdesc v2 = new expdesc();
            int line = this.linenumber;
            this.next();
            this.fs.infix(op, v);
            int nextop = this.subexpr(v2, LexState.priority[op].right);
            this.fs.posfix(op, v, v2, line);
            op = nextop;
        }
        this.leavelevel();
        return op;
    }

    void expr(expdesc v) {
        this.subexpr(v, 0);
    }

    boolean block_follow(boolean withuntil) {
        switch (this.t.token) {
            case 260: 
            case 261: 
            case 262: 
            case 286: {
                return true;
            }
            case 277: {
                return withuntil;
            }
        }
        return false;
    }

    void block() {
        FuncState fs = this.fs;
        FuncState.BlockCnt bl = new FuncState.BlockCnt();
        fs.enterblock(bl, false);
        this.statlist();
        fs.leaveblock();
    }

    void check_conflict(LHS_assign lh, expdesc v) {
        FuncState fs = this.fs;
        short extra = fs.freereg;
        boolean conflict = false;
        while (lh != null) {
            if (lh.v.k == 9) {
                if (lh.v.u.ind_vt == v.k && lh.v.u.ind_t == v.u.info) {
                    conflict = true;
                    lh.v.u.ind_vt = (short)7;
                    lh.v.u.ind_t = extra;
                }
                if (v.k == 7 && lh.v.u.ind_idx == v.u.info) {
                    conflict = true;
                    lh.v.u.ind_idx = extra;
                }
            }
            lh = lh.prev;
        }
        if (conflict) {
            int op = v.k == 7 ? 0 : 5;
            fs.codeABC(op, extra, v.u.info, 0);
            fs.reserveregs(1);
        }
    }

    void assignment(LHS_assign lh, int nvars) {
        expdesc e = new expdesc();
        this.check_condition(7 <= lh.v.k && lh.v.k <= 9, "syntax error");
        if (this.testnext(44)) {
            LHS_assign nv = new LHS_assign();
            nv.prev = lh;
            this.suffixedexp(nv.v);
            if (nv.v.k != 9) {
                this.check_conflict(lh, nv.v);
            }
            this.assignment(nv, nvars + 1);
        } else {
            this.checknext(61);
            int nexps = this.explist(e);
            if (nexps != nvars) {
                this.adjust_assign(nvars, nexps, e);
                if (nexps > nvars) {
                    this.fs.freereg = (short)(this.fs.freereg - (nexps - nvars));
                }
            } else {
                this.fs.setoneret(e);
                this.fs.storevar(lh.v, e);
                return;
            }
        }
        e.init(6, this.fs.freereg - 1);
        this.fs.storevar(lh.v, e);
    }

    int cond() {
        expdesc v = new expdesc();
        this.expr(v);
        if (v.k == 1) {
            v.k = 3;
        }
        this.fs.goiftrue(v);
        return v.f.i;
    }

    void gotostat(int pc) {
        LuaString label;
        int line = this.linenumber;
        if (this.testnext(266)) {
            label = this.str_checkname();
        } else {
            this.next();
            label = LuaString.valueOf("break");
        }
        this.dyd.gt = LexState.grow(this.dyd.gt, this.dyd.n_gt + 1);
        int g2 = this.newlabelentry(this.dyd.gt, this.dyd.n_gt++, label, line, pc);
        this.findlabel(g2);
    }

    void skipnoopstat() {
        while (this.t.token == 59 || this.t.token == 285) {
            this.statement();
        }
    }

    void labelstat(LuaString label, int line) {
        this.fs.checkrepeated(this.dyd.label, this.dyd.n_label, label);
        this.checknext(285);
        this.dyd.label = LexState.grow(this.dyd.label, this.dyd.n_label + 1);
        int l = this.newlabelentry(this.dyd.label, this.dyd.n_label++, label, line, this.fs.getlabel());
        this.skipnoopstat();
        if (this.block_follow(false)) {
            this.dyd.label[l].nactvar = this.fs.bl.nactvar;
        }
        this.findgotos(this.dyd.label[l]);
    }

    void whilestat(int line) {
        FuncState fs = this.fs;
        FuncState.BlockCnt bl = new FuncState.BlockCnt();
        this.next();
        int whileinit = fs.getlabel();
        int condexit = this.cond();
        fs.enterblock(bl, true);
        this.checknext(259);
        this.block();
        fs.patchlist(fs.jump(), whileinit);
        this.check_match(262, 278, line);
        fs.leaveblock();
        fs.patchtohere(condexit);
    }

    void repeatstat(int line) {
        FuncState fs = this.fs;
        int repeat_init = fs.getlabel();
        FuncState.BlockCnt bl1 = new FuncState.BlockCnt();
        FuncState.BlockCnt bl2 = new FuncState.BlockCnt();
        fs.enterblock(bl1, true);
        fs.enterblock(bl2, false);
        this.next();
        this.statlist();
        this.check_match(277, 273, line);
        int condexit = this.cond();
        if (bl2.upval) {
            fs.patchclose(condexit, bl2.nactvar);
        }
        fs.leaveblock();
        fs.patchlist(condexit, repeat_init);
        fs.leaveblock();
    }

    int exp1() {
        expdesc e = new expdesc();
        this.expr(e);
        int k = e.k;
        this.fs.exp2nextreg(e);
        return k;
    }

    void forbody(int base, int line, int nvars, boolean isnum) {
        int endfor;
        FuncState.BlockCnt bl = new FuncState.BlockCnt();
        FuncState fs = this.fs;
        this.adjustlocalvars(3);
        this.checknext(259);
        int prep = isnum ? fs.codeAsBx(33, base, -1) : fs.jump();
        fs.enterblock(bl, false);
        this.adjustlocalvars(nvars);
        fs.reserveregs(nvars);
        this.block();
        fs.leaveblock();
        fs.patchtohere(prep);
        if (isnum) {
            endfor = fs.codeAsBx(32, base, -1);
        } else {
            fs.codeABC(34, base, 0, nvars);
            fs.fixline(line);
            endfor = fs.codeAsBx(35, base + 2, -1);
        }
        fs.patchlist(endfor, prep + 1);
        fs.fixline(line);
    }

    void fornum(LuaString varname, int line) {
        FuncState fs = this.fs;
        short base = fs.freereg;
        this.new_localvarliteral(RESERVED_LOCAL_VAR_FOR_INDEX);
        this.new_localvarliteral(RESERVED_LOCAL_VAR_FOR_LIMIT);
        this.new_localvarliteral(RESERVED_LOCAL_VAR_FOR_STEP);
        this.new_localvar(varname);
        this.checknext(61);
        this.exp1();
        this.checknext(44);
        this.exp1();
        if (this.testnext(44)) {
            this.exp1();
        } else {
            fs.codeK(fs.freereg, fs.numberK(LuaInteger.valueOf(1)));
            fs.reserveregs(1);
        }
        this.forbody(base, line, 1, true);
    }

    void forlist(LuaString indexname) {
        FuncState fs = this.fs;
        expdesc e = new expdesc();
        int nvars = 4;
        short base = fs.freereg;
        this.new_localvarliteral(RESERVED_LOCAL_VAR_FOR_GENERATOR);
        this.new_localvarliteral(RESERVED_LOCAL_VAR_FOR_STATE);
        this.new_localvarliteral(RESERVED_LOCAL_VAR_FOR_CONTROL);
        this.new_localvar(indexname);
        while (this.testnext(44)) {
            this.new_localvar(this.str_checkname());
            ++nvars;
        }
        this.checknext(268);
        int line = this.linenumber;
        this.adjust_assign(3, this.explist(e), e);
        fs.checkstack(3);
        this.forbody(base, line, nvars - 3, false);
    }

    void forstat(int line) {
        FuncState fs = this.fs;
        FuncState.BlockCnt bl = new FuncState.BlockCnt();
        fs.enterblock(bl, true);
        this.next();
        LuaString varname = this.str_checkname();
        switch (this.t.token) {
            case 61: {
                this.fornum(varname, line);
                break;
            }
            case 44: 
            case 268: {
                this.forlist(varname);
                break;
            }
            default: {
                this.syntaxerror(LexState.LUA_QL("=") + " or " + LexState.LUA_QL("in") + " expected");
            }
        }
        this.check_match(262, 264, line);
        fs.leaveblock();
    }

    void test_then_block(IntPtr escapelist) {
        int jf;
        expdesc v = new expdesc();
        FuncState.BlockCnt bl = new FuncState.BlockCnt();
        this.next();
        this.expr(v);
        this.checknext(275);
        if (this.t.token == 266 || this.t.token == 258) {
            this.fs.goiffalse(v);
            this.fs.enterblock(bl, false);
            this.gotostat(v.t.i);
            this.skipnoopstat();
            if (this.block_follow(false)) {
                this.fs.leaveblock();
                return;
            }
            jf = this.fs.jump();
        } else {
            this.fs.goiftrue(v);
            this.fs.enterblock(bl, false);
            jf = v.f.i;
        }
        this.statlist();
        this.fs.leaveblock();
        if (this.t.token == 260 || this.t.token == 261) {
            this.fs.concat(escapelist, this.fs.jump());
        }
        this.fs.patchtohere(jf);
    }

    void ifstat(int line) {
        IntPtr escapelist = new IntPtr(-1);
        this.test_then_block(escapelist);
        while (this.t.token == 261) {
            this.test_then_block(escapelist);
        }
        if (this.testnext(260)) {
            this.block();
        }
        this.check_match(262, 267, line);
        this.fs.patchtohere(escapelist.i);
    }

    void localfunc() {
        expdesc b = new expdesc();
        FuncState fs = this.fs;
        this.new_localvar(this.str_checkname());
        this.adjustlocalvars(1);
        this.body(b, false, this.linenumber);
        fs.getlocvar((int)(fs.nactvar - 1)).startpc = fs.pc;
    }

    void localstat() {
        int nexps;
        int nvars = 0;
        expdesc e = new expdesc();
        do {
            this.new_localvar(this.str_checkname());
            ++nvars;
        } while (this.testnext(44));
        if (this.testnext(61)) {
            nexps = this.explist(e);
        } else {
            e.k = 0;
            nexps = 0;
        }
        this.adjust_assign(nvars, nexps, e);
        this.adjustlocalvars(nvars);
    }

    boolean funcname(expdesc v) {
        boolean ismethod = false;
        this.singlevar(v);
        while (this.t.token == 46) {
            this.fieldsel(v);
        }
        if (this.t.token == 58) {
            ismethod = true;
            this.fieldsel(v);
        }
        return ismethod;
    }

    void funcstat(int line) {
        expdesc v = new expdesc();
        expdesc b = new expdesc();
        this.next();
        boolean needself = this.funcname(v);
        this.body(b, needself, line);
        this.fs.storevar(v, b);
        this.fs.fixline(line);
    }

    void exprstat() {
        FuncState fs = this.fs;
        LHS_assign v = new LHS_assign();
        this.suffixedexp(v.v);
        if (this.t.token == 61 || this.t.token == 44) {
            v.prev = null;
            this.assignment(v, 1);
        } else {
            this.check_condition(v.v.k == 12, "syntax error");
            LexState.SETARG_C(fs.getcodePtr(v.v), 1);
        }
    }

    void retstat() {
        int first;
        int nret;
        FuncState fs = this.fs;
        expdesc e = new expdesc();
        if (this.block_follow(true) || this.t.token == 59) {
            nret = 0;
            first = 0;
        } else {
            nret = this.explist(e);
            if (this.hasmultret(e.k)) {
                fs.setmultret(e);
                if (e.k == 12 && nret == 1) {
                    LexState.SET_OPCODE(fs.getcodePtr(e), 30);
                    LexState._assert(Lua.GETARG_A(fs.getcode(e)) == fs.nactvar);
                }
                first = fs.nactvar;
                nret = -1;
            } else if (nret == 1) {
                first = fs.exp2anyreg(e);
            } else {
                fs.exp2nextreg(e);
                first = fs.nactvar;
                LexState._assert(nret == fs.freereg - first);
            }
        }
        fs.ret(first, nret);
        this.testnext(59);
    }

    void statement() {
        int line = this.linenumber;
        this.enterlevel();
        switch (this.t.token) {
            case 59: {
                this.next();
                break;
            }
            case 267: {
                this.ifstat(line);
                break;
            }
            case 278: {
                this.whilestat(line);
                break;
            }
            case 259: {
                this.next();
                this.block();
                this.check_match(262, 259, line);
                break;
            }
            case 264: {
                this.forstat(line);
                break;
            }
            case 273: {
                this.repeatstat(line);
                break;
            }
            case 265: {
                this.funcstat(line);
                break;
            }
            case 269: {
                this.next();
                if (this.testnext(265)) {
                    this.localfunc();
                    break;
                }
                this.localstat();
                break;
            }
            case 285: {
                this.next();
                this.labelstat(this.str_checkname(), line);
                break;
            }
            case 274: {
                this.next();
                this.retstat();
                break;
            }
            case 258: 
            case 266: {
                this.gotostat(this.fs.jump());
                break;
            }
            default: {
                this.exprstat();
            }
        }
        LexState._assert(this.fs.f.maxstacksize >= this.fs.freereg && this.fs.freereg >= this.fs.nactvar);
        this.fs.freereg = this.fs.nactvar;
        this.leavelevel();
    }

    void statlist() {
        while (!this.block_follow(true)) {
            if (this.t.token == 274) {
                this.statement();
                return;
            }
            this.statement();
        }
    }

    public void mainfunc(FuncState funcstate) {
        FuncState.BlockCnt bl = new FuncState.BlockCnt();
        this.open_func(funcstate, bl);
        this.fs.f.is_vararg = 1;
        expdesc v = new expdesc();
        v.init(7, 0);
        this.fs.newupvalue(this.envn, v);
        this.next();
        this.statlist();
        this.check(286);
        this.close_func();
    }

    static {
        for (String element : RESERVED_LOCAL_VAR_KEYWORDS) {
            RESERVED_LOCAL_VAR_KEYWORDS_TABLE.put(element, Boolean.TRUE);
        }
        luaX_tokens = new String[]{"and", "break", "do", "else", "elseif", "end", "false", "for", "function", "goto", "if", "in", "local", "nil", "not", "or", "repeat", "return", "then", "true", "until", "while", "..", "...", "==", ">=", "<=", "~=", "::", "<eos>", "<number>", "<name>", "<string>", "<eof>"};
        RESERVED = new Hashtable();
        for (int i = 0; i < 22; ++i) {
            LuaString ts = LuaValue.valueOf(luaX_tokens[i]);
            RESERVED.put(ts, 257 + i);
        }
        priority = new Priority[]{new Priority(6, 6), new Priority(6, 6), new Priority(7, 7), new Priority(7, 7), new Priority(7, 7), new Priority(10, 9), new Priority(5, 4), new Priority(3, 3), new Priority(3, 3), new Priority(3, 3), new Priority(3, 3), new Priority(3, 3), new Priority(3, 3), new Priority(2, 2), new Priority(1, 1)};
    }

    private static class Token {
        int token;
        final SemInfo seminfo = new SemInfo();

        private Token() {
        }

        public void set(Token other) {
            this.token = other.token;
            this.seminfo.r = other.seminfo.r;
            this.seminfo.ts = other.seminfo.ts;
        }
    }

    static class Dyndata {
        Vardesc[] actvar;
        int n_actvar = 0;
        Labeldesc[] gt;
        int n_gt = 0;
        Labeldesc[] label;
        int n_label = 0;

        Dyndata() {
        }
    }

    private static class SemInfo {
        LuaValue r;
        LuaString ts;

        private SemInfo() {
        }
    }

    static class expdesc {
        int k;
        final U u = new U();
        final IntPtr t = new IntPtr();
        final IntPtr f = new IntPtr();

        expdesc() {
        }

        void init(int k, int i) {
            this.f.i = -1;
            this.t.i = -1;
            this.k = k;
            this.u.info = i;
        }

        boolean hasjumps() {
            return this.t.i != this.f.i;
        }

        boolean isnumeral() {
            return this.k == 5 && this.t.i == -1 && this.f.i == -1;
        }

        public void setvalue(expdesc other) {
            this.f.i = other.f.i;
            this.k = other.k;
            this.t.i = other.t.i;
            this.u._nval = other.u._nval;
            this.u.ind_idx = other.u.ind_idx;
            this.u.ind_t = other.u.ind_t;
            this.u.ind_vt = other.u.ind_vt;
            this.u.info = other.u.info;
        }

        static class U {
            short ind_idx;
            short ind_t;
            short ind_vt;
            private LuaValue _nval;
            int info;

            U() {
            }

            public void setNval(LuaValue r) {
                this._nval = r;
            }

            public LuaValue nval() {
                return this._nval == null ? LuaInteger.valueOf(this.info) : this._nval;
            }
        }
    }

    static class Vardesc {
        final short idx;

        Vardesc(int idx) {
            this.idx = (short)idx;
        }
    }

    static class Labeldesc {
        LuaString name;
        int pc;
        int line;
        short nactvar;

        public Labeldesc(LuaString name, int pc, int line, short nactvar) {
            this.name = name;
            this.pc = pc;
            this.line = line;
            this.nactvar = nactvar;
        }
    }

    static class ConsControl {
        expdesc v = new expdesc();
        expdesc t;
        int nh;
        int na;
        int tostore;

        ConsControl() {
        }
    }

    static class Priority {
        final byte left;
        final byte right;

        public Priority(int i, int j) {
            this.left = (byte)i;
            this.right = (byte)j;
        }
    }

    static class LHS_assign {
        LHS_assign prev;
        expdesc v = new expdesc();

        LHS_assign() {
        }
    }
}

