/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.world_modification;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.moulberry.axiom.VersionUtils;
import com.moulberry.axiom.collections.PositionConsumer;
import com.moulberry.axiom.utils.DFUHelper;
import com.moulberry.axiom.utils.PositionUtils;
import com.moulberry.axiom.world_modification.BlockOrBiomeBuffer;
import com.moulberry.axiom.world_modification.CompressedBlockEntity;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2359;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2814;
import net.minecraft.class_2816;
import net.minecraft.class_2834;
import net.minecraft.class_2837;
import net.minecraft.class_2841;
import net.minecraft.class_3508;
import net.minecraft.class_6490;
import net.minecraft.class_6502;
import net.minecraft.class_6564;
import org.jetbrains.annotations.Nullable;

public class BlockBuffer
implements BlockOrBiomeBuffer {
    public static final class_2680 EMPTY_STATE = class_2246.field_10369.method_9564();
    public static final Codec<class_2841<class_2680>> BLOCK_STATE_CODEC = class_2841.method_44343((class_2359)class_2248.field_10651, (Codec)class_2680.field_24734, (class_2841.class_6563)class_2841.class_6563.field_34569, (Object)EMPTY_STATE);
    private final Long2ObjectMap<class_2841<class_2680>> values;
    private class_2841<class_2680> last = null;
    private long lastId = PositionUtils.MIN_POSITION_LONG;
    private final Long2ObjectMap<Short2ObjectMap<CompressedBlockEntity>> blockEntities = new Long2ObjectOpenHashMap();

    public BlockBuffer() {
        this.values = new Long2ObjectOpenHashMap();
    }

    public BlockBuffer(Long2ObjectMap<class_2841<class_2680>> values) {
        this.values = values;
    }

    public void saveRaw(class_2540 friendlyByteBuf) {
        for (Long2ObjectMap.Entry entry : this.entrySet()) {
            friendlyByteBuf.method_52974(entry.getLongKey());
            ((class_2841)entry.getValue()).method_12325(friendlyByteBuf);
            Short2ObjectMap blockEntities = (Short2ObjectMap)this.blockEntities.get(entry.getLongKey());
            if (blockEntities != null) {
                friendlyByteBuf.method_10804(blockEntities.size());
                for (Short2ObjectMap.Entry entry2 : blockEntities.short2ObjectEntrySet()) {
                    friendlyByteBuf.method_52998((int)entry2.getShortKey());
                    ((CompressedBlockEntity)entry2.getValue()).write(friendlyByteBuf);
                }
                continue;
            }
            friendlyByteBuf.method_10804(0);
        }
        friendlyByteBuf.method_52974(PositionUtils.MIN_POSITION_LONG);
    }

    public static BlockBuffer loadRaw(class_2540 friendlyByteBuf) {
        long index;
        BlockBuffer buffer = new BlockBuffer();
        while ((index = friendlyByteBuf.readLong()) != PositionUtils.MIN_POSITION_LONG) {
            class_2841<class_2680> palettedContainer = buffer.getOrCreateSection(index);
            palettedContainer.method_12326(friendlyByteBuf);
            int blockEntitySize = Math.min(4096, friendlyByteBuf.method_10816());
            if (blockEntitySize <= 0) continue;
            Short2ObjectOpenHashMap map = new Short2ObjectOpenHashMap(blockEntitySize);
            for (int i = 0; i < blockEntitySize; ++i) {
                short offset = friendlyByteBuf.readShort();
                CompressedBlockEntity blockEntity = CompressedBlockEntity.read(friendlyByteBuf);
                map.put(offset, (Object)blockEntity);
            }
            buffer.blockEntities.put(index, (Object)map);
        }
        return buffer;
    }

    public void saveNBT(class_2540 friendlyByteBuf) {
        for (Long2ObjectMap.Entry entry : this.entrySet()) {
            friendlyByteBuf.method_52974(entry.getLongKey());
            class_2520 encoded = (class_2520)VersionUtils.getOrThrow(BLOCK_STATE_CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)((class_2841)entry.getValue())));
            friendlyByteBuf.method_10794((class_2520)((class_2487)encoded));
            Short2ObjectMap blockEntities = (Short2ObjectMap)this.blockEntities.get(entry.getLongKey());
            if (blockEntities != null) {
                friendlyByteBuf.method_10804(blockEntities.size());
                for (Short2ObjectMap.Entry entry2 : blockEntities.short2ObjectEntrySet()) {
                    friendlyByteBuf.method_52998((int)entry2.getShortKey());
                    ((CompressedBlockEntity)entry2.getValue()).write(friendlyByteBuf);
                }
                continue;
            }
            friendlyByteBuf.method_10804(0);
        }
        friendlyByteBuf.method_52974(PositionUtils.MIN_POSITION_LONG);
    }

    public static BlockBuffer loadNBT(class_2540 friendlyByteBuf, int dataVersion) {
        long index;
        BlockBuffer buffer = new BlockBuffer();
        while ((index = friendlyByteBuf.readLong()) != PositionUtils.MIN_POSITION_LONG) {
            int blockEntitySize;
            class_2487 tag = friendlyByteBuf.method_10798();
            if (tag != null && !tag.method_33133()) {
                tag = DFUHelper.updatePalettedContainer(tag, dataVersion);
                class_2841 palettedContainer = (class_2841)VersionUtils.getOrThrow(BLOCK_STATE_CODEC.parse((DynamicOps)class_2509.field_11560, (Object)tag));
                buffer.putSection(index, (class_2841<class_2680>)palettedContainer);
            }
            if ((blockEntitySize = Math.min(4096, friendlyByteBuf.method_10816())) <= 0) continue;
            Short2ObjectOpenHashMap map = new Short2ObjectOpenHashMap(blockEntitySize);
            for (int i = 0; i < blockEntitySize; ++i) {
                short offset = friendlyByteBuf.readShort();
                CompressedBlockEntity blockEntity = CompressedBlockEntity.read(friendlyByteBuf);
                map.put(offset, (Object)blockEntity);
            }
            buffer.blockEntities.put(index, (Object)map);
        }
        return buffer;
    }

    public void putBlockEntity(int x, int y, int z, CompressedBlockEntity blockEntity) {
        long cpos = class_2338.method_10064((int)(x >> 4), (int)(y >> 4), (int)(z >> 4));
        Short2ObjectMap chunkMap = (Short2ObjectMap)this.blockEntities.computeIfAbsent(cpos, k -> new Short2ObjectOpenHashMap());
        int key = x & 0xF | (y & 0xF) << 4 | (z & 0xF) << 8;
        chunkMap.put((short)key, (Object)blockEntity);
    }

    @Nullable
    public CompressedBlockEntity getBlockEntity(int x, int y, int z) {
        long cpos = class_2338.method_10064((int)(x >> 4), (int)(y >> 4), (int)(z >> 4));
        Short2ObjectMap chunkMap = (Short2ObjectMap)this.blockEntities.get(cpos);
        if (chunkMap == null) {
            return null;
        }
        int key = x & 0xF | (y & 0xF) << 4 | (z & 0xF) << 8;
        return (CompressedBlockEntity)chunkMap.get((short)key);
    }

    @Nullable
    public Short2ObjectMap<CompressedBlockEntity> getBlockEntityChunkMap(long cpos) {
        return (Short2ObjectMap)this.blockEntities.get(cpos);
    }

    public class_2680 get(int x, int y, int z) {
        class_2841<class_2680> container = this.getSectionForCoord(x, y, z);
        if (container == null) {
            return null;
        }
        class_2680 state = (class_2680)container.method_12321(x & 0xF, y & 0xF, z & 0xF);
        if (state == EMPTY_STATE) {
            return null;
        }
        return state;
    }

    public int getSectionCount() {
        return this.values.size();
    }

    public void set(int x, int y, int z, class_2680 state) {
        class_2841<class_2680> container = this.getOrCreateSectionForCoord(x, y, z);
        container.method_16678(x & 0xF, y & 0xF, z & 0xF, (Object)state);
    }

    public class_2680 remove(int x, int y, int z) {
        class_2841<class_2680> container = this.getSectionForCoord(x, y, z);
        if (container == null) {
            return null;
        }
        class_2680 state = (class_2680)container.method_12321(x & 0xF, y & 0xF, z & 0xF);
        if (state == EMPTY_STATE) {
            return null;
        }
        container.method_35321(x & 0xF, y & 0xF, z & 0xF, (Object)EMPTY_STATE);
        return state;
    }

    public void forEach(PositionConsumer<class_2680> consumer) {
        for (Long2ObjectMap.Entry entry : this.values.long2ObjectEntrySet()) {
            int cx = class_2338.method_10061((long)entry.getLongKey()) * 16;
            int cy = class_2338.method_10071((long)entry.getLongKey()) * 16;
            int cz = class_2338.method_10083((long)entry.getLongKey()) * 16;
            class_2841 container = (class_2841)entry.getValue();
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < 16; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        class_2680 block = (class_2680)container.method_12321(x, y, z);
                        if (block.method_26204() == class_2246.field_10369) continue;
                        consumer.accept(cx + x, cy + y, cz + z, block);
                    }
                }
            }
        }
    }

    public LongSet keySet() {
        return this.values.keySet();
    }

    public ObjectSet<Long2ObjectMap.Entry<class_2841<class_2680>>> entrySet() {
        return this.values.long2ObjectEntrySet();
    }

    public void resetCachedLast() {
        this.lastId = PositionUtils.MIN_POSITION_LONG;
        this.last = null;
    }

    public class_2841<class_2680> getSection(int cx, int cy, int cz) {
        long id = class_2338.method_10064((int)cx, (int)cy, (int)cz);
        if (id != this.lastId) {
            this.lastId = id;
            this.last = (class_2841)this.values.get(id);
        }
        return this.last;
    }

    public class_2841<class_2680> getSectionForCoord(int x, int y, int z) {
        return this.getSection(x >> 4, y >> 4, z >> 4);
    }

    public class_2841<class_2680> getOrCreateSectionForCoord(int x, int y, int z) {
        long id = class_2338.method_10064((int)(x >> 4), (int)(y >> 4), (int)(z >> 4));
        return this.getOrCreateSection(id);
    }

    public class_2841<class_2680> getOrCreateSection(long id) {
        if (this.last == null || id != this.lastId) {
            this.lastId = id;
            this.last = (class_2841)this.values.computeIfAbsent(id, k -> new class_2841((class_2359)class_2248.field_10651, (Object)EMPTY_STATE, class_2841.class_6563.field_34569));
        }
        return this.last;
    }

    public void putSection(long id, class_2841<class_2680> palettedContainer) {
        if (this.last != null && id == this.lastId) {
            this.last = palettedContainer;
        }
        this.values.put(id, palettedContainer);
    }

    private static int pad8(int in) {
        return in + 7 & 0xFFFFFFF8;
    }

    public int estimateSizeInRAM() {
        int size = 32;
        size += 64;
        int mapArrayLength = HashCommon.arraySize((int)this.values.size(), (float)0.75f);
        size += 16 + 8 * mapArrayLength;
        size += BlockBuffer.pad8(16 + 4 * mapArrayLength);
        size += 16;
        size += 16;
        for (class_2841 palettedContainer : this.values.values()) {
            size += 32;
            size += 128;
            size += 24;
            size += 24;
            class_2841.class_6561 data = palettedContainer.field_34560;
            class_6490 bitStorage = data.comp_118();
            if (bitStorage instanceof class_6502) {
                size += 16;
            } else if (bitStorage instanceof class_3508) {
                class_3508 simpleBitStorage = (class_3508)bitStorage;
                size += 48;
                size += 16 + 8 * simpleBitStorage.method_15212().length;
            }
            class_2837 palette = data.comp_119();
            if (palette instanceof class_6564) {
                size += 32;
                continue;
            }
            if (palette instanceof class_2834) {
                size += 32;
                size += 80;
                continue;
            }
            if (palette instanceof class_2816) {
                size += 16;
                continue;
            }
            if (!(palette instanceof class_2814)) continue;
            class_2814 hashMapPalette = (class_2814)palette;
            size += 32;
            size += 32;
            size += 3 * BlockBuffer.pad8(16 + 4 * (int)((float)(1 << hashMapPalette.field_12822) / 0.8f));
        }
        size += 64;
        mapArrayLength = HashCommon.arraySize((int)this.blockEntities.size(), (float)0.75f);
        size += 16 + 8 * mapArrayLength;
        size += BlockBuffer.pad8(16 + 4 * mapArrayLength);
        size += 16;
        size += 16;
        for (Long2ObjectMap.Entry entry : this.blockEntities.long2ObjectEntrySet()) {
            size += 64;
            mapArrayLength = HashCommon.arraySize((int)((Short2ObjectMap)entry.getValue()).size(), (float)0.75f);
            size += 16 + 2 * mapArrayLength;
            size += BlockBuffer.pad8(16 + 4 * mapArrayLength);
            size += 16;
            size += 16;
            for (Short2ObjectMap.Entry entry2 : ((Short2ObjectMap)entry.getValue()).short2ObjectEntrySet()) {
                size += 4;
                ++size;
                size += ((CompressedBlockEntity)entry2.getValue()).compressed().length;
            }
        }
        return size;
    }
}

