/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.rasterization;

import com.moulberry.axiom.rasterization.Rasterization3D;
import com.moulberry.axiom.rasterization.RasterizationHelper;
import com.moulberry.axiomclientapi.funcinterfaces.TriIntConsumer;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3i;

public class SuperellipseRasterization {
    public static void superellipse(Vector3i center, int diameterX, int diameterZ, boolean hollow, float exponent, Quaternionf quaternionf, TriIntConsumer consumer) {
        if (diameterX <= 0 || diameterZ <= 0) {
            return;
        }
        int centerX = center.x;
        int centerY = center.y;
        int centerZ = center.z;
        float radiusX = (float)(diameterX - 1) / 2.0f;
        float radiusZ = (float)(diameterZ - 1) / 2.0f;
        if (hollow) {
            float offsetX = radiusX % 1.0f + 0.5f;
            float offsetZ = radiusZ % 1.0f + 0.5f;
            float invRadiusX = 1.0f / (float)Math.pow(radiusX - 0.15f, exponent);
            float invRadiusZ = 1.0f / (float)Math.pow(radiusZ - 0.15f, exponent);
            if (!Float.isFinite(invRadiusX)) {
                invRadiusX = Float.MAX_VALUE;
            }
            if (!Float.isFinite(invRadiusZ)) {
                invRadiusZ = Float.MAX_VALUE;
            }
            Vector3f from = new Vector3f(offsetX, 0.5f, radiusZ - 0.15f + offsetZ);
            quaternionf.transformInverse(from);
            Vector3f to = new Vector3f();
            boolean maxIndex = false;
            for (int a = 0; a <= 360; ++a) {
                float currX = (float)Math.sin(Math.toRadians(a)) * (radiusX - 0.15f);
                float currZ = (float)Math.cos(Math.toRadians(a)) * (radiusZ - 0.15f);
                double rxPow = Math.pow(Math.abs(currX), exponent);
                double rzPow = Math.pow(Math.abs(currZ), exponent);
                double factor = rxPow * (double)invRadiusX + rzPow * (double)invRadiusZ;
                float invFactor = (float)Math.pow(1.0 / factor, 1.0f / exponent);
                to.set((currX *= invFactor) + offsetX, 0.5f, (currZ *= invFactor) + offsetZ);
                quaternionf.transformInverse(to);
                Rasterization3D.dda(from, to, (x, y, z) -> consumer.accept(x + centerX, y + centerY, z + centerZ));
                Vector3f temp = from;
                from = to;
                to = temp;
            }
        } else {
            int powLutSize = Math.max((int)Math.ceil(radiusX), (int)Math.ceil(radiusZ)) * 10;
            float[] powLookup = new float[powLutSize];
            for (int i = 0; i < powLookup.length; ++i) {
                powLookup[i] = (float)Math.pow((float)i / 10.0f, exponent);
            }
            float invRadiusX = 1.0f / (float)Math.pow(radiusX + 0.5f, exponent);
            float invRadiusZ = 1.0f / (float)Math.pow(radiusZ + 0.5f, exponent);
            if (!Float.isFinite(invRadiusX)) {
                invRadiusX = Float.MAX_VALUE;
            }
            if (!Float.isFinite(invRadiusZ)) {
                invRadiusZ = Float.MAX_VALUE;
            }
            float invRadiusXF = invRadiusX;
            float invRadiusZF = invRadiusZ;
            RasterizationHelper.planeCondition(center, diameterX, diameterZ, quaternionf, (rx, rz) -> {
                int rxPowIndex = (int)Math.abs(rx * 10.0f);
                int rzPowIndex = (int)Math.abs(rz * 10.0f);
                if (rxPowIndex >= powLutSize) {
                    return false;
                }
                if (rzPowIndex >= powLutSize) {
                    return false;
                }
                float rxPow = powLookup[rxPowIndex];
                float rzPow = powLookup[rzPowIndex];
                return rxPow * invRadiusXF + rzPow * invRadiusZF <= 1.0f;
            }, consumer);
        }
    }
}

