/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.operations;

import com.moulberry.axiom.DefaultBlocks;
import com.moulberry.axiom.block_maps.BlockColourMap;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.clipboard.SelectionBuffer;
import com.moulberry.axiom.custom_blocks.CustomBlock;
import com.moulberry.axiom.custom_blocks.ServerCustomBlocks;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.utils.OkLabColourUtils;
import com.moulberry.axiom.utils.RegionHelper;
import com.moulberry.axiom.world_modification.Dispatcher;
import com.moulberry.axiom.world_modification.HistoryEntry;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7923;

public class GenerateColourFieldOperation {
    public static void generateColourField() {
        SelectionBuffer selectionBuffer = Selection.getSelectionBuffer();
        if (selectionBuffer instanceof SelectionBuffer.AABB) {
            SelectionBuffer.AABB aabb = (SelectionBuffer.AABB)selectionBuffer;
            GenerateColourFieldOperation.generateColourFieldAABB(aabb);
        }
    }

    private static void generateColourFieldAABB(SelectionBuffer.AABB aabb) {
        double[] lab;
        int minX = aabb.min().method_10263();
        int minY = aabb.min().method_10264();
        int minZ = aabb.min().method_10260();
        int maxX = aabb.max().method_10263();
        int maxY = aabb.max().method_10264();
        int maxZ = aabb.max().method_10260();
        ChunkedBlockRegion blockRegion = new ChunkedBlockRegion();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    blockRegion.addBlock(x, y, z, class_2246.field_10124.method_9564());
                }
            }
        }
        int collisions = 0;
        int missing = 0;
        HashMap<CustomBlock, double[]> labValues = new HashMap<CustomBlock, double[]>();
        Int2ObjectOpenHashMap blocksByColour = new Int2ObjectOpenHashMap();
        double minL = 3.4028234663852886E38;
        double maxL = 1.4E-45f;
        double minA = 3.4028234663852886E38;
        double maxA = 1.4E-45f;
        double minB = 3.4028234663852886E38;
        double maxB = 1.4E-45f;
        LinkedHashSet<class_2680> blockStates = new LinkedHashSet<class_2680>();
        for (CustomBlock customBlock : ServerCustomBlocks.customBlockMap.values()) {
            blockStates.add(customBlock.axiom$defaultCustomState().getVanillaState());
        }
        for (class_2248 class_22482 : class_7923.field_41175) {
            if (BlockColourMap.isHardIgnore(class_22482)) continue;
            blockStates.add(DefaultBlocks.forBlock(class_22482));
        }
        block5: for (class_2680 class_26802 : blockStates) {
            CustomBlock customBlock;
            if (!BlockColourMap.isFullSolidOpaque(class_26802) || (lab = BlockColourMap.getLab(customBlock = ServerCustomBlocks.getCustomOrVanillaStateFor(class_26802).getCustomBlock())) == null) continue;
            int rgb = OkLabColourUtils.lab2rgb(lab[0], lab[1], lab[2]);
            ArrayList<CustomBlock> existingBlocks = (ArrayList<CustomBlock>)blocksByColour.get(rgb);
            if (existingBlocks != null) {
                class_2960 current = customBlock.axiom$getResourceLocation();
                Iterator existingBlockIterator = existingBlocks.iterator();
                while (existingBlockIterator.hasNext()) {
                    CustomBlock existingBlock = (CustomBlock)existingBlockIterator.next();
                    class_2960 other = existingBlock.axiom$getResourceLocation();
                    if (!current.method_12836().equals(other.method_12836())) continue;
                    if (current.method_12832().endsWith(other.method_12832())) continue block5;
                    if (!other.method_12832().endsWith(current.method_12832())) continue;
                    existingBlockIterator.remove();
                    labValues.remove(existingBlock);
                }
                existingBlocks.add(customBlock);
            } else {
                existingBlocks = new ArrayList<CustomBlock>();
                existingBlocks.add(customBlock);
                blocksByColour.put(rgb, existingBlocks);
            }
            labValues.put(customBlock, lab);
            minL = Math.min(minL, lab[0]);
            maxL = Math.max(maxL, lab[0]);
            minA = Math.min(minA, lab[1]);
            maxA = Math.max(maxA, lab[1]);
            minB = Math.min(minB, lab[2]);
            maxB = Math.max(maxB, lab[2]);
        }
        for (Map.Entry entry : labValues.entrySet()) {
            double doubleZ;
            double doubleX;
            CustomBlock block = (CustomBlock)entry.getKey();
            lab = (double[])entry.getValue();
            if (maxX - minX > maxZ - minZ) {
                doubleX = (lab[0] - minL) / (maxL - minL) * (double)(maxX - minX) + (double)minX;
                doubleZ = (lab[2] - minB) / (maxB - minB) * (double)(maxZ - minZ) + (double)minZ;
            } else {
                doubleX = (lab[2] - minB) / (maxB - minB) * (double)(maxX - minX) + (double)minX;
                doubleZ = (lab[0] - minL) / (maxL - minL) * (double)(maxZ - minZ) + (double)minZ;
            }
            double doubleY = (lab[1] - minA) / (maxA - minA) * (double)(maxY - minY) + (double)minY;
            int x = (int)Math.round(doubleX);
            int y = (int)Math.round(doubleY);
            int z = (int)Math.round(doubleZ);
            if (blockRegion.getBlockStateOrAir(x, y, z).method_26215()) {
                blockRegion.addBlock(x, y, z, block.axiom$defaultCustomState().getVanillaState());
                continue;
            }
            ++collisions;
            double minDistanceSq = Double.MAX_VALUE;
            int closestX = 0;
            int closestY = 0;
            int closestZ = 0;
            for (int xo = -3; xo <= 3; ++xo) {
                for (int yo = -3; yo <= 3; ++yo) {
                    for (int zo = -3; zo <= 3; ++zo) {
                        double dx = doubleX - (double)(x + xo);
                        double dy = doubleY - (double)(y + yo);
                        double dz = doubleZ - (double)(z + zo);
                        double distanceSq = dx * dx + dy * dy + dz * dz;
                        if (distanceSq > minDistanceSq || x + xo < minX || x + xo > maxX || y + yo < minY || y + yo > maxY || z + zo < minZ || z + zo > maxZ || !blockRegion.getBlockStateOrAir(x + xo, y + yo, z + zo).method_26215()) continue;
                        minDistanceSq = distanceSq;
                        closestX = xo;
                        closestY = yo;
                        closestZ = zo;
                    }
                }
            }
            if (closestX == 0 && closestY == 0 && closestZ == 0) {
                ++missing;
                continue;
            }
            blockRegion.addBlock(x + closestX, y + closestY, z + closestZ, block.axiom$defaultCustomState().getVanillaState());
        }
        if (collisions > 0) {
            class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43470((String)("Encountered " + collisions + " collisions, tried to adjust positions to include every block")), false);
        }
        if (missing > 0) {
            class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43470((String)("Missing " + missing + " blocks due to insufficient space")), false);
        }
        String blockCountString = NumberFormat.getNumberInstance().format(blockRegion.count());
        RegionHelper.pushBlockRegionChange(blockRegion, "Colour Field (" + blockCountString + " blocks)", Dispatcher.simpleSourceInfo("ColourField"), HistoryEntry.MODIFIER_SELECT_ON_BACKSTEP);
    }
}

