/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.windows.clipboard;

import com.moulberry.axiom.clipboard.Clipboard;
import com.moulberry.axiom.clipboard.ClipboardObject;
import com.moulberry.axiom.clipboard.Placement;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.EditorWindowType;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.keybinds.Keybinds;
import com.moulberry.axiom.editor.tutorial.TutorialManager;
import com.moulberry.axiom.editor.tutorial.TutorialStage;
import com.moulberry.axiom.editor.windows.clipboard.BlueprintBrowserWindow;
import com.moulberry.axiom.i18n.AxiomI18n;
import imgui.ImGui;
import imgui.ImGuiViewport;
import java.text.NumberFormat;
import net.minecraft.class_2350;

public class ClipboardWindow {
    public static void render() {
        boolean showTutorial;
        boolean openBlueprintBrowser = false;
        boolean openCtxMenu = false;
        boolean bl = showTutorial = TutorialManager.getCurrentStage() == TutorialStage.CLIPBOARD;
        if (!EditorWindowType.CLIPBOARD.isOpen() && !showTutorial) {
            return;
        }
        ImGuiViewport viewport = ImGui.getMainViewport();
        ImGui.setNextWindowSize(200.0f, viewport.getSizeY() / 3.0f, 4);
        ImGui.setNextWindowPos(viewport.getPosX() + 20.0f, viewport.getPosY() + viewport.getSizeY() / 9.0f, 4);
        if (EditorWindowType.CLIPBOARD.begin("###Clipboard", true)) {
            ClipboardObject clipboard = Clipboard.INSTANCE.getClipboard();
            int buttonSize = (int)(64.0f * EditorUI.getUiScale());
            if (clipboard == null) {
                openBlueprintBrowser = ImGui.button(AxiomI18n.get("axiom.editorui.window.clipboard.empty"), buttonSize, buttonSize);
                openCtxMenu = ImGui.isItemClicked(1);
                ImGui.textDisabled(AxiomI18n.get("axiom.editorui.window.clipboard.copy_hint", Keybinds.COPY.shortKeyIdentifier()));
            } else {
                int thumbnailTextureId = clipboard.thumbnailTextureId();
                int imageSize = (int)(96.0f * EditorUI.getUiScale());
                openBlueprintBrowser = thumbnailTextureId == -1 ? ImGui.button("##TooBig", imageSize, imageSize) : ImGui.imageButton(clipboard.thumbnailTextureId(), imageSize, imageSize, 0.0f, 1.0f, 1.0f, 0.0f, 2);
                openCtxMenu = ImGui.isItemClicked(1);
                ImGui.sameLine();
                ImGui.beginGroup();
                ImGui.text(clipboard.name().isBlank() ? AxiomI18n.get("axiom.editorui.window.blueprint_browser.unnamed_blueprint") : clipboard.name());
                int blockCount = clipboard.blockRegion().count();
                int blockEntityCount = clipboard.blockEntities().size();
                int entityCount = clipboard.entities().size();
                if (blockCount == 1) {
                    ImGui.text(AxiomI18n.get("axiom.editorui.window.clipboard.single_block"));
                } else {
                    ImGui.text(AxiomI18n.get("axiom.editorui.window.clipboard.n_blocks", NumberFormat.getNumberInstance().format(blockCount)));
                }
                if (blockEntityCount == 1) {
                    ImGui.text(AxiomI18n.get("axiom.editorui.window.clipboard.single_block_entity"));
                } else if (blockEntityCount > 1) {
                    ImGui.text(AxiomI18n.get("axiom.editorui.window.clipboard.n_block_entities", NumberFormat.getNumberInstance().format(blockEntityCount)));
                }
                boolean pastingEntities = Placement.INSTANCE.pasteEntities;
                String extra = "";
                if (!pastingEntities) {
                    ImGui.beginDisabled();
                    extra = " (disabled)";
                }
                if (entityCount == 1) {
                    ImGui.text(AxiomI18n.get("axiom.editorui.window.clipboard.single_entity") + extra);
                } else if (entityCount > 1) {
                    ImGui.text(AxiomI18n.get("axiom.editorui.window.clipboard.n_entities", NumberFormat.getNumberInstance().format(entityCount)) + extra);
                }
                if (!pastingEntities) {
                    ImGui.endDisabled();
                }
                ImGui.endGroup();
            }
            if (!Placement.INSTANCE.isPlacing() && clipboard != null) {
                ImGui.textDisabled(AxiomI18n.get("axiom.editorui.window.clipboard.paste_hint", Keybinds.PASTE.shortKeyIdentifier()));
            }
            if (showTutorial) {
                TutorialStage.CLIPBOARD.render(ImGui.getWindowPos(), ImGui.getWindowSize());
            }
        } else if (showTutorial) {
            TutorialManager.nextTutorialStage();
        }
        EditorWindowType.CLIPBOARD.end();
        if (openBlueprintBrowser) {
            BlueprintBrowserWindow.open(null, false);
        }
        if (openCtxMenu) {
            ImGui.openPopup("###ClipboardCtxMenu");
        }
        if (ImGuiHelper.beginPopup("###ClipboardCtxMenu")) {
            if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.window.clipboard.clear"))) {
                Clipboard.INSTANCE.clearClipboard();
            }
            if (ImGui.menuItem("Rotate Clockwise (X)")) {
                Clipboard.INSTANCE.rotate(class_2350.class_2351.field_11048, -1);
            }
            if (ImGui.menuItem("Rotate Clockwise (Y)")) {
                Clipboard.INSTANCE.rotate(class_2350.class_2351.field_11052, -1);
            }
            if (ImGui.menuItem("Rotate Clockwise (Z)")) {
                Clipboard.INSTANCE.rotate(class_2350.class_2351.field_11051, -1);
            }
            if (ImGui.menuItem("Flip (X)")) {
                Clipboard.INSTANCE.flip(class_2350.class_2351.field_11048);
            }
            if (ImGui.menuItem("Flip (Y)")) {
                Clipboard.INSTANCE.flip(class_2350.class_2351.field_11052);
            }
            if (ImGui.menuItem("Flip (Z)")) {
                Clipboard.INSTANCE.flip(class_2350.class_2351.field_11051);
            }
            ImGui.endPopup();
        }
    }
}

