/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.buildertools;

import com.moulberry.axiom.ClientEvents;
import com.moulberry.axiom.buildertools.BuilderTool;
import com.moulberry.axiom.buildertools.BuilderToolManager;
import com.moulberry.axiom.collections.Position2ObjectMap;
import com.moulberry.axiom.editor.keybinds.Keybinds;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.render.EffectRenderer;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.utils.Box;
import com.moulberry.axiom.utils.RegionHelper;
import com.moulberry.axiom.world_modification.Dispatcher;
import com.moulberry.axiom.world_modification.HistoryEntry;
import java.text.NumberFormat;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.joml.Matrix4f;

public class SmearBuilderTool
implements BuilderTool {
    private class_2338.class_2339 pos1 = null;
    private class_2338.class_2339 pos2 = null;
    private class_2338.class_2339 smearDirections = null;
    private final ChunkedBlockRegion blockRegion = new ChunkedBlockRegion();

    @Override
    public void renderScreen(class_332 guiGraphics, int screenWidth, int screenHeight, float partialTick) {
        if (this.pos1 == null) {
            BuilderTool.renderKeybindHelp(guiGraphics, screenWidth, screenHeight, AxiomI18n.get("axiom.buildertool.first_point"), class_310.method_1551().field_1690.field_1886, 0);
        } else if (this.pos2 == null) {
            BuilderTool.renderKeybindHelp(guiGraphics, screenWidth, screenHeight, AxiomI18n.get("axiom.buildertool.second_point"), class_310.method_1551().field_1690.field_1904, 0);
        } else if (this.smearDirections == null) {
            if (ClientEvents.builderToolNudgeScrollKeyBind.method_1434()) {
                BuilderTool.renderScrollHelp(guiGraphics, screenWidth, screenHeight, AxiomI18n.get("axiom.buildertool.scroll_nudge"), 0);
            } else {
                BuilderTool.renderScrollHelp(guiGraphics, screenWidth, screenHeight, AxiomI18n.get("axiom.buildertool.smear.scroll"), 0);
                BuilderTool.renderKeybindHelp(guiGraphics, screenWidth, screenHeight, AxiomI18n.get("axiom.buildertool.scroll_extend"), class_310.method_1551().field_1690.field_1871, 1);
            }
        } else {
            BuilderTool.renderKeybindHelp(guiGraphics, screenWidth, screenHeight, AxiomI18n.get("axiom.buildertool.cancel"), class_310.method_1551().field_1690.field_1886, 0);
            BuilderTool.renderKeybindHelp(guiGraphics, screenWidth, screenHeight, AxiomI18n.get("axiom.buildertool.confirm"), class_310.method_1551().field_1690.field_1904, 1);
            BuilderTool.renderKeybindHelp(guiGraphics, screenWidth, screenHeight, AxiomI18n.get("axiom.buildertool.smear.smear_to"), class_310.method_1551().field_1690.field_1871, 2);
        }
    }

    @Override
    public void handleInput(boolean nudgeForwards, boolean nudgeBackwards) {
        if (nudgeForwards) {
            this.nudge(1);
        }
        if (nudgeBackwards) {
            this.nudge(-1);
        }
    }

    @Override
    public void renderWorld(class_4184 camera, long time, class_4587 matrices, Matrix4f projection) {
        if (this.smearDirections != null) {
            this.blockRegion.render(camera, class_243.field_1353, matrices, projection, 0.8f, 0.0f);
        }
        if (this.pos1 != null && class_310.method_1551().field_1755 == null && Keybinds.BUILDER_TOOL_DELETE.isDown()) {
            if (this.smearDirections == null) {
                BuilderTool.delete((class_2338)this.pos1, (class_2338)(this.pos2 != null ? this.pos2 : this.pos1));
            }
            this.reset(false);
        }
        if (this.pos1 != null && this.pos2 != null) {
            int minX = Math.min(this.pos1.method_10263(), this.pos2.method_10263());
            int minY = Math.min(this.pos1.method_10264(), this.pos2.method_10264());
            int minZ = Math.min(this.pos1.method_10260(), this.pos2.method_10260());
            int maxX = Math.max(this.pos1.method_10263(), this.pos2.method_10263());
            int maxY = Math.max(this.pos1.method_10264(), this.pos2.method_10264());
            int maxZ = Math.max(this.pos1.method_10260(), this.pos2.method_10260());
            if (this.smearDirections != null) {
                minX += this.smearDirections.method_10263();
                minY += this.smearDirections.method_10264();
                minZ += this.smearDirections.method_10260();
                maxX += this.smearDirections.method_10263();
                maxY += this.smearDirections.method_10264();
                maxZ += this.smearDirections.method_10260();
            }
            BuilderTool.renderBoxWithArrow(BuilderTool.calculateDirection(), camera, time, matrices, projection, minX, minY, minZ, maxX, maxY, maxZ);
        } else if (this.pos1 != null) {
            float x = this.pos1.method_10263();
            float y = this.pos1.method_10264();
            float z = this.pos1.method_10260();
            EffectRenderer.renderBoundingBox(camera, time, matrices, new class_243((double)x, (double)y, (double)z), new class_243((double)(x + 1.0f), (double)(y + 1.0f), (double)(z + 1.0f)), 3);
        }
    }

    @Override
    public boolean setPos1(class_2338 position) {
        if (this.smearDirections == null) {
            this.pos1 = position.method_25503();
            this.showTextInActionBar();
        }
        return true;
    }

    @Override
    public boolean setPos2(class_2338 position) {
        if (this.smearDirections == null) {
            this.pos2 = position.method_25503();
            this.showTextInActionBar();
        }
        return true;
    }

    @Override
    public void leftClick(class_239 hitResult) {
        if (this.smearDirections != null) {
            this.reset(false);
        } else if (hitResult.method_17783() == class_239.class_240.field_1332) {
            this.pos1 = ((class_3965)hitResult).method_17777().method_25503();
            this.showTextInActionBar();
        }
    }

    @Override
    public void rightClick(class_239 hitResult) {
        if (this.smearDirections != null) {
            this.reset(true);
        } else if (this.pos1 != null && hitResult.method_17783() == class_239.class_240.field_1332) {
            this.pos2 = ((class_3965)hitResult).method_17777().method_25503();
            this.showTextInActionBar();
        }
    }

    @Override
    public void middleClick(class_239 hitResult) {
        if (hitResult.method_17783() == class_239.class_240.field_1332 && hitResult instanceof class_3965) {
            class_3965 blockHitResult = (class_3965)hitResult;
            if (this.smearDirections != null) {
                int minX = Math.min(this.pos1.method_10263(), this.pos2.method_10263());
                int minY = Math.min(this.pos1.method_10264(), this.pos2.method_10264());
                int minZ = Math.min(this.pos1.method_10260(), this.pos2.method_10260());
                int maxX = Math.max(this.pos1.method_10263(), this.pos2.method_10263());
                int maxY = Math.max(this.pos1.method_10264(), this.pos2.method_10264());
                int maxZ = Math.max(this.pos1.method_10260(), this.pos2.method_10260());
                class_2338 target = blockHitResult.method_17777().method_10093(blockHitResult.method_17780());
                if (target.method_10263() < minX) {
                    this.smearDirections.method_33097(target.method_10263() - minX);
                } else if (target.method_10263() > maxX) {
                    this.smearDirections.method_33097(target.method_10263() - maxX);
                } else {
                    this.smearDirections.method_33097(0);
                }
                if (target.method_10264() < minY) {
                    this.smearDirections.method_33098(target.method_10264() - minY);
                } else if (target.method_10264() > maxY) {
                    this.smearDirections.method_33098(target.method_10264() - maxY);
                } else {
                    this.smearDirections.method_33098(0);
                }
                if (target.method_10260() < minZ) {
                    this.smearDirections.method_33099(target.method_10260() - minZ);
                } else if (target.method_10260() > maxZ) {
                    this.smearDirections.method_33099(target.method_10260() - maxZ);
                } else {
                    this.smearDirections.method_33099(0);
                }
                this.updateSmear();
            } else if (this.pos1 == null) {
                this.pos1 = blockHitResult.method_17777().method_25503();
            } else if (this.pos2 == null) {
                this.pos2 = blockHitResult.method_17777().method_25503();
            } else {
                class_2338 pos = ((class_3965)hitResult).method_17777();
                BuilderTool.extend(pos, this.pos1, this.pos2);
            }
            this.showTextInActionBar();
        }
    }

    private void apply() {
        if (this.smearDirections != null && (this.smearDirections.method_10263() != 0 || this.smearDirections.method_10264() != 0 || this.smearDirections.method_10260() != 0)) {
            String description = AxiomI18n.get("axiom.history_description.smeared", NumberFormat.getInstance().format(this.blockRegion.count()));
            int flags = HistoryEntry.MODIFIER_CAN_BE_UNDONE_INGAME;
            if (BuilderToolManager.keepExisting) {
                flags |= HistoryEntry.MODIFIER_KEEP_EXISTING;
            }
            RegionHelper.pushBlockRegionChangeWithNBT(this.blockRegion, description, Dispatcher.simpleSourceInfo("Smear Builder Tool"), flags, null);
        }
    }

    @Override
    public boolean scroll(int scroll) {
        if (this.pos1 == null || this.pos2 == null) {
            return false;
        }
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return false;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return false;
        }
        if (!BuilderTool.applyLimitBounds(this.pos1, this.pos2)) {
            return true;
        }
        class_2350 dir = BuilderTool.calculateDirection();
        if (this.smearDirections == null) {
            if (ClientEvents.builderToolNudgeScrollKeyBind.method_1434()) {
                this.nudge(scroll);
                return true;
            }
            this.smearDirections = new class_2338.class_2339();
        }
        this.smearDirections.method_10104(dir, scroll);
        this.showTextInActionBar();
        this.updateSmear();
        return true;
    }

    private void updateSmear() {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        this.blockRegion.clear();
        int minX = Math.min(this.pos1.method_10263(), this.pos2.method_10263());
        int minY = Math.min(this.pos1.method_10264(), this.pos2.method_10264());
        int minZ = Math.min(this.pos1.method_10260(), this.pos2.method_10260());
        int maxX = Math.max(this.pos1.method_10263(), this.pos2.method_10263());
        int maxY = Math.max(this.pos1.method_10264(), this.pos2.method_10264());
        int maxZ = Math.max(this.pos1.method_10260(), this.pos2.method_10260());
        int smearX = this.smearDirections.method_10263();
        int smearY = this.smearDirections.method_10264();
        int smearZ = this.smearDirections.method_10260();
        int maxSmear = Math.max(Math.abs(smearX), Math.max(Math.abs(smearY), Math.abs(smearZ)));
        if (maxSmear == 0) {
            return;
        }
        record BlockStateWithDistance(class_2680 blockState, int distanceSq) {
        }
        Position2ObjectMap<BlockStateWithDistance> blockMap = new Position2ObjectMap<BlockStateWithDistance>(k -> new BlockStateWithDistance[4096]);
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        for (int x2 = minX; x2 <= maxX; ++x2) {
            for (int y2 = minY; y2 <= maxY; ++y2) {
                block2: for (int z2 = minZ; z2 <= maxZ; ++z2) {
                    class_2680 blockState = level.method_8320((class_2338)mutableBlockPos.method_10103(x2, y2, z2));
                    if (!BuilderToolManager.copyAir && blockState.method_26215()) continue;
                    for (int driver = 1; driver <= maxSmear; ++driver) {
                        int nx = x2 + Math.round((float)(driver * smearX) / (float)maxSmear);
                        int ny = y2 + Math.round((float)(driver * smearY) / (float)maxSmear);
                        int nz = z2 + Math.round((float)(driver * smearZ) / (float)maxSmear);
                        if (BuilderToolManager.copyAir) {
                            if (!blockState.method_26215()) {
                                if (nx >= minX && nx <= maxX && ny >= minY && ny <= maxY && nz >= minZ && nz <= maxZ) continue;
                                if (!level.method_8320((class_2338)mutableBlockPos.method_10103(nx, ny, nz)).method_45474()) {
                                    continue block2;
                                }
                            }
                        } else if (!level.method_8320((class_2338)mutableBlockPos.method_10103(nx, ny, nz)).method_45474()) {
                            if (nx < minX || nx > maxX || ny < minY || ny > maxY || nz < minZ || nz > maxZ) continue block2;
                            continue;
                        }
                        BlockStateWithDistance bswd2 = (BlockStateWithDistance)blockMap.get(nx, ny, nz);
                        int distanceSq = (nx - x2) * (nx - x2) + (ny - y2) * (ny - y2) + (nz - z2) * (nz - z2);
                        if (bswd2 != null && distanceSq >= bswd2.distanceSq) continue;
                        blockMap.put(nx, ny, nz, new BlockStateWithDistance(blockState, distanceSq));
                    }
                }
            }
        }
        blockMap.forEachEntry((x, y, z, bswd) -> this.blockRegion.addBlock(x, y, z, bswd.blockState));
    }

    private void nudge(int amount) {
        if (this.smearDirections != null || this.pos1 == null) {
            return;
        }
        BuilderTool.nudge(this.pos1, this.pos2, amount);
        this.showTextInActionBar();
    }

    private void showTextInActionBar() {
        if (this.smearDirections != null) {
            class_310.method_1551().field_1705.method_1758((class_2561)class_2561.method_43470((String)"Smear Offset: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)(this.smearDirections.method_10263() + " ")).method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)(this.smearDirections.method_10264() + " ")).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)("" + this.smearDirections.method_10260())).method_27692(class_124.field_1075)), false);
        } else if (this.pos1 != null && this.pos2 != null) {
            int sizeX = Math.abs(this.pos1.method_10263() - this.pos2.method_10263()) + 1;
            int sizeY = Math.abs(this.pos1.method_10264() - this.pos2.method_10264()) + 1;
            int sizeZ = Math.abs(this.pos1.method_10260() - this.pos2.method_10260()) + 1;
            class_310.method_1551().field_1705.method_1758((class_2561)class_2561.method_43470((String)"Size: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)(sizeX + " ")).method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)(sizeY + " ")).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)("" + sizeZ)).method_27692(class_124.field_1075)), false);
        }
    }

    @Override
    public boolean shouldRenderBlockOutline(class_2338 blockPos) {
        if (this.pos1 != null) {
            if (this.pos2 != null) {
                if (this.smearDirections != null) {
                    return false;
                }
                int minX = Math.min(this.pos1.method_10263(), this.pos2.method_10263());
                int minY = Math.min(this.pos1.method_10264(), this.pos2.method_10264());
                int minZ = Math.min(this.pos1.method_10260(), this.pos2.method_10260());
                int maxX = Math.max(this.pos1.method_10263(), this.pos2.method_10263());
                int maxY = Math.max(this.pos1.method_10264(), this.pos2.method_10264());
                int maxZ = Math.max(this.pos1.method_10260(), this.pos2.method_10260());
                int x = blockPos.method_10263();
                int y = blockPos.method_10264();
                int z = blockPos.method_10260();
                return x < minX || x > maxX || y < minY || y > maxY || z < minZ || z > maxZ;
            }
            return !blockPos.equals((Object)this.pos1);
        }
        return true;
    }

    @Override
    public String getName() {
        return AxiomI18n.get("axiom.buildertool.smear");
    }

    @Override
    public boolean canBeReset() {
        return this.pos1 != null || this.pos2 != null || this.smearDirections != null;
    }

    @Override
    public void reset(boolean apply) {
        if (apply && this.pos1 != null && this.pos2 != null && this.smearDirections != null) {
            this.apply();
        }
        this.pos1 = null;
        this.pos2 = null;
        this.blockRegion.clear();
        this.smearDirections = null;
    }

    @Override
    public Box getBox() {
        if (this.pos1 == null || this.smearDirections != null) {
            return null;
        }
        return new Box((class_2338)this.pos1, (class_2338)this.pos2);
    }

    @Override
    public void setBox(Box box) {
        this.pos1 = box.pos1().method_25503();
        this.pos2 = box.pos2() == null ? null : box.pos2().method_25503();
    }
}

