/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.buildertools;

import com.moulberry.axiom.AxiomClient;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.buildertools.BuilderTool;
import com.moulberry.axiom.buildertools.CloneBuilderTool;
import com.moulberry.axiom.buildertools.EraseBuilderTool;
import com.moulberry.axiom.buildertools.ExtrudeBuilderTool;
import com.moulberry.axiom.buildertools.MirrorBuilderTool;
import com.moulberry.axiom.buildertools.MoveBuilderTool;
import com.moulberry.axiom.buildertools.SmearBuilderTool;
import com.moulberry.axiom.buildertools.StackBuilderTool;
import com.moulberry.axiom.configuration.Configuration;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.utils.Box;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.joml.Matrix4f;

public class BuilderToolManager {
    private static final List<BuilderTool> tools = List.of(new MoveBuilderTool(), new CloneBuilderTool(), new StackBuilderTool(), new SmearBuilderTool(), new ExtrudeBuilderTool(), new EraseBuilderTool(), new MirrorBuilderTool());
    private static boolean toolSlotActive = false;
    private static int toolSlotSelected = 0;
    public static boolean copyAir = false;
    public static boolean copyEntities = true;
    public static boolean keepExisting = false;

    public static int scroll(int from, int to, int dir) {
        if (!AxiomClient.isAxiomActive()) {
            return -1;
        }
        if (!toolSlotActive && !Configuration.rendering.showBuilderToolSlot) {
            return -1;
        }
        if (toolSlotActive) {
            if (tools.get(toolSlotSelected).scroll(dir)) {
                return from;
            }
            BuilderToolManager.setToolSlotActive(false);
            return dir > 0 ? 8 : 0;
        }
        if (from == 8 && to == 0) {
            BuilderToolManager.setToolSlotActive(true);
            return from;
        }
        if (from == 0 && to == 8) {
            BuilderToolManager.setToolSlotActive(true);
            return from;
        }
        return -1;
    }

    public static void setToolSlotActive(boolean active) {
        if (active && !AxiomClient.isAxiomActive()) {
            return;
        }
        if (toolSlotActive != active) {
            tools.get(toolSlotSelected).reset(true);
            toolSlotActive = active;
        }
    }

    public static boolean isToolSlotActive() {
        if (!AxiomClient.isAxiomActive()) {
            toolSlotActive = false;
            return false;
        }
        return !EditorUI.isActive() && toolSlotActive;
    }

    public static boolean selectedToolIs(Class<? extends BuilderTool> clazz) {
        return clazz.isAssignableFrom(tools.get(toolSlotSelected).getClass());
    }

    public static int getToolSlotSelected() {
        return toolSlotSelected;
    }

    public static int getToolCount() {
        return tools.size();
    }

    public static String getToolName(int index) {
        return tools.get(index).getName();
    }

    public static void setToolSlotSelected(int slot) {
        if (toolSlotSelected != (slot %= tools.size())) {
            Box box = tools.get(toolSlotSelected).getBox();
            tools.get(toolSlotSelected).reset(true);
            tools.get(slot).reset(true);
            if (box != null) {
                tools.get(slot).setBox(box);
            }
            toolSlotSelected = slot;
        }
    }

    public static boolean shouldRenderBlockOutline(class_2338 blockPos) {
        return tools.get(toolSlotSelected).shouldRenderBlockOutline(blockPos);
    }

    public static void renderScreen(class_332 guiGraphics, int screenWidth, int screenHeight, float partialTick) {
        tools.get(toolSlotSelected).renderScreen(guiGraphics, screenWidth, screenHeight, partialTick);
    }

    public static void renderWorld(class_4184 camera, long time, class_4587 matrices, Matrix4f projection) {
        tools.get(toolSlotSelected).renderWorld(camera, time, matrices, projection);
    }

    public static List<String> getKeyHints() {
        return tools.get(toolSlotSelected).getKeyHints();
    }

    public static boolean setPos1(class_2338 position) {
        return tools.get(toolSlotSelected).setPos1(position);
    }

    public static boolean setPos2(class_2338 position) {
        return tools.get(toolSlotSelected).setPos2(position);
    }

    public static UserAction.ActionResult callAction(UserAction userAction, Object object) {
        if (!BuilderToolManager.isToolSlotActive()) {
            return UserAction.ActionResult.NOT_HANDLED;
        }
        switch (userAction) {
            case UNDO: {
                if (tools.get(toolSlotSelected).canBeReset()) {
                    tools.get(toolSlotSelected).reset(false);
                    return UserAction.ActionResult.USED_STOP;
                }
                return UserAction.ActionResult.NOT_HANDLED;
            }
            case REDO: {
                if (tools.get(toolSlotSelected).canBeReset()) {
                    return UserAction.ActionResult.USED_STOP;
                }
                return UserAction.ActionResult.NOT_HANDLED;
            }
            case LEFT_MOUSE: {
                tools.get(toolSlotSelected).leftClick(class_310.method_1551().field_1765);
                return UserAction.ActionResult.USED_STOP;
            }
            case RIGHT_MOUSE: {
                tools.get(toolSlotSelected).rightClick(class_310.method_1551().field_1765);
                return UserAction.ActionResult.USED_STOP;
            }
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    public static void middleClick(class_239 hitResult) {
        tools.get(toolSlotSelected).middleClick(hitResult);
    }

    public static void handleInput(boolean nudgeForwards, boolean nudgeBackwards) {
        tools.get(toolSlotSelected).handleInput(nudgeForwards, nudgeBackwards);
    }
}

