/*
 * Decompiled with CFR 0.152.
 */
package tamaized.ae2jeiintegration.integration.modules.jei;

import appeng.api.config.CondenserOutput;
import appeng.client.gui.AEBaseScreen;
import appeng.core.AEConfig;
import appeng.core.AppEng;
import appeng.core.FacadeCreativeTab;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.AEParts;
import appeng.core.localization.GuiText;
import appeng.core.localization.ItemModText;
import appeng.integration.abstraction.ItemListMod;
import appeng.integration.abstraction.ItemListModAdapter;
import appeng.items.parts.FacadeItem;
import appeng.menu.me.items.CraftingTermMenu;
import appeng.menu.me.items.PatternEncodingTermMenu;
import appeng.menu.me.items.WirelessCraftingTermMenu;
import appeng.recipes.AERecipeTypes;
import de.mari_023.ae2wtlib.wct.WCTMenu;
import de.mari_023.ae2wtlib.wet.WETMenu;
import java.util.Collection;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.advanced.ISimpleRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IAdvancedRegistration;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IIngredientVisibility;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.ModList;
import tamaized.ae2jeiintegration.api.integrations.jei.IngredientConverters;
import tamaized.ae2jeiintegration.integration.modules.jei.AEGuiContainerHandler;
import tamaized.ae2jeiintegration.integration.modules.jei.FacadeRegistryPlugin;
import tamaized.ae2jeiintegration.integration.modules.jei.GhostIngredientHandler;
import tamaized.ae2jeiintegration.integration.modules.jei.JeiRuntimeAdapter;
import tamaized.ae2jeiintegration.integration.modules.jei.categories.AttunementCategory;
import tamaized.ae2jeiintegration.integration.modules.jei.categories.CertusGrowthCategory;
import tamaized.ae2jeiintegration.integration.modules.jei.categories.ChargerCategory;
import tamaized.ae2jeiintegration.integration.modules.jei.categories.CondenserCategory;
import tamaized.ae2jeiintegration.integration.modules.jei.categories.EntropyManipulatorCategory;
import tamaized.ae2jeiintegration.integration.modules.jei.categories.InscriberRecipeCategory;
import tamaized.ae2jeiintegration.integration.modules.jei.categories.TransformCategory;
import tamaized.ae2jeiintegration.integration.modules.jei.converters.FluidIngredientConverter;
import tamaized.ae2jeiintegration.integration.modules.jei.converters.ItemIngredientConverter;
import tamaized.ae2jeiintegration.integration.modules.jei.recipes.AttunementRecipe;
import tamaized.ae2jeiintegration.integration.modules.jei.subtypes.FacadeSubtypeInterpreter;
import tamaized.ae2jeiintegration.integration.modules.jei.transfer.EncodePatternTransferHandler;
import tamaized.ae2jeiintegration.integration.modules.jei.transfer.UseCraftingRecipeTransfer;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public static final ResourceLocation TEXTURE = AppEng.makeId((String)"textures/guis/jei.png");
    private static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"ae2", (String)"core");

    public JEIPlugin() {
        IngredientConverters.register(new ItemIngredientConverter());
        IngredientConverters.register(new FluidIngredientConverter());
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerItemSubtypes(ISubtypeRegistration subtypeRegistry) {
        subtypeRegistry.registerSubtypeInterpreter(AEItems.FACADE.asItem(), (ISubtypeInterpreter)FacadeSubtypeInterpreter.INSTANCE);
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new TransformCategory(guiHelper), new CondenserCategory(guiHelper), new InscriberRecipeCategory(guiHelper), new ChargerCategory(guiHelper), new AttunementCategory(guiHelper), new CertusGrowthCategory(guiHelper), new EntropyManipulatorCategory(guiHelper)});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IIngredientVisibility ingredientVisibility = jeiHelpers.getIngredientVisibility();
        IRecipeTransferHandlerHelper transferHelper = registration.getTransferHelper();
        registration.addRecipeTransferHandler(new UseCraftingRecipeTransfer<CraftingTermMenu>(CraftingTermMenu.class, CraftingTermMenu.TYPE, transferHelper), RecipeTypes.CRAFTING);
        registration.addRecipeTransferHandler(new UseCraftingRecipeTransfer<WirelessCraftingTermMenu>(WirelessCraftingTermMenu.class, WirelessCraftingTermMenu.TYPE, transferHelper), RecipeTypes.CRAFTING);
        registration.addUniversalRecipeTransferHandler(new EncodePatternTransferHandler<PatternEncodingTermMenu>(PatternEncodingTermMenu.TYPE, PatternEncodingTermMenu.class, transferHelper, ingredientVisibility));
        if (ModList.get().isLoaded("ae2wtlib")) {
            registration.addRecipeTransferHandler(new UseCraftingRecipeTransfer<WCTMenu>(WCTMenu.class, WCTMenu.TYPE, transferHelper), RecipeTypes.CRAFTING);
            registration.addUniversalRecipeTransferHandler(new EncodePatternTransferHandler<WETMenu>(WETMenu.TYPE, WETMenu.class, transferHelper, ingredientVisibility));
        }
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ClientLevel level = Minecraft.getInstance().level;
        assert (level != null);
        RecipeManager recipeManager = level.getRecipeManager();
        registration.addRecipes(InscriberRecipeCategory.RECIPE_TYPE, recipeManager.getAllRecipesFor(AERecipeTypes.INSCRIBER));
        registration.addRecipes(ChargerCategory.RECIPE_TYPE, recipeManager.getAllRecipesFor(AERecipeTypes.CHARGER));
        registration.addRecipes(CondenserCategory.RECIPE_TYPE, List.of(CondenserOutput.MATTER_BALLS, CondenserOutput.SINGULARITY));
        registration.addRecipes(EntropyManipulatorCategory.RECIPE_TYPE, recipeManager.getAllRecipesFor(AERecipeTypes.ENTROPY));
        registration.addRecipes(TransformCategory.RECIPE_TYPE, recipeManager.getAllRecipesFor(AERecipeTypes.TRANSFORM));
        registration.addRecipes(AttunementCategory.RECIPE_TYPE, AttunementRecipe.createAllRecipes());
        registration.addRecipes(CertusGrowthCategory.TYPE, List.of(CertusGrowthCategory.Page.values()));
        List<ItemStack> presses = List.of(AEItems.LOGIC_PROCESSOR_PRESS.stack(), AEItems.CALCULATION_PROCESSOR_PRESS.stack(), AEItems.ENGINEERING_PROCESSOR_PRESS.stack(), AEItems.SILICON_PRESS.stack());
        registration.addItemStackInfo(presses, new Component[]{GuiText.inWorldCraftingPresses.text()});
        registration.addIngredientInfo((ItemLike)AEBlocks.CRANK, new Component[]{ItemModText.CRANK_DESCRIPTION.text()});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((ItemLike)AEBlocks.CONDENSER, new RecipeType[]{CondenserCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst((ItemLike)AEBlocks.INSCRIBER, new RecipeType[]{InscriberRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst((ItemLike)AEParts.CRAFTING_TERMINAL, new RecipeType[]{RecipeTypes.CRAFTING});
        registration.addRecipeCatalyst((ItemLike)AEItems.WIRELESS_CRAFTING_TERMINAL, new RecipeType[]{RecipeTypes.CRAFTING});
        registration.addRecipeCatalyst((ItemLike)AEBlocks.CHARGER, new RecipeType[]{ChargerCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst((ItemLike)AEBlocks.CRANK, new RecipeType[]{ChargerCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst((ItemLike)AEItems.ENTROPY_MANIPULATOR, new RecipeType[]{EntropyManipulatorCategory.RECIPE_TYPE});
    }

    public void registerAdvanced(IAdvancedRegistration registration) {
        if (AEConfig.instance().isEnableFacadeRecipesInRecipeViewer()) {
            IVanillaRecipeFactory vanillaRecipeFactory = registration.getJeiHelpers().getVanillaRecipeFactory();
            FacadeItem itemFacade = (FacadeItem)AEItems.FACADE.asItem();
            ItemStack cableAnchor = AEParts.CABLE_ANCHOR.stack();
            FacadeRegistryPlugin facadeRegistryPlugin = new FacadeRegistryPlugin(vanillaRecipeFactory, itemFacade, cableAnchor);
            registration.addTypedRecipeManagerPlugin(RecipeTypes.CRAFTING, (ISimpleRecipeManagerPlugin)facadeRegistryPlugin);
        }
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        IIngredientManager ingredientManager = registration.getJeiHelpers().getIngredientManager();
        registration.addGenericGuiContainerHandler(AEBaseScreen.class, (IGuiContainerHandler)new AEGuiContainerHandler(ingredientManager));
        Class<AEBaseScreen> aeBaseScreenClass = AEBaseScreen.class;
        registration.addGhostIngredientHandler(aeBaseScreenClass, (IGhostIngredientHandler)new GhostIngredientHandler());
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        JeiRuntimeAdapter adapter = new JeiRuntimeAdapter(jeiRuntime);
        ItemListMod.setAdapter((ItemListModAdapter)adapter);
        IIngredientManager ingredientManager = jeiRuntime.getIngredientManager();
        AEConfig config = AEConfig.instance();
        if (!config.isDebugToolsEnabled()) {
            ingredientManager.removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, JEIPlugin.getDebugTools());
        }
        if (!config.isEnableFacadesInRecipeViewer()) {
            ingredientManager.removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, FacadeCreativeTab.getDisplayItems());
        }
    }

    public void onRuntimeUnavailable() {
        ItemListMod.setAdapter((ItemListModAdapter)ItemListModAdapter.none());
    }

    private static Collection<ItemStack> getDebugTools() {
        return List.of(AEBlocks.DEBUG_CUBE_GEN.stack(), AEBlocks.DEBUG_ENERGY_GEN.stack(), AEBlocks.DEBUG_ITEM_GEN.stack(), AEBlocks.DEBUG_PHANTOM_NODE.stack(), AEItems.DEBUG_CARD.stack(), AEItems.DEBUG_ERASER.stack(), AEItems.DEBUG_METEORITE_PLACER.stack(), AEItems.DEBUG_REPLICATOR_CARD.stack());
    }
}

